/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.gui.GuiListBiomes;
import com.chaosthedude.naturescompass.gui.GuiListBiomesEntry;
import com.chaosthedude.naturescompass.items.ItemNaturesCompass;
import com.chaosthedude.naturescompass.network.PacketCompassSearch;
import com.chaosthedude.naturescompass.network.PacketTeleport;
import com.chaosthedude.naturescompass.sorting.CategoryName;
import com.chaosthedude.naturescompass.sorting.ISortingCategory;
import com.chaosthedude.naturescompass.util.EnumCompassState;
import com.chaosthedude.naturescompass.util.PlayerUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiNaturesCompass
extends GuiScreen {
    private World world;
    private EntityPlayer player;
    private List<Biome> allowedBiomes;
    private ItemStack stack;
    private ItemNaturesCompass natureCompass;
    private GuiButton searchButton;
    private GuiButton teleportButton;
    private GuiButton infoButton;
    private GuiButton cancelButton;
    private GuiButton sortByButton;
    private GuiListBiomes selectionList;
    private ISortingCategory sortingCategory;

    public GuiNaturesCompass(World world, EntityPlayer player, ItemStack stack, ItemNaturesCompass natureCompass, List<Biome> allowedBiomes) {
        this.world = world;
        this.player = player;
        this.stack = stack;
        this.natureCompass = natureCompass;
        this.allowedBiomes = allowedBiomes;
        this.sortingCategory = new CategoryName();
    }

    public void func_73866_w_() {
        this.selectionList = new GuiListBiomes(this, this.field_146297_k, this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 64, 36);
        this.setupButtons();
    }

    public void func_73876_c() {
        this.teleportButton.field_146125_m = NaturesCompass.canTeleport || PlayerUtils.cheatModeEnabled(this.player);
        this.teleportButton.field_146124_l = this.natureCompass.getState(this.stack) == EnumCompassState.FOUND;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.selectionList.func_178039_p();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            GuiListBiomesEntry biomesEntry = this.selectionList.getSelectedBiome();
            if (button == this.searchButton) {
                if (biomesEntry != null) {
                    biomesEntry.selectBiome();
                }
            } else if (button == this.teleportButton) {
                this.teleport();
            } else if (button == this.infoButton) {
                biomesEntry.viewInfo();
            } else if (button == this.sortByButton) {
                this.sortingCategory = this.sortingCategory.next();
                this.sortByButton.field_146126_j = I18n.func_135052_a((String)"string.naturescompass.sortBy", (Object[])new Object[0]) + ": " + this.sortingCategory.getLocalizedName();
                this.selectionList.refreshList();
            } else if (button == this.cancelButton) {
                this.field_146297_k.func_147108_a(null);
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.selectionList.func_148128_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"string.naturescompass.selectBiome", (Object[])new Object[0]), this.field_146294_l / 2, 20, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.selectionList.func_148179_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.selectionList.func_148181_b(mouseX, mouseY, state);
    }

    protected <T extends GuiButton> T func_189646_b(T button) {
        this.field_146292_n.add(button);
        return button;
    }

    public void selectBiome(GuiListBiomesEntry entry) {
        boolean enable;
        this.searchButton.field_146124_l = enable = entry != null;
        this.infoButton.field_146124_l = enable;
    }

    public void searchForBiome(Biome biome) {
        NaturesCompass.network.sendToServer((IMessage)new PacketCompassSearch(Biome.func_185362_a((Biome)biome), this.player.func_180425_c()));
        this.field_146297_k.func_147108_a(null);
    }

    public void teleport() {
        NaturesCompass.network.sendToServer((IMessage)new PacketTeleport());
        this.field_146297_k.func_147108_a(null);
    }

    public ISortingCategory getSortingCategory() {
        return this.sortingCategory;
    }

    public List<Biome> sortBiomes() {
        List<Biome> biomes = this.allowedBiomes;
        Collections.sort(biomes, new CategoryName());
        Collections.sort(biomes, this.sortingCategory);
        return biomes;
    }

    private void setupButtons() {
        this.field_146292_n.clear();
        this.cancelButton = this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 + 64, this.field_146295_m - 28, 90, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.sortByButton = this.func_189646_b(new GuiButton(1, this.field_146294_l / 2 - 154, this.field_146295_m - 28, 210, 20, I18n.func_135052_a((String)"string.naturescompass.sortBy", (Object[])new Object[0]) + ": " + this.sortingCategory.getLocalizedName()));
        this.infoButton = this.func_189646_b(new GuiButton(2, this.field_146294_l / 2 - 154, this.field_146295_m - 52, 150, 20, I18n.func_135052_a((String)"string.naturescompass.info", (Object[])new Object[0])));
        this.searchButton = this.func_189646_b(new GuiButton(3, this.field_146294_l / 2 + 4, this.field_146295_m - 52, 150, 20, I18n.func_135052_a((String)"string.naturescompass.search", (Object[])new Object[0])));
        this.teleportButton = this.func_189646_b(new GuiButton(4, this.field_146294_l - 126, 6, 120, 20, I18n.func_135052_a((String)"string.naturescompass.teleport", (Object[])new Object[0])));
        this.searchButton.field_146124_l = false;
        this.infoButton.field_146124_l = false;
        this.teleportButton.field_146125_m = NaturesCompass.canTeleport || PlayerUtils.cheatModeEnabled(this.player);
    }
}

