/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.util;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.config.ConfigHandler;
import com.chaosthedude.naturescompass.util.SearchResult;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.ChunkProviderSettings;

public class BiomeUtils {
    public static List<Biome> getAllowedBiomes() {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        for (Biome biome : Biome.field_185377_q) {
            if (biome == null || BiomeUtils.biomeIsBlacklisted(biome)) continue;
            biomes.add(biome);
        }
        return biomes;
    }

    public static SearchResult searchForBiome(World world, ItemStack stack, Biome biome, BlockPos startPos) {
        if (stack.func_190926_b() || stack.func_77973_b() != NaturesCompass.naturesCompass) {
            return null;
        }
        int sampleSpace = ConfigHandler.sampleSpaceModifier * BiomeUtils.getBiomeSize(world);
        int maxDist = ConfigHandler.distanceModifier * BiomeUtils.getBiomeSize(world);
        if (maxDist <= 0 || sampleSpace <= 0) {
            return new SearchResult(0, 0, maxDist, false);
        }
        BiomeProvider chunkManager = world.func_72959_q();
        double adjustedSampleSpace = (double)sampleSpace / Math.sqrt(Math.PI);
        double adjustedPi = 2.0 * Math.sqrt(Math.PI);
        double dist = 0.0;
        int i = 0;
        while (dist < (double)maxDist) {
            double z;
            double root = Math.sqrt(i);
            dist = adjustedSampleSpace * root;
            double x = (double)startPos.func_177958_n() + dist * Math.sin(adjustedPi * root);
            Biome[] biomesAtSample = chunkManager.func_76931_a(null, (int)x, (int)(z = (double)startPos.func_177952_p() + dist * Math.cos(adjustedPi * root)), 1, 1, false);
            if (biomesAtSample[0] == biome) {
                return new SearchResult((int)x, (int)z, maxDist, true);
            }
            ++i;
        }
        return new SearchResult(0, 0, maxDist, false);
    }

    public static int getBiomeSize(World world) {
        String settings = world.func_72912_H().func_82571_y();
        return ChunkProviderSettings.Factory.func_177865_a((String)settings).func_177864_b().field_177780_G;
    }

    public static int getDistanceToBiome(EntityPlayer player, int x, int z) {
        return (int)player.func_70011_f((double)x, player.field_70163_u, (double)z);
    }

    public static String getBiomeName(Biome biome) {
        if (biome != null && biome.func_185359_l() != null) {
            if (ConfigHandler.fixBiomeNames) {
                String original = biome.func_185359_l();
                String fixed = "";
                char pre = ' ';
                for (int i = 0; i < original.length(); ++i) {
                    char c = original.charAt(i);
                    if (Character.isUpperCase(c) && Character.isLowerCase(pre) && Character.isAlphabetic(pre)) {
                        fixed = fixed + " ";
                    }
                    fixed = fixed + String.valueOf(c);
                    pre = c;
                }
                return fixed;
            }
            return biome.func_185359_l();
        }
        return "";
    }

    public static String getBiomeName(int biomeID) {
        return BiomeUtils.getBiomeName(Biome.func_185357_a((int)biomeID));
    }

    public static boolean biomeIsBlacklisted(Biome biome) {
        List<String> biomeBlacklist = ConfigHandler.getBiomeBlacklist();
        return biomeBlacklist.contains(String.valueOf(Biome.func_185362_a((Biome)biome))) || biomeBlacklist.contains(BiomeUtils.getBiomeName(biome)) || biomeBlacklist.contains(biome.func_185359_l());
    }
}

