/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.gui.GuiNaturesCompass;
import com.chaosthedude.naturescompass.gui.GuiTransparentButton;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiBiomeInfo
extends GuiScreen {
    private GuiNaturesCompass parentScreen;
    private Biome biome;
    private GuiButton searchButton;
    private GuiButton backButton;
    private String topBlock;
    private String fillerBlock;
    private String baseHeight;
    private String heightVariation;
    private String precipitation;
    private String climate;
    private String rainfall;
    private String highHumidity;

    public GuiBiomeInfo(GuiNaturesCompass parentScreen, Biome biome) {
        this.parentScreen = parentScreen;
        this.biome = biome;
        this.topBlock = biome.func_203944_q().func_204108_a().func_177230_c().func_200291_n().func_150254_d();
        this.fillerBlock = biome.func_203944_q().func_204109_b().func_177230_c().func_200291_n().func_150254_d();
        this.baseHeight = biome.func_185355_j() < -1.0f ? I18n.func_135052_a((String)"string.naturescompass.veryLow", (Object[])new Object[0]) : (biome.func_185355_j() < 0.0f ? I18n.func_135052_a((String)"string.naturescompass.low", (Object[])new Object[0]) : ((double)biome.func_185355_j() < 0.4 ? I18n.func_135052_a((String)"string.naturescompass.average", (Object[])new Object[0]) : (biome.func_185355_j() < 1.0f ? I18n.func_135052_a((String)"string.naturescompass.high", (Object[])new Object[0]) : I18n.func_135052_a((String)"string.naturescompass.veryHigh", (Object[])new Object[0]))));
        this.heightVariation = (double)biome.func_185360_m() < 0.3 ? I18n.func_135052_a((String)"string.naturescompass.average", (Object[])new Object[0]) : ((double)biome.func_185360_m() < 0.6 ? I18n.func_135052_a((String)"string.naturescompass.high", (Object[])new Object[0]) : I18n.func_135052_a((String)"string.naturescompass.veryHigh", (Object[])new Object[0]));
        this.precipitation = biome.func_201851_b() == Biome.RainType.SNOW ? I18n.func_135052_a((String)"string.naturescompass.snow", (Object[])new Object[0]) : (biome.func_201851_b() == Biome.RainType.RAIN ? I18n.func_135052_a((String)"string.naturescompass.rain", (Object[])new Object[0]) : I18n.func_135052_a((String)"string.naturescompass.none", (Object[])new Object[0]));
        this.climate = biome.func_150561_m() == Biome.TempCategory.COLD ? I18n.func_135052_a((String)"string.naturescompass.cold", (Object[])new Object[0]) : (biome.func_150561_m() == Biome.TempCategory.OCEAN ? I18n.func_135052_a((String)"string.naturescompass.ocean", (Object[])new Object[0]) : (biome.func_150561_m() == Biome.TempCategory.WARM ? I18n.func_135052_a((String)"string.naturescompass.warm", (Object[])new Object[0]) : I18n.func_135052_a((String)"string.naturescompass.medium", (Object[])new Object[0])));
        this.rainfall = biome.func_76727_i() <= 0.0f ? I18n.func_135052_a((String)"string.naturescompass.none", (Object[])new Object[0]) : ((double)biome.func_76727_i() < 0.2 ? I18n.func_135052_a((String)"string.naturescompass.veryLow", (Object[])new Object[0]) : ((double)biome.func_76727_i() < 0.3 ? I18n.func_135052_a((String)"string.naturescompass.low", (Object[])new Object[0]) : ((double)biome.func_76727_i() < 0.5 ? I18n.func_135052_a((String)"string.naturescompass.average", (Object[])new Object[0]) : ((double)biome.func_76727_i() < 0.85 ? I18n.func_135052_a((String)"string.naturescompass.high", (Object[])new Object[0]) : I18n.func_135052_a((String)"string.naturescompass.veryHigh", (Object[])new Object[0])))));
        this.highHumidity = biome.func_76736_e() ? I18n.func_135052_a((String)"gui.yes", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.no", (Object[])new Object[0]);
    }

    public void func_73866_w_() {
        this.setupButtons();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, BiomeUtils.getBiomeNameForDisplay(this.biome), this.field_146294_l / 2, 20, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"string.naturescompass.topBlock", (Object[])new Object[0]), this.field_146294_l / 2 - 100, 40, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.topBlock, this.field_146294_l / 2 - 100, 50, 0x808080);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"string.naturescompass.precipitation", (Object[])new Object[0]), this.field_146294_l / 2 - 100, 70, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.precipitation, this.field_146294_l / 2 - 100, 80, 0x808080);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"string.naturescompass.baseHeight", (Object[])new Object[0]), this.field_146294_l / 2 - 100, 100, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.baseHeight, this.field_146294_l / 2 - 100, 110, 0x808080);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"string.naturescompass.rainfall", (Object[])new Object[0]), this.field_146294_l / 2 - 100, 130, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.rainfall, this.field_146294_l / 2 - 100, 140, 0x808080);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"string.naturescompass.fillerBlock", (Object[])new Object[0]), this.field_146294_l / 2 + 40, 40, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.fillerBlock, this.field_146294_l / 2 + 40, 50, 0x808080);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"string.naturescompass.climate", (Object[])new Object[0]), this.field_146294_l / 2 + 40, 70, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.climate, this.field_146294_l / 2 + 40, 80, 0x808080);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"string.naturescompass.heightVariation", (Object[])new Object[0]), this.field_146294_l / 2 + 40, 100, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.heightVariation, this.field_146294_l / 2 + 40, 110, 0x808080);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"string.naturescompass.highHumidity", (Object[])new Object[0]), this.field_146294_l / 2 + 40, 130, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.highHumidity, this.field_146294_l / 2 + 40, 140, 0x808080);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void setupButtons() {
        this.field_146292_n.clear();
        this.backButton = this.func_189646_b(new GuiTransparentButton(0, 10, this.field_146295_m - 30, 110, 20, I18n.func_135052_a((String)"string.naturescompass.back", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                super.func_194829_a(mouseX, mouseY);
                GuiBiomeInfo.this.field_146297_k.func_147108_a((GuiScreen)GuiBiomeInfo.this.parentScreen);
            }
        });
        this.searchButton = this.func_189646_b(new GuiTransparentButton(1, this.field_146294_l - 120, this.field_146295_m - 30, 110, 20, I18n.func_135052_a((String)"string.naturescompass.search", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                super.func_194829_a(mouseX, mouseY);
                GuiBiomeInfo.this.parentScreen.searchForBiome(GuiBiomeInfo.this.biome);
            }
        });
    }
}

