/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.gui.GuiBiomeInfo;
import com.chaosthedude.naturescompass.gui.GuiListBiomes;
import com.chaosthedude.naturescompass.gui.GuiNaturesCompass;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiListBiomesEntry
extends GuiListExtended.IGuiListEntry<GuiListBiomesEntry> {
    private final Minecraft mc;
    private final GuiNaturesCompass guiNaturesCompass;
    private final Biome biome;
    private final GuiListBiomes biomesList;
    private long lastClickTime;

    public GuiListBiomesEntry(GuiListBiomes biomesList, Biome biome) {
        this.biomesList = biomesList;
        this.biome = biome;
        this.guiNaturesCompass = biomesList.getGuiNaturesCompass();
        this.mc = Minecraft.func_71410_x();
    }

    public void func_194999_a(int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
        String precipitationState = I18n.func_135052_a((String)"string.naturescompass.none", (Object[])new Object[0]);
        if (this.biome.func_201851_b() == Biome.RainType.SNOW) {
            precipitationState = I18n.func_135052_a((String)"string.naturescompass.snow", (Object[])new Object[0]);
        } else if (this.biome.func_201851_b() == Biome.RainType.RAIN) {
            precipitationState = I18n.func_135052_a((String)"string.naturescompass.rain", (Object[])new Object[0]);
        }
        String title = this.guiNaturesCompass.getSortingCategory().getLocalizedName();
        Object value = this.guiNaturesCompass.getSortingCategory().getValue(this.biome);
        if (value == null) {
            title = I18n.func_135052_a((String)"string.naturescompass.topBlock", (Object[])new Object[0]);
            value = I18n.func_135052_a((String)this.biome.func_203944_q().func_204108_a().func_177230_c().func_149739_a(), (Object[])new Object[0]);
        }
        this.mc.field_71466_p.func_211126_b(BiomeUtils.getBiomeNameForDisplay(this.biome), (float)(this.func_195002_d() + 1), (float)(this.func_195001_c() + 1), 0xFFFFFF);
        this.mc.field_71466_p.func_211126_b(title + ": " + value, (float)(this.func_195002_d() + 1), (float)(this.func_195001_c() + this.mc.field_71466_p.field_78288_b + 3), 0x808080);
        this.mc.field_71466_p.func_211126_b(I18n.func_135052_a((String)"string.naturescompass.precipitation", (Object[])new Object[0]) + ": " + precipitationState, (float)(this.func_195002_d() + 1), (float)(this.func_195001_c() + this.mc.field_71466_p.field_78288_b + 14), 0x808080);
        this.mc.field_71466_p.func_211126_b(I18n.func_135052_a((String)"string.naturescompass.source", (Object[])new Object[0]) + ": " + BiomeUtils.getBiomeSource(this.biome), (float)(this.func_195002_d() + 1), (float)(this.func_195001_c() + this.mc.field_71466_p.field_78288_b + 25), 0x808080);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        this.biomesList.selectBiome(this.func_195003_b());
        if (Util.func_211177_b() - this.lastClickTime < 250L) {
            this.searchForBiome();
            return true;
        }
        this.lastClickTime = Util.func_211177_b();
        return false;
    }

    public void searchForBiome() {
        this.mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        this.guiNaturesCompass.searchForBiome(this.biome);
    }

    public void viewInfo() {
        this.mc.func_147108_a((GuiScreen)new GuiBiomeInfo(this.guiNaturesCompass, this.biome));
    }
}

