/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.gui.GuiListBiomes;
import com.chaosthedude.naturescompass.gui.GuiListBiomesEntry;
import com.chaosthedude.naturescompass.gui.GuiTransparentButton;
import com.chaosthedude.naturescompass.gui.GuiTransparentTextField;
import com.chaosthedude.naturescompass.items.ItemNaturesCompass;
import com.chaosthedude.naturescompass.network.PacketCompassSearch;
import com.chaosthedude.naturescompass.network.PacketTeleport;
import com.chaosthedude.naturescompass.sorting.CategoryName;
import com.chaosthedude.naturescompass.sorting.ISortingCategory;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.chaosthedude.naturescompass.util.EnumCompassState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiNaturesCompass
extends GuiScreen {
    private World world;
    private EntityPlayer player;
    private List<Biome> allowedBiomes;
    private List<Biome> biomesMatchingSearch;
    private ItemStack stack;
    private ItemNaturesCompass natureCompass;
    private GuiButton startSearchButton;
    private GuiButton teleportButton;
    private GuiButton infoButton;
    private GuiButton cancelButton;
    private GuiButton sortByButton;
    private GuiTransparentTextField searchTextField;
    private GuiListBiomes selectionList;
    private ISortingCategory sortingCategory;

    public GuiNaturesCompass(World world, EntityPlayer player, ItemStack stack, ItemNaturesCompass natureCompass, List<Biome> allowedBiomes) {
        this.world = world;
        this.player = player;
        this.stack = stack;
        this.natureCompass = natureCompass;
        this.allowedBiomes = allowedBiomes;
        this.sortingCategory = new CategoryName();
        this.biomesMatchingSearch = new ArrayList<Biome>(allowedBiomes);
    }

    public boolean mouseScrolled(double amount) {
        return this.selectionList.mouseScrolled(amount);
    }

    public void func_73866_w_() {
        this.field_146297_k.field_195559_v.func_197967_a(true);
        this.setupButtons();
        this.setupTextFields();
        if (this.selectionList == null) {
            this.selectionList = new GuiListBiomes(this, this.field_146297_k, this.field_146294_l + 110, this.field_146295_m, 40, this.field_146295_m, 45);
        }
        this.field_195124_j.add(this.selectionList);
    }

    public void func_73876_c() {
        this.searchTextField.func_146178_a();
        this.teleportButton.field_146124_l = this.natureCompass.getState(this.stack) == EnumCompassState.FOUND;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.selectionList.func_148128_a(mouseX, mouseY, partialTicks);
        this.searchTextField.func_195608_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"string.naturescompass.selectBiome", (Object[])new Object[0]), 65, 15, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        boolean ret = super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        if (this.searchTextField.func_146206_l()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public boolean charTyped(char typedChar, int keyCode) {
        boolean ret = super.charTyped(typedChar, keyCode);
        if (this.searchTextField.func_146206_l()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public void func_146281_b() {
        this.field_146297_k.field_195559_v.func_197967_a(false);
    }

    public void selectBiome(GuiListBiomesEntry entry) {
        boolean enable;
        this.startSearchButton.field_146124_l = enable = entry != null;
        this.infoButton.field_146124_l = enable;
    }

    public void searchForBiome(Biome biome) {
        NaturesCompass.network.sendToServer((Object)new PacketCompassSearch(BiomeUtils.getIDForBiome(biome), this.player.func_180425_c()));
        this.field_146297_k.func_147108_a(null);
    }

    public void teleport() {
        NaturesCompass.network.sendToServer((Object)new PacketTeleport());
        this.field_146297_k.func_147108_a(null);
    }

    public ISortingCategory getSortingCategory() {
        return this.sortingCategory;
    }

    public void processSearchTerm() {
        this.biomesMatchingSearch = new ArrayList<Biome>();
        for (Biome biome : this.allowedBiomes) {
            if (!BiomeUtils.getBiomeNameForDisplay(biome).toLowerCase().contains(this.searchTextField.func_146179_b().toLowerCase())) continue;
            this.biomesMatchingSearch.add(biome);
        }
        this.selectionList.refreshList();
    }

    public List<Biome> sortBiomes() {
        List<Biome> biomes = this.biomesMatchingSearch;
        Collections.sort(biomes, new CategoryName());
        Collections.sort(biomes, this.sortingCategory);
        return biomes;
    }

    private void setupButtons() {
        this.field_146292_n.clear();
        this.cancelButton = this.func_189646_b(new GuiTransparentButton(0, 10, this.field_146295_m - 30, 110, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiNaturesCompass.this.field_146297_k.func_147108_a(null);
            }
        });
        this.sortByButton = this.func_189646_b(new GuiTransparentButton(1, 10, 90, 110, 20, I18n.func_135052_a((String)"string.naturescompass.sortBy", (Object[])new Object[0]) + ": " + this.sortingCategory.getLocalizedName()){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiNaturesCompass.this.sortingCategory = GuiNaturesCompass.this.sortingCategory.next();
                ((GuiNaturesCompass)GuiNaturesCompass.this).sortByButton.field_146126_j = I18n.func_135052_a((String)"string.naturescompass.sortBy", (Object[])new Object[0]) + ": " + GuiNaturesCompass.this.sortingCategory.getLocalizedName();
                GuiNaturesCompass.this.selectionList.refreshList();
            }
        });
        this.infoButton = this.func_189646_b(new GuiTransparentButton(2, 10, 65, 110, 20, I18n.func_135052_a((String)"string.naturescompass.info", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                if (GuiNaturesCompass.this.selectionList.hasSelection()) {
                    GuiNaturesCompass.this.selectionList.getSelectedBiome().viewInfo();
                }
            }
        });
        this.startSearchButton = this.func_189646_b(new GuiTransparentButton(3, 10, 40, 110, 20, I18n.func_135052_a((String)"string.naturescompass.startSearch", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                if (GuiNaturesCompass.this.selectionList.hasSelection()) {
                    GuiNaturesCompass.this.selectionList.getSelectedBiome().searchForBiome();
                }
            }
        });
        this.teleportButton = this.func_189646_b(new GuiTransparentButton(4, this.field_146294_l - 120, 10, 110, 20, I18n.func_135052_a((String)"string.naturescompass.teleport", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiNaturesCompass.this.teleport();
            }
        });
        this.startSearchButton.field_146124_l = false;
        this.infoButton.field_146124_l = false;
        this.teleportButton.field_146125_m = NaturesCompass.canTeleport;
    }

    private void setupTextFields() {
        this.searchTextField = new GuiTransparentTextField(0, this.field_146289_q, 130, 10, 140, 20);
        this.searchTextField.setLabel(I18n.func_135052_a((String)"string.naturescompass.search", (Object[])new Object[0]));
        this.field_195124_j.add(this.searchTextField);
    }
}

