/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.items;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.gui.GuiWrapper;
import com.chaosthedude.naturescompass.network.PacketRequestSync;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.chaosthedude.naturescompass.util.EnumCompassState;
import com.chaosthedude.naturescompass.util.ItemUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemNaturesCompass
extends Item {
    public static final String NAME = "naturescompass";

    public ItemNaturesCompass() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78040_i));
        this.setRegistryName(NAME);
        this.func_185043_a(new ResourceLocation("angle"), new IItemPropertyGetter(){
            @OnlyIn(value=Dist.CLIENT)
            private double rotation;
            @OnlyIn(value=Dist.CLIENT)
            private double rota;
            @OnlyIn(value=Dist.CLIENT)
            private long lastUpdateTick;

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack stack, World world, EntityLivingBase entityLiving) {
                EntityLivingBase entity;
                if (entityLiving == null && !stack.func_82839_y()) {
                    return 0.0f;
                }
                boolean entityExists = entityLiving != null;
                Object object = entity = entityExists ? entityLiving : stack.func_82836_z();
                if (world == null) {
                    world = entity.field_70170_p;
                }
                double rotation = entityExists ? (double)entity.field_70177_z : this.getFrameRotation((EntityItemFrame)entity);
                double adjusted = Math.PI - (((rotation %= 360.0) - 90.0) * 0.01745329238474369 - this.getAngle(world, (Entity)entity, stack));
                if (entityExists) {
                    adjusted = this.wobble(world, adjusted);
                }
                float f = (float)(adjusted / (Math.PI * 2));
                return MathHelper.func_188207_b((float)f, (float)1.0f);
            }

            @OnlyIn(value=Dist.CLIENT)
            private double wobble(World world, double amount) {
                if (world.func_82737_E() != this.lastUpdateTick) {
                    this.lastUpdateTick = world.func_82737_E();
                    double d0 = amount - this.rotation;
                    d0 %= Math.PI * 2;
                    d0 = MathHelper.func_151237_a((double)d0, (double)-1.0, (double)1.0);
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation += this.rota;
                }
                return this.rotation;
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getFrameRotation(EntityItemFrame itemFrame) {
                return MathHelper.func_188209_b((int)(180 + itemFrame.field_174860_b.func_176736_b() * 90));
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getAngle(World world, Entity entity, ItemStack stack) {
                BlockPos pos = ItemNaturesCompass.this.getState(stack) == EnumCompassState.FOUND ? new BlockPos(ItemNaturesCompass.this.getFoundBiomeX(stack), 0, ItemNaturesCompass.this.getFoundBiomeZ(stack)) : world.func_175694_M();
                return Math.atan2((double)pos.func_177952_p() - entity.field_70161_v, (double)pos.func_177958_n() - entity.field_70165_t);
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!player.func_70093_af()) {
            if (world.field_72995_K) {
                ItemStack stack = ItemUtils.getHeldNatureCompass(player);
                NaturesCompass.network.sendToServer((Object)new PacketRequestSync());
                GuiWrapper.openGUI(world, player, stack);
            }
        } else {
            this.setState(player.func_184586_b(hand), null, EnumCompassState.INACTIVE, player);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public void searchForBiome(World world, EntityPlayer player, int biomeID, BlockPos pos, ItemStack stack) {
        this.setSearching(stack, biomeID, player);
        BiomeUtils.searchForBiome(world, player, stack, Biome.func_180276_a((int)biomeID, null), pos);
    }

    public boolean isActive(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return this.getState(stack) != EnumCompassState.INACTIVE;
        }
        return false;
    }

    public void setSearching(ItemStack stack, int biomeID, EntityPlayer player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("BiomeID", biomeID);
            stack.func_77978_p().func_74768_a("State", EnumCompassState.SEARCHING.getID());
        }
    }

    public void setFound(ItemStack stack, int x, int z, int samples, EntityPlayer player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("State", EnumCompassState.FOUND.getID());
            stack.func_77978_p().func_74768_a("FoundX", x);
            stack.func_77978_p().func_74768_a("FoundZ", z);
            stack.func_77978_p().func_74768_a("Samples", samples);
        }
    }

    public void setNotFound(ItemStack stack, EntityPlayer player, int searchRadius, int samples) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("State", EnumCompassState.NOT_FOUND.getID());
            stack.func_77978_p().func_74768_a("SearchRadius", searchRadius);
            stack.func_77978_p().func_74768_a("Samples", samples);
        }
    }

    public void setInactive(ItemStack stack, EntityPlayer player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("State", EnumCompassState.INACTIVE.getID());
        }
    }

    public void setState(ItemStack stack, BlockPos pos, EnumCompassState state, EntityPlayer player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("State", state.getID());
        }
    }

    public void setFoundBiomeX(ItemStack stack, int x, EntityPlayer player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("FoundX", x);
        }
    }

    public void setFoundBiomeZ(ItemStack stack, int z, EntityPlayer player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("FoundZ", z);
        }
    }

    public void setBiomeID(ItemStack stack, int biomeID, EntityPlayer player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("BiomeID", biomeID);
        }
    }

    public void setSearchRadius(ItemStack stack, int searchRadius, EntityPlayer player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("SearchRadius", searchRadius);
        }
    }

    public void setSamples(ItemStack stack, int samples, EntityPlayer player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("Samples", samples);
        }
    }

    public EnumCompassState getState(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return EnumCompassState.fromID(stack.func_77978_p().func_74762_e("State"));
        }
        return null;
    }

    public int getFoundBiomeX(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.func_77978_p().func_74762_e("FoundX");
        }
        return 0;
    }

    public int getFoundBiomeZ(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.func_77978_p().func_74762_e("FoundZ");
        }
        return 0;
    }

    public int getBiomeID(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.func_77978_p().func_74762_e("BiomeID");
        }
        return -1;
    }

    public int getSearchRadius(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.func_77978_p().func_74762_e("SearchRadius");
        }
        return -1;
    }

    public int getSamples(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.func_77978_p().func_74762_e("Samples");
        }
        return -1;
    }

    public int getDistanceToBiome(EntityPlayer player, ItemStack stack) {
        return (int)player.func_70011_f((double)this.getFoundBiomeX(stack), player.field_70163_u, (double)this.getFoundBiomeZ(stack));
    }
}

