/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.util.RenderUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiTransparentTextField
extends TextFieldWidget {
    private FontRenderer fontRenderer;
    private String label;
    private int labelColor = 0x808080;
    private boolean pseudoIsEnabled = true;
    private boolean pseudoEnableBackgroundDrawing = true;
    private int pseudoMaxStringLength = 32;
    private int pseudoLineScrollOffset;
    private int pseudoEnabledColor = 0xE0E0E0;
    private int pseudoDisabledColor = 0x707070;
    private int pseudoCursorCounter;
    private int pseudoSelectionEnd;

    public GuiTransparentTextField(FontRenderer fontRenderer, int x, int y, int width, int height, String label) {
        super(fontRenderer, x, y, width, height, label);
        this.fontRenderer = fontRenderer;
        this.label = label;
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        if (this.func_146176_q()) {
            boolean showLabel;
            if (this.pseudoEnableBackgroundDrawing) {
                int color = 140;
                RenderUtils.drawRect(this.x, this.y, this.x + this.width, this.y + this.height, 0x46000000);
            }
            boolean bl = showLabel = !this.isFocused() && this.func_146179_b().isEmpty();
            int i = showLabel ? this.labelColor : (this.pseudoIsEnabled ? this.pseudoEnabledColor : this.pseudoDisabledColor);
            int j = this.func_146198_h() - this.pseudoLineScrollOffset;
            int k = this.pseudoSelectionEnd - this.pseudoLineScrollOffset;
            String text = showLabel ? this.label : this.func_146179_b();
            String s = this.fontRenderer.func_78269_a(text.substring(this.pseudoLineScrollOffset), this.getWidth());
            boolean flag = j >= 0 && j <= s.length();
            boolean flag1 = this.isFocused() && this.pseudoCursorCounter / 6 % 2 == 0 && flag;
            int l = this.pseudoEnableBackgroundDrawing ? this.x + 4 : this.x;
            int i1 = this.pseudoEnableBackgroundDrawing ? this.y + (this.height - 8) / 2 : this.y;
            int j1 = l;
            if (k > s.length()) {
                k = s.length();
            }
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, j) : s;
                j1 = this.fontRenderer.func_175063_a(s1, (float)l, (float)i1, i);
            }
            boolean flag2 = this.func_146198_h() < this.func_146179_b().length() || this.func_146179_b().length() >= this.pseudoMaxStringLength;
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + this.width : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            if (!s.isEmpty() && flag && j < s.length()) {
                j1 = this.fontRenderer.func_175063_a(s.substring(j), (float)j1, (float)i1, i);
            }
            if (flag1) {
                if (flag2) {
                    this.fontRenderer.getClass();
                    RenderUtils.drawRect(k1, i1 - 1, k1 + 1, i1 + 1 + 9, -3092272);
                } else {
                    this.fontRenderer.func_175063_a("_", (float)k1, (float)i1, i);
                }
            }
            if (k != j) {
                int l1 = l + this.fontRenderer.func_78256_a(s.substring(0, k));
                this.fontRenderer.getClass();
                this.drawSelectionBox(k1, i1 - 1, l1 - 1, i1 + 1 + 9);
            }
        }
    }

    public void func_146184_c(boolean enabled) {
        super.func_146184_c(enabled);
        this.pseudoIsEnabled = enabled;
    }

    public void func_146193_g(int color) {
        super.func_146193_g(color);
        this.pseudoEnabledColor = color;
    }

    public void func_146204_h(int color) {
        super.func_146204_h(color);
        this.pseudoDisabledColor = color;
    }

    public void setFocused(boolean isFocused) {
        if (isFocused && !this.isFocused()) {
            this.pseudoCursorCounter = 0;
        }
        super.setFocused(isFocused);
    }

    public void func_146185_a(boolean enableBackgroundDrawing) {
        super.func_146185_a(enableBackgroundDrawing);
        this.pseudoEnableBackgroundDrawing = enableBackgroundDrawing;
    }

    public void func_146203_f(int length) {
        super.func_146203_f(length);
        this.pseudoMaxStringLength = length;
    }

    public void func_146178_a() {
        super.func_146178_a();
        ++this.pseudoCursorCounter;
    }

    public void func_146199_i(int position) {
        super.func_146199_i(position);
        int i = this.func_146179_b().length();
        this.pseudoSelectionEnd = MathHelper.func_76125_a((int)position, (int)0, (int)i);
        if (this.fontRenderer != null) {
            if (this.pseudoLineScrollOffset > i) {
                this.pseudoLineScrollOffset = i;
            }
            int j = this.func_146200_o();
            String s = this.fontRenderer.func_78269_a(this.func_146179_b().substring(this.pseudoLineScrollOffset), j);
            int k = s.length() + this.pseudoLineScrollOffset;
            if (this.pseudoSelectionEnd == this.pseudoLineScrollOffset) {
                this.pseudoLineScrollOffset -= this.fontRenderer.func_78262_a(this.func_146179_b(), j, true).length();
            }
            if (this.pseudoSelectionEnd > k) {
                this.pseudoLineScrollOffset += this.pseudoSelectionEnd - k;
            } else if (this.pseudoSelectionEnd <= this.pseudoLineScrollOffset) {
                this.pseudoLineScrollOffset -= this.pseudoLineScrollOffset - this.pseudoSelectionEnd;
            }
            this.pseudoLineScrollOffset = MathHelper.func_76125_a((int)this.pseudoLineScrollOffset, (int)0, (int)i);
        }
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLabelColor(int labelColor) {
        this.labelColor = labelColor;
    }

    private void drawSelectionBox(int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.x + this.width) {
            endX = this.x + this.width;
        }
        if (startX > this.x + this.width) {
            startX = this.x + this.width;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.color4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GlStateManager.disableTexture();
        GlStateManager.enableColorLogicOp();
        GlStateManager.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)startX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)endX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)endX, (double)startY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)startX, (double)startY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.disableColorLogicOp();
        GlStateManager.enableTexture();
    }
}

