/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.gui.BiomeInfoScreen;
import com.chaosthedude.naturescompass.gui.BiomeSearchList;
import com.chaosthedude.naturescompass.gui.NaturesCompassScreen;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BiomeSearchEntry
extends ExtendedList.AbstractListEntry<BiomeSearchEntry> {
    private final Minecraft mc;
    private final NaturesCompassScreen guiNaturesCompass;
    private final Biome biome;
    private final BiomeSearchList biomesList;
    private long lastClickTime;

    public BiomeSearchEntry(BiomeSearchList biomesList, Biome biome) {
        this.biomesList = biomesList;
        this.biome = biome;
        this.guiNaturesCompass = biomesList.getGuiNaturesCompass();
        this.mc = Minecraft.func_71410_x();
    }

    public void func_230432_a_(MatrixStack matrixStack, int par1, int par2, int par3, int par4, int par5, int par6, int par7, boolean par8, float par9) {
        String precipitationState = I18n.func_135052_a((String)"string.naturescompass.none", (Object[])new Object[0]);
        if (this.biome.func_201851_b() == Biome.RainType.SNOW) {
            precipitationState = I18n.func_135052_a((String)"string.naturescompass.snow", (Object[])new Object[0]);
        } else if (this.biome.func_201851_b() == Biome.RainType.RAIN) {
            precipitationState = I18n.func_135052_a((String)"string.naturescompass.rain", (Object[])new Object[0]);
        }
        String title = this.guiNaturesCompass.getSortingCategory().getLocalizedName();
        Object value = this.guiNaturesCompass.getSortingCategory().getValue(this.biome);
        if (value == null) {
            title = I18n.func_135052_a((String)"string.naturescompass.topBlock", (Object[])new Object[0]);
            value = I18n.func_135052_a((String)this.biome.func_203944_q().func_204108_a().func_177230_c().func_149739_a(), (Object[])new Object[0]);
        }
        this.mc.field_71466_p.func_238422_b_(matrixStack, (ITextProperties)new StringTextComponent(BiomeUtils.getBiomeNameForDisplay(this.biome)), (float)(par3 + 1), (float)(par2 + 1), 0xFFFFFF);
        FontRenderer fontRenderer = this.mc.field_71466_p;
        StringTextComponent stringTextComponent = new StringTextComponent(title + ": " + value);
        float f = par3 + 1;
        this.mc.field_71466_p.getClass();
        fontRenderer.func_238422_b_(matrixStack, (ITextProperties)stringTextComponent, f, (float)(par2 + 9 + 3), 0x808080);
        FontRenderer fontRenderer2 = this.mc.field_71466_p;
        StringTextComponent stringTextComponent2 = new StringTextComponent(I18n.func_135052_a((String)"string.naturescompass.precipitation", (Object[])new Object[0]) + ": " + precipitationState);
        float f2 = par3 + 1;
        this.mc.field_71466_p.getClass();
        fontRenderer2.func_238422_b_(matrixStack, (ITextProperties)stringTextComponent2, f2, (float)(par2 + 9 + 14), 0x808080);
        FontRenderer fontRenderer3 = this.mc.field_71466_p;
        StringTextComponent stringTextComponent3 = new StringTextComponent(I18n.func_135052_a((String)"string.naturescompass.source", (Object[])new Object[0]) + ": " + BiomeUtils.getBiomeSource(this.biome));
        float f3 = par3 + 1;
        this.mc.field_71466_p.getClass();
        fontRenderer3.func_238422_b_(matrixStack, (ITextProperties)stringTextComponent3, f3, (float)(par2 + 9 + 25), 0x808080);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.biomesList.selectBiome(this);
            if (Util.func_211177_b() - this.lastClickTime < 250L) {
                this.searchForBiome();
                return true;
            }
            this.lastClickTime = Util.func_211177_b();
            return false;
        }
        return false;
    }

    public void searchForBiome() {
        this.mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        this.guiNaturesCompass.searchForBiome(this.biome);
    }

    public void viewInfo() {
        this.mc.func_147108_a((Screen)new BiomeInfoScreen(this.guiNaturesCompass, this.biome));
    }
}

