/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.util;

import com.chaosthedude.naturescompass.config.ConfigHandler;
import com.chaosthedude.naturescompass.util.BiomeSearchWorker;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BiomeUtils {
    public static int getIDForBiome(Biome biome) {
        return Registry.field_212624_m.func_148757_b((Object)biome);
    }

    public static Biome getBiomeForID(int id) {
        return (Biome)Registry.field_212624_m.func_148745_a(id);
    }

    public static List<Biome> getAllowedBiomes() {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        for (Biome biome : Registry.field_212624_m) {
            if (biome == null || BiomeUtils.biomeIsBlacklisted(biome)) continue;
            biomes.add(biome);
        }
        return biomes;
    }

    public static void searchForBiome(World world, PlayerEntity player, ItemStack stack, Biome biome, BlockPos startPos) {
        BiomeSearchWorker worker = new BiomeSearchWorker(world, player, stack, biome, startPos);
        worker.start();
    }

    public static int getBiomeSize(World world) {
        return 4;
    }

    public static int getDistanceToBiome(PlayerEntity player, int biomeX, int biomeZ) {
        return BiomeUtils.getDistanceToBiome(player.func_233580_cy_(), biomeX, biomeZ);
    }

    public static int getDistanceToBiome(BlockPos startPos, int biomeX, int biomeZ) {
        return (int)MathHelper.func_76133_a((double)startPos.func_177951_i((Vector3i)new BlockPos(biomeX, startPos.func_177956_o(), biomeZ)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeNameForDisplay(Biome biome) {
        if (biome != null) {
            if (((Boolean)ConfigHandler.CLIENT.fixBiomeNames.get()).booleanValue()) {
                String original = I18n.func_135052_a((String)biome.func_210773_k(), (Object[])new Object[0]);
                String fixed = "";
                char pre = ' ';
                for (int i = 0; i < original.length(); ++i) {
                    char c = original.charAt(i);
                    if (Character.isUpperCase(c) && Character.isLowerCase(pre) && Character.isAlphabetic(pre)) {
                        fixed = fixed + " ";
                    }
                    fixed = fixed + String.valueOf(c);
                    pre = c;
                }
                return fixed;
            }
            return I18n.func_135052_a((String)biome.func_210773_k(), (Object[])new Object[0]);
        }
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeName(Biome biome) {
        return I18n.func_135052_a((String)biome.func_210773_k(), (Object[])new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeName(int biomeID) {
        return BiomeUtils.getBiomeName(BiomeUtils.getBiomeForID(biomeID));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeSource(Biome biome) {
        String registryEntry = biome.getRegistryName().toString();
        String modid = registryEntry.substring(0, registryEntry.indexOf(":"));
        if (modid.equals("minecraft")) {
            return "Minecraft";
        }
        Optional sourceContainer = ModList.get().getModContainerById(modid);
        if (sourceContainer.isPresent()) {
            return ((ModContainer)sourceContainer.get()).getModInfo().getDisplayName();
        }
        return modid;
    }

    public static boolean biomeIsBlacklisted(Biome biome) {
        List biomeBlacklist = (List)ConfigHandler.GENERAL.biomeBlacklist.get();
        ResourceLocation biomeResourceLocation = ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome);
        return biomeBlacklist.contains(String.valueOf(BiomeUtils.getIDForBiome(biome))) || biomeResourceLocation != null && biomeBlacklist.contains(biomeResourceLocation.toString());
    }
}

