/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.mod;

import com.chocohead.mm.api.ClassTinkerers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.modmuss50.optifabric.patcher.ASMUtils;
import me.modmuss50.optifabric.patcher.ChunkRendererFix;
import me.modmuss50.optifabric.patcher.ClassCache;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.MethodNode;

public class OptifineInjector {
    ClassCache classCache;
    String chunkRenderer;
    String particleManager;
    private static List<String> patched = new ArrayList<String>();
    public final Consumer<ClassNode> transformer = target -> {
        if (patched.contains(target.name)) {
            System.out.println("Already patched" + target.name);
            return;
        }
        patched.add(target.name);
        ClassNode source = this.getSourceClassNode((ClassNode)target);
        if (target.name.equals(this.chunkRenderer)) {
            ChunkRendererFix.fix(source);
        }
        if (target.name.equals(this.particleManager)) {
            return;
        }
        target.methods = source.methods;
        target.fields = source.fields;
        target.interfaces = source.interfaces;
        target.superName = source.superName;
        for (MethodNode methodNode2 : target.methods) {
            for (AbstractInsnNode insnNode : methodNode2.instructions.toArray()) {
                if (!(insnNode instanceof FrameNode)) continue;
                FrameNode frameNode = (FrameNode)insnNode;
                if (frameNode.local != null) continue;
                throw new IllegalStateException("Null locals in " + frameNode.type + " frame @ " + source.name + "#" + methodNode2.name + methodNode2.desc);
            }
        }
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            target.access = OptifineInjector.modAccess(target.access);
            target.methods.forEach(methodNode -> {
                methodNode.access = OptifineInjector.modAccess(methodNode.access);
            });
            target.fields.forEach(fieldNode -> {
                fieldNode.access = OptifineInjector.modAccess(fieldNode.access);
            });
        }
    };

    public OptifineInjector(ClassCache classCache) {
        this.classCache = classCache;
    }

    public void setup() throws IOException {
        this.chunkRenderer = FabricLoader.getInstance().getMappingResolver().mapClassName("intermediary", "net.minecraft.class_851").replaceAll("\\.", "/");
        this.particleManager = FabricLoader.getInstance().getMappingResolver().mapClassName("intermediary", "net.minecraft.class_702").replaceAll("\\.", "/");
        this.classCache.getClasses().forEach(s -> ClassTinkerers.addTransformation((String)s.replaceAll("/", ".").substring(0, s.length() - 6), this.transformer));
    }

    private static int modAccess(int access) {
        if ((access & 7) != 2) {
            return access & 0xFFFFFFF8 | 1;
        }
        return access;
    }

    private ClassNode getSourceClassNode(ClassNode classNode) {
        String name = classNode.name.replaceAll("\\.", "/") + ".class";
        byte[] bytes = this.classCache.getAndRemove(name);
        if (bytes == null) {
            throw new RuntimeException("Failed to find patched class for: " + name);
        }
        return ASMUtils.readClassFromBytes(bytes);
    }

    public String toString(InputStream inputStream, Charset charset) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charset));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        return stringBuilder.toString();
    }
}

