/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.patcher;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiConsumer;
import net.fabricmc.tinyremapper.IMappingProvider;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.TinyUtils;

public class RemapUtils {
    public static IMappingProvider getTinyRemapper(File mappings, String from, String to) {
        return TinyUtils.createTinyMappingProvider((Path)mappings.toPath(), (String)from, (String)to);
    }

    public static void mapJar(Path output, Path input, File mappings, List<Path> libraries, String from, String to) throws IOException {
        RemapUtils.mapJar(output, input, RemapUtils.getTinyRemapper(mappings, from, to), libraries);
    }

    public static void mapJar(Path output, Path input, IMappingProvider mappings, List<Path> libraries) throws IOException {
        Files.deleteIfExists(output);
        TinyRemapper remapper = TinyRemapper.newRemapper().withMappings(mappings).renameInvalidLocals(true).rebuildSourceFilenames(true).build();
        try {
            OutputConsumerPath outputConsumer = new OutputConsumerPath(output);
            outputConsumer.addNonClassFiles(input);
            remapper.readInputs(new Path[]{input});
            for (Path path : libraries) {
                remapper.readClassPath(new Path[]{path});
            }
            remapper.apply((BiConsumer)outputConsumer);
            outputConsumer.close();
            remapper.finish();
        }
        catch (Exception e) {
            remapper.finish();
            throw new RuntimeException("Failed to remap jar", e);
        }
    }
}

