/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.mod;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.modmuss50.optifabric.mod.OptifineInstaller;
import me.modmuss50.optifabric.mod.OptifineVersion;
import me.modmuss50.optifabric.patcher.ClassCache;
import me.modmuss50.optifabric.patcher.LambadaRebuiler;
import me.modmuss50.optifabric.patcher.PatchSplitter;
import me.modmuss50.optifabric.patcher.RemapUtils;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.launch.common.FabricLauncher;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.fabricmc.loader.launch.common.MappingConfiguration;
import net.fabricmc.loader.launch.knot.Knot;
import net.fabricmc.loader.util.UrlConversionException;
import net.fabricmc.loader.util.UrlUtil;
import net.fabricmc.loader.util.mappings.TinyRemapperMappingsHelper;
import net.fabricmc.mapping.reader.v2.TinyMetadata;
import net.fabricmc.mapping.tree.ClassDef;
import net.fabricmc.mapping.tree.TinyTree;
import net.fabricmc.tinyremapper.IMappingProvider;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.zeroturnaround.zip.ZipUtil;

public class OptifineSetup {
    private File workingDir = new File(FabricLoader.getInstance().getGameDirectory(), ".optifine");
    private File versionDir;
    private MappingConfiguration mappingConfiguration = new MappingConfiguration();
    private FabricLauncher fabricLauncher = FabricLauncherBase.getLauncher();

    public Pair<File, ClassCache> getRuntime() throws Throwable {
        if (!this.workingDir.exists()) {
            this.workingDir.mkdirs();
        }
        File optifineModJar = OptifineVersion.findOptifineJar();
        byte[] modHash = this.fileHash(optifineModJar);
        this.versionDir = new File(this.workingDir, OptifineVersion.version);
        if (!this.versionDir.exists()) {
            this.versionDir.mkdirs();
        }
        File remappedJar = new File(this.versionDir, "Optifine-mapped.jar");
        File optifinePatches = new File(this.versionDir, "Optifine.classes");
        ClassCache classCache = null;
        if (remappedJar.exists() && optifinePatches.exists() && !Arrays.equals((classCache = ClassCache.read(optifinePatches)).getHash(), modHash)) {
            System.out.println("Class cache is from a different optifine jar, deleting and re-generating");
            classCache = null;
            optifinePatches.delete();
        }
        if (remappedJar.exists() && classCache != null) {
            System.out.println("Found existing patched optifine jar, using that");
            return Pair.of((Object)remappedJar, (Object)classCache);
        }
        if (OptifineVersion.jarType == OptifineVersion.JarType.OPTFINE_INSTALLER) {
            File optifineMod = new File(this.versionDir, "/Optifine-mod.jar");
            if (!optifineMod.exists()) {
                OptifineInstaller.extract(optifineModJar, optifineMod, this.getMinecraftJar().toFile());
            }
            optifineModJar = optifineMod;
        }
        System.out.println("Setting up optifine for the first time, this may take a few seconds.");
        File jarOfTheFree = new File(this.versionDir, "/Optifine-jarofthefree.jar");
        ArrayList srgs = new ArrayList();
        System.out.println("De-Volderfiying jar");
        ZipUtil.iterate((File)optifineModJar, (in, zipEntry) -> {
            String[] split;
            String name = zipEntry.getName();
            if (name.startsWith("com/mojang/blaze3d/platform/") && name.contains("$") && (split = name.replace(".class", "").split("\\$")).length >= 2 && split[1].length() > 2) {
                srgs.add(name);
            }
            if (name.startsWith("srg/") || name.startsWith("net/minecraft/")) {
                srgs.add(name);
            }
        });
        if (jarOfTheFree.exists()) {
            jarOfTheFree.delete();
        }
        ZipUtil.removeEntries((File)optifineModJar, (String[])srgs.toArray(new String[0]), (File)jarOfTheFree);
        System.out.println("Building lambada fix mappings");
        LambadaRebuiler rebuiler = new LambadaRebuiler(jarOfTheFree, this.getMinecraftJar().toFile());
        rebuiler.buildLambadaMap();
        System.out.println("Remapping optifine with fixed lambada names");
        File lambadaFixJar = new File(this.versionDir, "/Optifine-lambadafix.jar");
        RemapUtils.mapJar(lambadaFixJar.toPath(), jarOfTheFree.toPath(), rebuiler, this.getLibs());
        this.remapOptifine(lambadaFixJar.toPath(), remappedJar);
        classCache = PatchSplitter.generateClassCache(remappedJar, optifinePatches, modHash);
        lambadaFixJar.delete();
        jarOfTheFree.delete();
        if (OptifineVersion.jarType == OptifineVersion.JarType.OPTFINE_INSTALLER) {
            optifineModJar.delete();
        }
        File extractedMappings = new File(this.versionDir, "mappings.tiny");
        File fieldMappings = new File(this.versionDir, "mappings.full.tiny");
        extractedMappings.delete();
        fieldMappings.delete();
        boolean extractClasses = Boolean.parseBoolean(System.getProperty("optifabric.extract", "false"));
        if (extractClasses) {
            System.out.println("Extracting optifine classes");
            File optifineClasses = new File(this.versionDir, "optifine-classes");
            if (optifineClasses.exists()) {
                FileUtils.deleteDirectory((File)optifineClasses);
            }
            ZipUtil.unpack((File)remappedJar, (File)optifineClasses);
        }
        return Pair.of((Object)remappedJar, (Object)classCache);
    }

    private void remapOptifine(Path input, File remappedJar) throws Exception {
        String namespace = FabricLoader.getInstance().getMappingResolver().getCurrentRuntimeNamespace();
        System.out.println("Remapping optifine to :" + namespace);
        List<Path> mcLibs = this.getLibs();
        mcLibs.add(this.getMinecraftJar());
        RemapUtils.mapJar(remappedJar.toPath(), input, this.createMappings("official", namespace), mcLibs);
    }

    IMappingProvider createMappings(String from, String to) {
        if (this.fabricLauncher.isDevelopment()) {
            try {
                File fullMappings = this.extractMappings();
                return out -> {
                    RemapUtils.getTinyRemapper(fullMappings, from, to).load(out);
                    out.acceptField(new IMappingProvider.Member("dbq", "CLOUDS", "Ldbe;"), "CLOUDS_OF");
                    out.acceptField(new IMappingProvider.Member("dqr", "renderDistance", "I"), "renderDistance_OF");
                };
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        TinyTree mappingsNew = new TinyTree(){
            private final TinyTree mappings;
            {
                this.mappings = OptifineSetup.this.mappingConfiguration.getMappings();
            }

            public TinyMetadata getMetadata() {
                return this.mappings.getMetadata();
            }

            public Map<String, ClassDef> getDefaultNamespaceClassMap() {
                return this.mappings.getDefaultNamespaceClassMap();
            }

            public Collection<ClassDef> getClasses() {
                return this.mappings.getClasses();
            }
        };
        return TinyRemapperMappingsHelper.create((TinyTree)mappingsNew, (String)from, (String)to);
    }

    List<Path> getLibs() {
        return this.fabricLauncher.getLoadTimeDependencies().stream().map(url -> {
            try {
                return UrlUtil.asPath((URL)url);
            }
            catch (UrlConversionException e) {
                throw new RuntimeException(e);
            }
        }).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toList());
    }

    Path getMinecraftJar() throws FileNotFoundException {
        Optional<Path> entrypointResult = OptifineSetup.findFirstClass(Knot.class.getClassLoader(), Collections.singletonList("net.minecraft.client.main.Main"));
        if (!entrypointResult.isPresent()) {
            throw new RuntimeException("Failed to find minecraft jar");
        }
        if (!Files.exists(entrypointResult.get(), new LinkOption[0])) {
            throw new RuntimeException("Failed to locate minecraft jar");
        }
        if (this.fabricLauncher.isDevelopment()) {
            Path path = entrypointResult.get().getParent();
            Path minecraftJar = path.resolve(String.format("minecraft-%s-client.jar", OptifineVersion.minecraftVersion));
            if (!Files.exists(minecraftJar, new LinkOption[0])) {
                return this.getNewMinecraftDevJar();
            }
            return minecraftJar;
        }
        return entrypointResult.get();
    }

    Path getNewMinecraftDevJar() throws FileNotFoundException {
        Optional<Path> entrypointResult = OptifineSetup.getSource(Knot.class.getClassLoader(), "mappings/mappings.tiny");
        if (entrypointResult.isPresent()) {
            Path path = entrypointResult.get().getParent();
            Path minecraftJar = path.resolve(String.format("minecraft-%s-client.jar", OptifineVersion.minecraftVersion));
            if (Files.exists(minecraftJar, new LinkOption[0])) {
                return minecraftJar;
            }
        }
        throw new FileNotFoundException("Could not find minecraft jar!");
    }

    static Optional<Path> findFirstClass(ClassLoader loader, List<String> classNames) {
        List entrypointFilenames = classNames.stream().map(ep -> ep.replace('.', '/') + ".class").collect(Collectors.toList());
        for (int i = 0; i < entrypointFilenames.size(); ++i) {
            String className = classNames.get(i);
            String classFilename = (String)entrypointFilenames.get(i);
            Optional<Path> classSourcePath = OptifineSetup.getSource(loader, classFilename);
            if (!classSourcePath.isPresent()) continue;
            return Optional.of(classSourcePath.get());
        }
        return Optional.empty();
    }

    static Optional<Path> getSource(ClassLoader loader, String filename) {
        URL url = loader.getResource(filename);
        if (url != null) {
            try {
                URL urlSource = UrlUtil.getSource((String)filename, (URL)url);
                Path classSourceFile = UrlUtil.asPath((URL)urlSource);
                return Optional.of(classSourceFile);
            }
            catch (UrlConversionException e) {
                e.printStackTrace();
            }
        }
        return Optional.empty();
    }

    File extractMappings() throws IOException {
        File extractedMappings = new File(this.versionDir, "mappings.tiny");
        if (extractedMappings.exists()) {
            extractedMappings.delete();
        }
        InputStream mappingStream = FabricLauncherBase.class.getClassLoader().getResourceAsStream("mappings/mappings.tiny");
        FileUtils.copyInputStreamToFile((InputStream)mappingStream, (File)extractedMappings);
        if (!extractedMappings.exists()) {
            throw new RuntimeException("failed to extract mappings!");
        }
        return extractedMappings;
    }

    byte[] fileHash(File input) throws IOException {
        try (FileInputStream is = new FileInputStream(input);){
            byte[] byArray = DigestUtils.md5((InputStream)is);
            return byArray;
        }
    }
}

