/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.patcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import me.modmuss50.optifabric.patcher.ASMUtils;
import net.fabricmc.tinyremapper.IMappingProvider;
import net.fabricmc.tinyremapper.MemberInstance;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class LambadaRebuiler
implements IMappingProvider {
    private File optifineFile;
    private File minecraftClientFile;
    private JarFile optifineJar;
    private JarFile clientJar;
    private Map<String, String> methodMap = new HashMap<String, String>();
    private List<String> usedMethods = new ArrayList<String>();

    public LambadaRebuiler(File optifineFile, File minecraftClientFile) throws IOException {
        this.optifineFile = optifineFile;
        this.minecraftClientFile = minecraftClientFile;
        this.optifineJar = new JarFile(optifineFile);
        this.clientJar = new JarFile(minecraftClientFile);
    }

    public void buildLambadaMap() throws IOException {
        Enumeration<JarEntry> entrys = this.optifineJar.entries();
        while (entrys.hasMoreElements()) {
            JarEntry entry = entrys.nextElement();
            if (!entry.getName().endsWith(".class") || entry.getName().startsWith("net/") || entry.getName().startsWith("optifine/") || entry.getName().startsWith("javax/")) continue;
            this.buildClassMap(entry);
        }
        this.optifineJar.close();
        this.clientJar.close();
    }

    private void buildClassMap(JarEntry jarEntry) throws IOException {
        ClassNode classNode = ASMUtils.asClassNode(jarEntry, this.optifineJar);
        ArrayList<MethodNode> lambadaNodes = new ArrayList<MethodNode>();
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.startsWith("lambda$") || methodNode.name.startsWith("lambda$static")) continue;
            lambadaNodes.add(methodNode);
        }
        if (lambadaNodes.isEmpty()) {
            return;
        }
        ClassNode minecraftClass = ASMUtils.asClassNode(this.clientJar.getJarEntry(jarEntry.getName()), this.clientJar);
        if (!minecraftClass.name.equals(classNode.name)) {
            throw new RuntimeException("Something went wrong");
        }
        for (MethodNode methodNode : lambadaNodes) {
            MethodNode actualNode = this.findMethod(methodNode, classNode, minecraftClass);
            if (actualNode == null) continue;
            String key = classNode.name + "." + MemberInstance.getMethodId((String)actualNode.name, (String)actualNode.desc);
            if (this.usedMethods.contains(key)) {
                System.out.println("Skipping duplicate: " + key);
                continue;
            }
            this.usedMethods.add(classNode.name + "." + MemberInstance.getMethodId((String)actualNode.name, (String)actualNode.desc));
            this.methodMap.put(classNode.name + "/" + MemberInstance.getMethodId((String)methodNode.name, (String)methodNode.desc), actualNode.name);
        }
    }

    private MethodNode findMethod(MethodNode optifineMethod, ClassNode optifineClass, ClassNode minecraftClass) {
        MethodNode lastNode = null;
        int identiacalMethods = 0;
        for (MethodNode methodNode : minecraftClass.methods) {
            if (!ASMUtils.isSynthetic(methodNode.access) || !methodNode.desc.equals(optifineMethod.desc)) continue;
            ++identiacalMethods;
            lastNode = methodNode;
        }
        if (identiacalMethods == 1) {
            return lastNode;
        }
        return null;
    }

    public void load(IMappingProvider.MappingAcceptor out) {
        this.methodMap.putAll(this.methodMap);
    }
}

