/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.patcher.fixes;

import me.modmuss50.optifabric.patcher.fixes.ClassFixer;
import me.modmuss50.optifabric.util.RemappingUtils;
import org.apache.commons.lang3.Validate;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class HeldItemRendererFix
implements ClassFixer {
    private String renderFirstPersonItemName = RemappingUtils.getMethodName("class_759", "method_3228", "(Lnet/minecraft/class_742;FFLnet/minecraft/class_1268;FLnet/minecraft/class_1799;FLnet/minecraft/class_4587;Lnet/minecraft/class_4597;I)V");
    private String handName = RemappingUtils.fromIntermediary("class_1268");

    @Override
    public void fix(ClassNode optifine, ClassNode minecraft) {
        Validate.notNull((Object)this.renderFirstPersonItemName, (String)"Failed to find name for renderFirstPersonItem", (Object[])new Object[0]);
        Validate.notNull((Object)this.handName, (String)"Failed to find name for handName", (Object[])new Object[0]);
        MethodNode oldNode = minecraft.methods.stream().filter(methodNode -> methodNode.name.equals(this.renderFirstPersonItemName)).findFirst().orElse(null);
        Validate.notNull((Object)oldNode, (String)("Failed to find old " + this.renderFirstPersonItemName + " method"), (Object[])new Object[0]);
        InsnList insnList = new InsnList();
        insnList.add(this.getInstList("net/optifine/Config", "isShaders", "()Z"));
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 4));
        insnList.add(this.getInstList("net/optifine/shaders/Shaders", "isSkipRenderHand", String.format("(L%s;)Z", this.handName)));
        optifine.methods.removeIf(methodNode -> methodNode.name.equals(this.renderFirstPersonItemName));
        optifine.methods.add(oldNode);
    }

    private InsnList getInstList(String owner, String name, String descriptor) {
        InsnList insnList = new InsnList();
        insnList.add((AbstractInsnNode)new MethodInsnNode(184, owner, name, descriptor, false));
        LabelNode jumpNode = new LabelNode();
        insnList.add((AbstractInsnNode)new JumpInsnNode(153, jumpNode));
        insnList.add((AbstractInsnNode)new InsnNode(177));
        insnList.add((AbstractInsnNode)jumpNode);
        return insnList;
    }
}

