/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.patcher.fixes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import me.modmuss50.optifabric.patcher.fixes.ClassFixer;
import me.modmuss50.optifabric.util.RemappingUtils;
import org.apache.commons.lang3.Validate;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class KeyboardFix
implements ClassFixer {
    private String onKeyName = RemappingUtils.getMethodName("class_309", "method_1466", "(JIIII)V");

    @Override
    public void fix(ClassNode optifine, ClassNode minecraft) {
        Validate.notNull((Object)this.onKeyName, (String)"onKeyName null", (Object[])new Object[0]);
        optifine.methods.removeIf(methodNode -> methodNode.name.equals(this.onKeyName));
        MethodNode methodNode2 = minecraft.methods.stream().filter(methodNode1 -> methodNode1.name.equals(this.onKeyName)).findFirst().orElse(null);
        Validate.notNull((Object)methodNode2, (String)"old method null", (Object[])new Object[0]);
        optifine.methods.add(methodNode2);
        Function<MethodNode, Set> findAnonymousMethods = methodNode12 -> {
            HashSet<String> anonymousMethods1 = new HashSet<String>();
            for (AbstractInsnNode instruction : methodNode12.instructions) {
                if (!(instruction instanceof InvokeDynamicInsnNode)) continue;
                InvokeDynamicInsnNode dynamicInsnNode = (InvokeDynamicInsnNode)instruction;
                for (Object bsmArg : dynamicInsnNode.bsmArgs) {
                    Handle handle;
                    if (!(bsmArg instanceof Handle) || (handle = (Handle)bsmArg).getTag() != 7) continue;
                    anonymousMethods1.add(handle.getName());
                }
            }
            return anonymousMethods1;
        };
        HashSet anonymousMethods = new HashSet(findAnonymousMethods.apply(methodNode2));
        long added = 1L;
        while (added > 0L) {
            ArrayList temp = new ArrayList();
            for (String anonymousMethodName : anonymousMethods) {
                for (MethodNode anonymousMethod : minecraft.methods) {
                    if (!anonymousMethod.name.equals(anonymousMethodName)) continue;
                    Set names = findAnonymousMethods.apply(anonymousMethod);
                    added = names.stream().filter(s -> !anonymousMethods.contains(s)).count();
                    temp.addAll(names);
                }
            }
            anonymousMethods.addAll(temp);
        }
        for (MethodNode method : minecraft.methods) {
            if ((method.access & 0x1000) == 0) continue;
            boolean found = false;
            for (MethodNode node : optifine.methods) {
                if (!node.name.equals(method.name)) continue;
                found = true;
                break;
            }
            if (found || !anonymousMethods.contains(method.name)) continue;
            optifine.methods.add(method);
        }
    }
}

