/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.patcher.fixes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import me.modmuss50.optifabric.patcher.fixes.BlockModelRendererFix;
import me.modmuss50.optifabric.patcher.fixes.ChunkRendererFix;
import me.modmuss50.optifabric.patcher.fixes.ClassFixer;
import me.modmuss50.optifabric.patcher.fixes.HeldItemRendererFix;
import me.modmuss50.optifabric.patcher.fixes.KeyboardFix;
import me.modmuss50.optifabric.patcher.fixes.MobEntityFix;
import me.modmuss50.optifabric.patcher.fixes.SpriteAtlasTextureFix;
import me.modmuss50.optifabric.patcher.fixes.ThreadedAnvilChunkStorageFix;
import me.modmuss50.optifabric.util.RemappingUtils;

public class OptifineFixer {
    public static final OptifineFixer INSTANCE = new OptifineFixer();
    private HashMap<String, List<ClassFixer>> classFixes = new HashMap();
    private List<String> skippedClass = new ArrayList<String>();

    private OptifineFixer() {
        this.registerFix("class_851", new ChunkRendererFix());
        this.registerFix("class_778", new BlockModelRendererFix());
        this.registerFix("class_309", new KeyboardFix());
        this.registerFix("class_759", new HeldItemRendererFix());
        this.registerFix("class_1059", new SpriteAtlasTextureFix());
        this.registerFix("class_3898", new ThreadedAnvilChunkStorageFix());
        this.registerFix("class_1308", new MobEntityFix());
        this.skipClass("class_702");
        this.skipClass("class_759$1");
    }

    private void registerFix(String className, ClassFixer classFixer) {
        this.classFixes.computeIfAbsent(RemappingUtils.fromIntermediary(className), s -> new ArrayList()).add(classFixer);
    }

    private void skipClass(String className) {
        this.skippedClass.add(RemappingUtils.fromIntermediary(className));
    }

    public boolean shouldSkip(String className) {
        return this.skippedClass.contains(className);
    }

    public List<ClassFixer> getFixers(String className) {
        return this.classFixes.getOrDefault(className, Collections.emptyList());
    }
}

