/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.pickupnotifier.asm;

import com.fuzs.pickupnotifier.asm.core.ClassTransformerUtil;
import com.fuzs.pickupnotifier.asm.core.MethodSignature;
import com.fuzs.pickupnotifier.asm.hook.AddEntriesHook;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassTransformer
implements IClassTransformer,
Opcodes {
    private static final Map<String, Function<byte[], byte[]>> TRANSFORMABLES = new HashMap<String, Function<byte[], byte[]>>(){
        {
            this.put("net.minecraft.client.particle.ParticleItemPickup", x$0 -> ClassTransformer.transformParticleItemPickup(x$0));
        }
    };

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (TRANSFORMABLES.containsKey(transformedName)) {
            return TRANSFORMABLES.get(transformedName).apply(basicClass);
        }
        return basicClass;
    }

    private static byte[] transformParticleItemPickup(byte[] basicClass) {
        MethodSignature signature = new MethodSignature("net/minecraft/client/particle/ParticleItemPickup", "<init>", "<init>", "(Lnet/minecraft/world/World;Lnet/minecraft/entity/Entity;Lnet/minecraft/entity/Entity;F)V");
        MethodSignature hook = new MethodSignature(Type.getInternalName(AddEntriesHook.class), "onEntityPickup", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/entity/Entity;)V");
        Predicate<AbstractInsnNode> filter = node -> node instanceof InsnNode && node.getOpcode() == 177;
        BiConsumer<MethodNode, AbstractInsnNode> insert = (method, node) -> {
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 2));
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 3));
            insnList.add((AbstractInsnNode)hook.genInsnNode());
            method.instructions.insertBefore(node, insnList);
        };
        return ClassTransformerUtil.transformBasicClass(basicClass, signature, filter, insert);
    }
}

