/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.pickupnotifier.asm.core;

import com.fuzs.pickupnotifier.asm.core.MethodSignature;
import com.fuzs.pickupnotifier.asm.core.SafeClassWriter;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassTransformerUtil {
    public static byte[] transformBasicClass(byte[] basicClass, MethodSignature signature, Predicate<AbstractInsnNode> filter, BiConsumer<MethodNode, AbstractInsnNode> insert) {
        ClassReader classReader;
        String name = signature.getClassName();
        ClassTransformerUtil.log("Patching " + name + "...");
        try {
            classReader = new ClassReader(basicClass);
        }
        catch (NullPointerException ignored) {
            return basicClass;
        }
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        Optional<MethodNode> method = ClassTransformerUtil.findMethod(classNode, signature);
        if (method.isPresent()) {
            Optional<AbstractInsnNode> node = ClassTransformerUtil.findNode(method.get(), filter);
            if (node.isPresent()) {
                insert.accept(method.get(), node.get());
                ClassTransformerUtil.log("Patching " + name + " was successful");
                SafeClassWriter classWriter = new SafeClassWriter(3);
                classNode.accept((ClassVisitor)classWriter);
                return classWriter.toByteArray();
            }
            ClassTransformerUtil.log("Patching " + name + " failed: Node not found");
        } else {
            ClassTransformerUtil.log("Patching " + name + " failed: Method not found");
        }
        return basicClass;
    }

    private static Optional<MethodNode> findMethod(ClassNode classNode, MethodSignature signature) {
        for (MethodNode method : classNode.methods) {
            if (!signature.matches(method)) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }

    private static Optional<AbstractInsnNode> findNode(MethodNode method, Predicate<AbstractInsnNode> filter) {
        for (AbstractInsnNode node : method.instructions.toArray()) {
            if (!filter.test(node)) continue;
            return Optional.of(node);
        }
        return Optional.empty();
    }

    public static AbstractInsnNode getNthNode(AbstractInsnNode node, int n) {
        for (int i = 0; i < Math.abs(n); ++i) {
            node = n < 0 ? node.getPrevious() : node.getNext();
        }
        return node;
    }

    private static void log(String s) {
        LogManager.getLogger((String)"Pick Up Notifier Transformer").info(s);
    }
}

