/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.pickupnotifier.client.handler;

import com.fuzs.pickupnotifier.asm.hook.AddEntriesHook;
import com.fuzs.pickupnotifier.client.util.DisplayEntry;
import com.fuzs.pickupnotifier.client.util.PositionPreset;
import com.fuzs.pickupnotifier.config.ConfigBuildHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class DrawEntriesHandler {
    private final Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END || this.mc.func_147113_T()) {
            return;
        }
        if (!AddEntriesHook.PICK_UPS.isEmpty() && !this.mc.func_147113_T() && ConfigBuildHandler.generalConfig.displayTime != 0) {
            AddEntriesHook.PICK_UPS.forEach(it -> it.tick(evt.renderTickTime));
            AddEntriesHook.PICK_UPS.removeIf(DisplayEntry::isDead);
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderGameOverlayText(RenderGameOverlayEvent.Text evt) {
        if (AddEntriesHook.PICK_UPS.isEmpty()) {
            return;
        }
        float scale = (float)ConfigBuildHandler.displayConfig.scale / 6.0f;
        int scaledWidth = (int)((float)evt.getResolution().func_78326_a() / scale);
        int scaledHeight = (int)((float)evt.getResolution().func_78328_b() / scale);
        PositionPreset position = ConfigBuildHandler.displayConfig.position;
        boolean bottom = position.isBottom();
        int posX = (int)((float)ConfigBuildHandler.displayConfig.xOffset / scale);
        int posY = (int)((float)ConfigBuildHandler.displayConfig.yOffset / scale);
        int offset = position.getY(18, scaledHeight, posY);
        boolean move = ConfigBuildHandler.generalConfig.move;
        int totalFade = move ? (int)(AddEntriesHook.PICK_UPS.stream().mapToDouble(DisplayEntry::getRelativeLife).average().orElse(0.0) * (double)AddEntriesHook.PICK_UPS.size() * 18.0) : 0;
        int renderY = offset + (bottom ? totalFade : -totalFade);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        for (DisplayEntry entry : AddEntriesHook.PICK_UPS) {
            int renderX = position.getX(entry.getTotalWidth(this.mc), scaledWidth, posX);
            if (bottom) {
                if (renderY < offset + 18) {
                    entry.render(this.mc, renderX, renderY, move ? MathHelper.func_76131_a((float)((float)(renderY - offset) / 18.0f), (float)0.0f, (float)1.0f) : entry.getRelativeLife());
                }
            } else if (renderY > offset - 18) {
                entry.render(this.mc, renderX, renderY, move ? MathHelper.func_76131_a((float)((float)(renderY - offset) / -18.0f), (float)0.0f, (float)1.0f) : entry.getRelativeLife());
            }
            renderY += bottom ? -18 : 18;
        }
        GlStateManager.func_179152_a((float)(1.0f / scale), (float)(1.0f / scale), (float)1.0f);
    }
}

