/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.pickupnotifier.client.util;

import com.fuzs.pickupnotifier.client.util.DisplayEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class ExperienceDisplayEntry
extends DisplayEntry {
    private final ITextComponent name;
    private static final ResourceLocation EXPERIENCE_ORB_TEXTURES = new ResourceLocation("textures/entity/experience_orb.png");

    public ExperienceDisplayEntry(EntityXPOrb orb) {
        this((ITextComponent)new TextComponentString(orb.func_70005_c_()), orb.field_70530_e);
    }

    private ExperienceDisplayEntry(ITextComponent name, int count) {
        super(count, EnumRarity.COMMON);
        this.name = name;
    }

    @Override
    protected ITextComponent getName() {
        return this.name;
    }

    @Override
    public boolean canMerge(DisplayEntry entry) {
        return entry instanceof ExperienceDisplayEntry;
    }

    @Override
    protected void renderSprite(Minecraft mc, int posX, int posY) {
        int i = this.getTextureForCount();
        int x = i % 4 * 16;
        int y = i / 4 * 16;
        float color = this.getLife() / 4.0f;
        float r = (MathHelper.func_76126_a((float)color) + 1.0f) * 0.5f;
        float g = 1.0f;
        float b = (MathHelper.func_76126_a((float)(color + 4.1887903f)) + 1.0f) * 0.1f;
        mc.func_110434_K().func_110577_a(EXPERIENCE_ORB_TEXTURES);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
        Gui.func_146110_a((int)posX, (int)posY, (float)x, (float)y, (int)16, (int)16, (float)64.0f, (float)64.0f);
        GlStateManager.func_179084_k();
    }

    private int getTextureForCount() {
        if (this.count >= 2477) {
            return 10;
        }
        if (this.count >= 1237) {
            return 9;
        }
        if (this.count >= 617) {
            return 8;
        }
        if (this.count >= 307) {
            return 7;
        }
        if (this.count >= 149) {
            return 6;
        }
        if (this.count >= 73) {
            return 5;
        }
        if (this.count >= 37) {
            return 4;
        }
        if (this.count >= 17) {
            return 3;
        }
        if (this.count >= 7) {
            return 2;
        }
        return this.count >= 3 ? 1 : 0;
    }

    @Override
    public ExperienceDisplayEntry copy() {
        return new ExperienceDisplayEntry(this.name, this.count);
    }
}

