/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.pickupnotifier.client.gui.entry;

import com.fuzs.pickupnotifier.config.ConfigValueHolder;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.mutable.MutableFloat;

public abstract class DisplayEntry {
    public static final int HEIGHT = 18;
    private static final int MARGIN = 4;
    private final Rarity rarity;
    protected int count;
    private final MutableFloat life;

    protected DisplayEntry(int count, Rarity rarity) {
        this.count = Math.min(count, ConfigValueHolder.getGeneralConfig().maxCount);
        this.rarity = rarity;
        this.life = new MutableFloat((float)ConfigValueHolder.getGeneralConfig().displayTime);
    }

    public boolean isDead() {
        return this.life.compareTo(new MutableFloat(0.0f)) < 1;
    }

    public final void tick(float lostLife) {
        this.life.subtract(lostLife);
    }

    public final int getCount() {
        return this.count;
    }

    public abstract boolean canMerge(DisplayEntry var1);

    public final void addCount(int count) {
        this.count = Math.min(this.count + count, ConfigValueHolder.getGeneralConfig().maxCount);
    }

    protected abstract ITextComponent getName();

    private ITextComponent getNameComponent() {
        ITextComponent name = this.getName().func_150259_f();
        if (this.count <= 0) {
            return name;
        }
        if (ConfigValueHolder.getDisplayConfig().position.isMirrored()) {
            return new StringTextComponent(this.count + "x ").func_150257_a(name);
        }
        return name.func_150258_a(" x" + this.count);
    }

    public final float getRelativeLife() {
        return 1.0f - Math.min(1.0f, this.getLife() / (float)Math.min(ConfigValueHolder.getGeneralConfig().moveTime, ConfigValueHolder.getGeneralConfig().displayTime));
    }

    protected final float getLife() {
        return Math.max(0.0f, this.life.floatValue());
    }

    public final void resetLife() {
        this.life.setValue((float)ConfigValueHolder.getGeneralConfig().displayTime);
    }

    public void merge(DisplayEntry entry) {
        this.addCount(entry.getCount());
        this.resetLife();
    }

    private Style getStyle() {
        if (!ConfigValueHolder.getGeneralConfig().ignoreRarity && this.rarity != Rarity.COMMON) {
            return new Style().func_150238_a(this.rarity.field_77937_e);
        }
        return new Style().func_150238_a(ConfigValueHolder.getGeneralConfig().textColor);
    }

    private String getNameString() {
        return this.getNameComponent().func_150255_a(this.getStyle()).func_150254_d();
    }

    private int getTextWidth(FontRenderer fontRenderer) {
        String name = this.getNameComponent().getString();
        return fontRenderer.func_78256_a(Objects.requireNonNull(TextFormatting.func_110646_a((String)name)));
    }

    public int getTotalWidth(FontRenderer fontRenderer) {
        int length = this.getTextWidth(fontRenderer);
        return ConfigValueHolder.getGeneralConfig().showSprite ? length + 4 + 16 : length;
    }

    public final void render(Minecraft mc, int posX, int posY, float alpha) {
        int fadeTime;
        boolean mirrored = ConfigValueHolder.getDisplayConfig().position.isMirrored();
        boolean sprite = ConfigValueHolder.getGeneralConfig().showSprite;
        int i = mirrored || !sprite ? posX : posX + 16 + 4;
        int textWidth = this.getTextWidth(mc.field_71466_p);
        int opacity = mc.field_71474_y.func_216839_a(0);
        if (opacity != 0) {
            mc.field_71466_p.getClass();
            AbstractGui.fill((int)(i - 2), (int)(posY + 3 - 2), (int)(i + textWidth + 2), (int)(posY + 3 + 9 + 2), (int)opacity);
        }
        int n = fadeTime = ConfigValueHolder.getGeneralConfig().fadeAway ? 255 - (int)(255.0f * alpha) : 255;
        if (fadeTime >= 5) {
            RenderSystem.pushMatrix();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            mc.field_71466_p.func_175063_a(this.getNameString(), (float)i, (float)(posY + 3), 0xFFFFFF + (fadeTime << 24));
            RenderSystem.disableBlend();
            if (sprite) {
                this.renderSprite(mc, mirrored ? posX + textWidth + 4 : posX, posY);
            }
            RenderSystem.popMatrix();
        }
    }

    protected abstract void renderSprite(Minecraft var1, int var2, int var3);
}

