/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.pickupnotifier.client.handler;

import com.fuzs.pickupnotifier.client.gui.PositionPreset;
import com.fuzs.pickupnotifier.client.gui.entry.DisplayEntry;
import com.fuzs.pickupnotifier.client.util.PickUpCollector;
import com.fuzs.pickupnotifier.config.ConfigValueHolder;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DrawEntriesHandler {
    public static final PickUpCollector PICK_UPS = new PickUpCollector();
    private final Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END || this.mc.func_147113_T()) {
            return;
        }
        if (!this.mc.func_147113_T() && ConfigValueHolder.getGeneralConfig().displayTime != 0) {
            PICK_UPS.tick(evt.renderTickTime);
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlayText(RenderGameOverlayEvent.Text evt) {
        if (PICK_UPS.isEmpty()) {
            return;
        }
        float scale = (float)ConfigValueHolder.getDisplayConfig().scale / 6.0f;
        int scaledWidth = (int)((float)evt.getWindow().func_198107_o() / scale);
        int scaledHeight = (int)((float)evt.getWindow().func_198087_p() / scale);
        PositionPreset position = ConfigValueHolder.getDisplayConfig().position;
        boolean bottom = position.isBottom();
        int posX = (int)((float)ConfigValueHolder.getDisplayConfig().xOffset / scale);
        int posY = (int)((float)ConfigValueHolder.getDisplayConfig().yOffset / scale);
        int offset = position.getY(18, scaledHeight, posY);
        boolean move = ConfigValueHolder.getGeneralConfig().move;
        int totalFade = move ? (int)(PICK_UPS.getTotalFade() * 18.0) : 0;
        int renderY = offset + (bottom ? totalFade : -totalFade);
        RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
        for (DisplayEntry entry : PICK_UPS) {
            int renderX = position.getX(entry.getTotalWidth(this.mc.field_71466_p), scaledWidth, posX);
            if (bottom) {
                if (renderY < offset + 18) {
                    entry.render(this.mc, renderX, renderY, move ? MathHelper.func_76131_a((float)((float)(renderY - offset) / 18.0f), (float)0.0f, (float)1.0f) : entry.getRelativeLife());
                }
            } else if (renderY > offset - 18) {
                entry.render(this.mc, renderX, renderY, move ? MathHelper.func_76131_a((float)((float)(renderY - offset) / -18.0f), (float)0.0f, (float)1.0f) : entry.getRelativeLife());
            }
            renderY += bottom ? -18 : 18;
        }
        RenderSystem.scalef((float)(1.0f / scale), (float)(1.0f / scale), (float)1.0f);
    }
}

