/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Base;

import com.wuest.prefab.Base.TileEntityBase;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class TileBlockBase<T extends TileEntityBase>
extends Block
implements ITileEntityProvider {
    public TileBlockBase(Material materialIn) {
        super(materialIn);
    }

    public TileBlockBase(Material materialIn, MapColor color) {
        super(materialIn, color);
    }

    public Class<T> getTypeParameterClass() {
        Type type = ((Object)((Object)this)).getClass().getGenericSuperclass();
        ParameterizedType paramType = (ParameterizedType)type;
        return (Class)paramType.getActualTypeArguments()[0];
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.func_149744_f(state) && side != null;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return this.createNewTileEntity();
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            List items = this.getDrops((IBlockAccess)worldIn, pos, state, fortune);
            chance = ForgeEventFactory.fireBlockHarvesting((List)items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            T tileEntity = this.getLocalTileEntity(worldIn, pos);
            for (ItemStack item : items) {
                if (!(worldIn.field_73012_v.nextFloat() <= chance)) continue;
                if (tileEntity != null) {
                    item = ((TileEntityBase)((Object)tileEntity)).transferCapabilities(item);
                }
                TileBlockBase.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            }
        }
    }

    public T createNewTileEntity() {
        try {
            return (T)((Object)((TileEntityBase)((Object)this.getTypeParameterClass().newInstance())));
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        T tileEntity = this.getLocalTileEntity(worldIn, pos);
        this.customBreakBlock(tileEntity, worldIn, pos, state);
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, true);
        }
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        if (worldIn.func_175625_s(pos) == null) {
            T tile = this.createNewTileEntity();
            worldIn.func_175690_a(pos, tile);
        }
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int eventID, int eventParam) {
        super.func_189539_a(state, worldIn, pos, eventID, eventParam);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(eventID, eventParam);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.updateState(worldIn, pos, state);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P();
    }

    public void updateState(World worldIn, BlockPos pos, IBlockState state) {
        T tileEntity = this.getLocalTileEntity(worldIn, pos);
        int tickDelay = this.customUpdateState(worldIn, pos, state, tileEntity);
        if (tickDelay > 0) {
            worldIn.func_175704_b(pos, pos);
            worldIn.func_175684_a(pos, (Block)this, tickDelay);
        }
    }

    public T getLocalTileEntity(World worldIn, BlockPos pos) {
        TileEntity entity = worldIn.func_175625_s(pos);
        if (entity != null && entity.getClass() == this.getTypeParameterClass()) {
            return (T)((Object)((TileEntityBase)entity));
        }
        T tileEntity = this.createNewTileEntity();
        worldIn.func_175690_a(pos, tileEntity);
        tileEntity.func_174878_a(pos);
        return tileEntity;
    }

    public abstract int customUpdateState(World var1, BlockPos var2, IBlockState var3, T var4);

    public abstract void customBreakBlock(T var1, World var2, BlockPos var3, IBlockState var4);
}

