/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Blocks;

import com.wuest.prefab.Blocks.BlockPaperLantern;
import com.wuest.prefab.Events.ModEventHandler;
import com.wuest.prefab.ModRegistry;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPhasing
extends Block {
    public static BlockPaperLantern.SeeThroughMaterial BlockMaterial = new BlockPaperLantern.SeeThroughMaterial(MapColor.field_151660_b).setTranslucent(true).setImmovable(true);
    public static final PropertyEnum<EnumPhasingProgress> Phasing_Progress = PropertyEnum.func_177709_a((String)"phasing_progress", EnumPhasingProgress.class);
    public static final PropertyBool Phasing_Out = PropertyBool.func_177716_a((String)"phasing_out");
    public static final AxisAlignedBB Empty_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    protected int tickRate = 2;

    public BlockPhasing(String name) {
        super((Material)BlockMaterial);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(0.6f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)Phasing_Out, (Comparable)Boolean.valueOf(false)).func_177226_a(Phasing_Progress, (Comparable)((Object)EnumPhasingProgress.base)));
        ModRegistry.setBlockName(this, name);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        EnumPhasingProgress progress;
        if (!world.field_72995_K && (progress = (EnumPhasingProgress)((Object)state.func_177229_b(Phasing_Progress))) == EnumPhasingProgress.base) {
            world.func_175684_a(pos, (Block)this, this.tickRate);
        }
        return true;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        boolean poweredSide = world.func_175640_z(pos);
        if (poweredSide) {
            this.updateNeighborPhasicBlocks(true, world, pos, this.func_176223_P(), false, false);
        }
        return this.func_176223_P().func_177226_a((IProperty)Phasing_Out, (Comparable)Boolean.valueOf(poweredSide)).func_177226_a(Phasing_Progress, (Comparable)((Object)EnumPhasingProgress.base));
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        if (ModEventHandler.RedstoneAffectedBlockPositions.contains(pos)) {
            ModEventHandler.RedstoneAffectedBlockPositions.remove(pos);
        }
        boolean poweredSide = worldIn.func_175640_z(pos);
        EnumPhasingProgress currentState = (EnumPhasingProgress)((Object)state.func_177229_b(Phasing_Progress));
        if (poweredSide && currentState == EnumPhasingProgress.transparent) {
            this.updateNeighborPhasicBlocks(false, worldIn, pos, state, false, false);
        }
    }

    public int func_149738_a(World worldIn) {
        return this.tickRate;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos p_189540_5_) {
        if (!worldIn.field_72995_K && blockIn.func_176223_P().func_185897_m()) {
            boolean poweredSide = worldIn.func_175640_z(pos);
            EnumPhasingProgress currentState = (EnumPhasingProgress)((Object)state.func_177229_b(Phasing_Progress));
            boolean setToTransparent = false;
            if (poweredSide && currentState == EnumPhasingProgress.base) {
                setToTransparent = true;
            }
            if (currentState == EnumPhasingProgress.base || currentState == EnumPhasingProgress.transparent) {
                this.updateNeighborPhasicBlocks(setToTransparent, worldIn, pos, state, true, true);
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int updatedMeta;
        int tickDelay = this.tickRate;
        if (ModEventHandler.RedstoneAffectedBlockPositions.contains(pos)) {
            return;
        }
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.func_177229_b(Phasing_Progress));
        boolean phasingOut = (Boolean)state.func_177229_b((IProperty)Phasing_Out);
        if (progress == EnumPhasingProgress.base) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                Block currentBlock = worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
                if (!(currentBlock instanceof BlockPhasing) || ModEventHandler.RedstoneAffectedBlockPositions.contains(pos.func_177972_a(facing))) continue;
                worldIn.func_175684_a(pos.func_177972_a(facing), currentBlock, tickDelay);
            }
            phasingOut = true;
        }
        if ((updatedMeta = progress.getMeta()) == EnumPhasingProgress.eighty_percent.getMeta() && phasingOut) {
            tickDelay = 100;
        }
        if (updatedMeta == EnumPhasingProgress.transparent.getMeta() && phasingOut) {
            phasingOut = false;
        }
        if (updatedMeta == EnumPhasingProgress.twenty_percent.getMeta() && !phasingOut) {
            tickDelay = -1;
        }
        updatedMeta = phasingOut ? updatedMeta + 2 : updatedMeta - 2;
        progress = EnumPhasingProgress.ValueOf(updatedMeta);
        state = state.func_177226_a((IProperty)Phasing_Out, (Comparable)Boolean.valueOf(phasingOut)).func_177226_a(Phasing_Progress, (Comparable)((Object)progress));
        worldIn.func_175656_a(pos, state);
        worldIn.func_175704_b(pos, pos);
        if (tickDelay > 0) {
            worldIn.func_175684_a(pos, (Block)this, tickDelay);
        }
    }

    public int func_180651_a(IBlockState state) {
        return EnumPhasingProgress.base.getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        if (meta % 2 == 0) {
            return this.func_176223_P().func_177226_a((IProperty)Phasing_Out, (Comparable)Boolean.valueOf(false)).func_177226_a(Phasing_Progress, (Comparable)((Object)EnumPhasingProgress.ValueOf(meta)));
        }
        return this.func_176223_P().func_177226_a((IProperty)Phasing_Out, (Comparable)Boolean.valueOf(true)).func_177226_a(Phasing_Progress, (Comparable)((Object)EnumPhasingProgress.ValueOf(meta - 1)));
    }

    public int func_176201_c(IBlockState state) {
        int phasing = (Boolean)state.func_177229_b((IProperty)Phasing_Out) != false ? 1 : 0;
        return ((EnumPhasingProgress)((Object)state.func_177229_b(Phasing_Progress))).getMeta() + phasing;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Phasing_Out, Phasing_Progress});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.func_177229_b(Phasing_Progress));
        return layer == BlockRenderLayer.TRANSLUCENT && progress != EnumPhasingProgress.base || layer == BlockRenderLayer.SOLID && progress == EnumPhasingProgress.base;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)blockState.func_177229_b(Phasing_Progress));
        if (progress == EnumPhasingProgress.transparent) {
            return Empty_AABB;
        }
        return super.func_180646_a(blockState, worldIn, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.func_177229_b(Phasing_Progress));
        if (progress == EnumPhasingProgress.transparent) {
            return Empty_AABB;
        }
        AxisAlignedBB aabb = super.func_185496_a(state, source, pos);
        return aabb;
    }

    @Nullable
    protected RayTraceResult func_185503_a(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB boundingBox) {
        if (boundingBox == Empty_AABB) {
            return null;
        }
        return super.func_185503_a(pos, start, end, boundingBox);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        AxisAlignedBB axisalignedbb = blockState.func_185900_c(blockAccess, pos);
        if (axisalignedbb == Empty_AABB) {
            return false;
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    protected void updateNeighborPhasicBlocks(boolean setToTransparent, World worldIn, BlockPos pos, IBlockState phasicBlockState, boolean setCurrentBlock, boolean triggeredByRedstone) {
        ArrayList<BlockPos> blocksToUpdate = new ArrayList<BlockPos>();
        IBlockState updatedBlockState = phasicBlockState.func_177226_a((IProperty)Phasing_Out, (Comparable)Boolean.valueOf(setToTransparent)).func_177226_a(Phasing_Progress, (Comparable)((Object)(setToTransparent ? EnumPhasingProgress.transparent : EnumPhasingProgress.base)));
        this.findNeighborPhasicBlocks(setToTransparent, worldIn, pos, updatedBlockState, 0, blocksToUpdate, setCurrentBlock);
        for (BlockPos positionToUpdate : blocksToUpdate) {
            worldIn.func_175656_a(positionToUpdate, updatedBlockState);
            if (!triggeredByRedstone) continue;
            if (ModEventHandler.RedstoneAffectedBlockPositions.contains(positionToUpdate) && !setToTransparent) {
                ModEventHandler.RedstoneAffectedBlockPositions.remove(positionToUpdate);
                continue;
            }
            if (ModEventHandler.RedstoneAffectedBlockPositions.contains(positionToUpdate) || !setToTransparent) continue;
            ModEventHandler.RedstoneAffectedBlockPositions.add(positionToUpdate);
        }
    }

    protected int findNeighborPhasicBlocks(boolean setToTransparent, World worldIn, BlockPos pos, IBlockState desiredBlockState, int cascadeCount, ArrayList<BlockPos> cascadedBlockPos, boolean setCurrentBlock) {
        if (++cascadeCount > 100) {
            return cascadeCount;
        }
        if (setCurrentBlock) {
            cascadedBlockPos.add(pos);
        }
        for (EnumFacing facing : EnumFacing.values()) {
            Block neighborBlock = worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
            if (!(neighborBlock instanceof BlockPhasing)) continue;
            IBlockState blockState = worldIn.func_180495_p(pos.func_177972_a(facing));
            EnumPhasingProgress progress = (EnumPhasingProgress)((Object)blockState.func_177229_b(Phasing_Progress));
            if (cascadedBlockPos.contains(pos.func_177972_a(facing)) || progress == desiredBlockState.func_177229_b(Phasing_Progress)) continue;
            setCurrentBlock = true;
            cascadeCount = this.findNeighborPhasicBlocks(setToTransparent, worldIn, pos.func_177972_a(facing), desiredBlockState, cascadeCount, cascadedBlockPos, setCurrentBlock);
            if (cascadeCount > 100) break;
        }
        return cascadeCount;
    }

    public static enum EnumPhasingProgress implements IStringSerializable
    {
        base(0, "base"),
        twenty_percent(2, "twenty_percent"),
        forty_percent(4, "forty_percent"),
        sixty_percent(6, "sixty_percent"),
        eighty_percent(8, "eighty_percent"),
        transparent(10, "transparent");

        private int meta;
        private String name;

        private EnumPhasingProgress(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumPhasingProgress ValueOf(int meta) {
            for (EnumPhasingProgress progress : EnumPhasingProgress.values()) {
                if (progress.meta != meta) continue;
                return progress;
            }
            return base;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

