/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Config;

import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Proxy.CommonProxy;
import com.wuest.prefab.UpdateChecker;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ModConfiguration {
    public static String OPTIONS = "general.options";
    public static String ChestContentOptions = "general.options.chest contents";
    public static String RecipeOptions = "general.options.recipes";
    public static String starterHouseOptions = "general.options.starter house";
    public static String tagKey = "PrefabConfig";
    private static String maximumHouseSizeName = "Maximum Starting House Size";
    private static String enableVersionCheckMessageName = "Enable Version Checking";
    private static String enableLoftHouseName = "Enable Loft House";
    private static String includeSpawnersInMasherName = "Include Spawners in Monster Masher";
    private static String enableStructurePreviewName = "Include Structure Previews";
    private static String includeMineshaftChestName = "Include Mineshaft Chest";
    private static String addSwordName = "Add Sword";
    private static String addAxeName = "Add Axe";
    private static String addHoeName = "Add Hoe";
    private static String addShovelName = "Add Shovel";
    private static String addPickAxeName = "Add Pickaxe";
    private static String addArmorName = "Add Armor";
    private static String addFoodName = "Add Food";
    private static String addCropsName = "Add Crops";
    private static String addDirtName = "Add Dirt";
    private static String addCobbleName = "Add Cobblestone";
    private static String addSaplingsName = "Add Saplings";
    private static String addTorchesName = "Add Torches";
    private static String startingItemName = "Starting Item";
    private static String addBedName = "Add Bed";
    private static String addCraftingTableName = "Add Crafting Table";
    private static String addFurnaceName = "Add Furnace";
    private static String addChestsName = "Add Chests";
    private static String addChestContentsName = "Add Chest Contents";
    private static String addFarmName = "Add Farm";
    private static String addMineshaftName = "Add Mineshaft";
    private static String versionMessageName = "Version Message";
    private static String showMessageName = "Show Message";
    public int maximumStartingHouseSize = 16;
    public boolean enableVersionCheckMessage = true;
    public boolean enableLoftHouse;
    public boolean includeSpawnersInMasher = true;
    public boolean enableStructurePreview = true;
    public boolean includeMineshaftChest;
    public boolean addSword;
    public boolean addAxe;
    public boolean addHoe;
    public boolean addShovel;
    public boolean addPickAxe;
    public boolean addArmor;
    public boolean addFood;
    public boolean addCrops;
    public boolean addDirt;
    public boolean addCobble;
    public boolean addSaplings;
    public boolean addTorches;
    public boolean addBed;
    public boolean addCraftingTable;
    public boolean addFurnace;
    public boolean addChests;
    public boolean addChestContents;
    public boolean addFarm;
    public boolean addMineshaft;
    public String startingItem;
    public static String[] validStartingItems = new String[]{"Starter House", "Moderate House", "Structure Part", "Nothing"};
    public HashMap<String, Boolean> recipeConfiguration = new HashMap();
    public static String compressedStoneKey = "Compressed Stone";
    public static String compressedGlowStoneKey = "Compressed Glowstone";
    public static String compressedDirteKey = "Compressed Dirt";
    public static String compressedChestKey = "Compressed Chest";
    public static String pileOfBricksKey = "Pile of Bricks";
    public static String warehouseKey = "Warehouse";
    public static String produceFarmKey = "Produce Farm";
    public static String treeFarmKey = "Tree Farm";
    public static String chickenCoopKey = "Chicken Coop";
    public static String fishFarmKey = "Fish Farm";
    public static String warehouseUpgradeKey = "Warehouse Upgrade";
    public static String advancedWarehouseKey = "Advanced Warehouse";
    public static String monsterMasherKey = "Monster Masher";
    public static String bundleofTimberKey = "Bundle of Timber";
    public static String horseStableKey = "Horse Stable";
    public static String netherGateKey = "Nether Gate";
    public static String advancedChickenCoopKey = "Advanced Chicken Coop";
    public static String advancedHorseStableKey = "Advanced Horse Stable";
    public static String barnKey = "Barn";
    public static String machineryTowerKey = "Machinery Tower";
    public static String defenseBunkerKey = "Defense Bunker";
    public static String mineshaftEntranceKey = "Mineshaft Entrance";
    public static String enderGatewayKey = "Ender Gateway";
    public static String aquaBaseKey = "Aqua Base";
    public static String grassyPlainsKey = "Grassy Plains";
    public static String magicTempleKey = "Magic Temple";
    public static String instantBridgeKey = "Instant Bridge";
    public static String paperLanternKey = "Paper Lantern";
    public static String compressedObsidianKey = "Compressed Obsidian";
    public static String villagerHousesKey = "Villager Houses";
    public static String phasicBlockKey = "Phasic Block";
    public static String smartGlassKey = "Smart Glass";
    public static String greenHouseKey = "Green House";
    public static String startingHouseKey = "Starting House";
    public static String glassStairsKey = "Glass Stairs";
    public static String andesiteStairsKey = "Andesite Stairs";
    public static String dioriteStairsKey = "Diorite Stairs";
    public static String graniteStairsKey = "Granite Stairs";
    public static String glassSlabsKey = "Glass Slabs";
    public static String andesiteSlabsKey = "Andesite Slabs";
    public static String dioriteSlabKey = "Diorite Slabs";
    public static String grantiteSlabKey = "Granite Slabs";
    public static String moderateHouseKey = "Moderate House";
    public static String watchTowerKey = "Watch Tower";
    public static String bulldozerKey = "Bulldozer";
    public static String structurePartKey = "StructurePart";
    public static String jailKey = "Jail";
    public static String saloonKey = "Saloon";
    public static String[] recipeKeys = new String[]{compressedStoneKey, compressedGlowStoneKey, compressedDirteKey, compressedChestKey, pileOfBricksKey, warehouseKey, produceFarmKey, treeFarmKey, chickenCoopKey, fishFarmKey, warehouseUpgradeKey, advancedWarehouseKey, monsterMasherKey, bundleofTimberKey, horseStableKey, netherGateKey, advancedChickenCoopKey, advancedHorseStableKey, barnKey, machineryTowerKey, defenseBunkerKey, mineshaftEntranceKey, enderGatewayKey, magicTempleKey, instantBridgeKey, paperLanternKey, compressedObsidianKey, villagerHousesKey, phasicBlockKey, smartGlassKey, greenHouseKey, startingHouseKey, glassStairsKey, glassSlabsKey, andesiteStairsKey, andesiteSlabsKey, dioriteStairsKey, dioriteSlabKey, graniteStairsKey, grantiteSlabKey, moderateHouseKey, grassyPlainsKey, aquaBaseKey, watchTowerKey, bulldozerKey, structurePartKey, jailKey, saloonKey};
    public String versionMessage = "";
    public boolean showMessage = false;

    public static void syncConfig() {
        Configuration config = Prefab.config;
        if (CommonProxy.proxyConfiguration == null) {
            CommonProxy.proxyConfiguration = new ModConfiguration();
        }
        ConfigCategory mainCategory = config.getCategory(OPTIONS);
        CommonProxy.proxyConfiguration.startingItem = config.getString(startingItemName, OPTIONS, "Starting House", "Determines which starting item a player gets on first world join. Server configuration overrides client.", validStartingItems);
        Property startingItemProperty = mainCategory.get(startingItemName);
        CommonProxy.proxyConfiguration.maximumStartingHouseSize = config.getInt(maximumHouseSizeName, OPTIONS, 16, 5, 16, "Determines the maximum size the starting house can be generated as. Server configuration overrides client.");
        CommonProxy.proxyConfiguration.enableVersionCheckMessage = config.getBoolean(enableVersionCheckMessageName, OPTIONS, true, "Determines if version checking is enabled when application starts. Also determines if the chat message about old versions is shown when joining a world. Server configuration overrides client.");
        CommonProxy.proxyConfiguration.enableLoftHouse = config.getBoolean(enableLoftHouseName, OPTIONS, false, "Determines if the loft starter house is enabled. This house contains Nether materials in it's construction. Server configuration overrides client.");
        CommonProxy.proxyConfiguration.includeSpawnersInMasher = config.getBoolean(includeSpawnersInMasherName, OPTIONS, true, "Determines if the spawners for the Monster Masher building are included. Server configuration overrides client.");
        CommonProxy.proxyConfiguration.enableStructurePreview = config.getBoolean(enableStructurePreviewName, OPTIONS, true, "Determines if the Preview buttons in structure GUIs and other structure previews functions are enabled. Client side only.");
        CommonProxy.proxyConfiguration.includeMineshaftChest = config.getBoolean(includeMineshaftChestName, OPTIONS, true, "Determines if the mineshaft chest is included when building mineshafts for various structures.");
        config.get(OPTIONS, enableVersionCheckMessageName, true).setRequiresMcRestart(true);
        config.get(OPTIONS, enableLoftHouseName, false).setRequiresMcRestart(true);
        Property startingHouseProperty = null;
        Property moderateHouseProperty = null;
        if (mainCategory.containsKey("Add House Item On New Player Join")) {
            startingHouseProperty = mainCategory.remove((Object)"Add House Item On New Player Join");
        }
        if (mainCategory.containsKey("Add Moderate House on World Join")) {
            moderateHouseProperty = mainCategory.remove((Object)"Add Moderate House on World Join");
        }
        if (startingHouseProperty != null) {
            if (moderateHouseProperty == null) {
                startingItemProperty.set(startingHouseProperty.getBoolean() ? "Starting House" : "Nothing");
            } else if (startingHouseProperty.getBoolean()) {
                startingItemProperty.set(moderateHouseProperty.getBoolean() ? "Moderate House" : "Starting House");
            } else {
                startingItemProperty.set("Nothing");
            }
            CommonProxy.proxyConfiguration.startingItem = startingItemProperty.getString();
        }
        config.setCategoryComment(ChestContentOptions, "This category is to determine the contents of the chest created by the house item. When playing on a server, the server configuration is used.");
        CommonProxy.proxyConfiguration.addSword = config.getBoolean(addSwordName, ChestContentOptions, true, "Determines if a Stone Sword is added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addAxe = config.getBoolean(addAxeName, ChestContentOptions, true, "Determines if a Stone Axe is added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addShovel = config.getBoolean(addShovelName, ChestContentOptions, true, "Determines if a Stone Shovel is added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addHoe = config.getBoolean(addHoeName, ChestContentOptions, true, "Determines if a Stone Hoe is added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addPickAxe = config.getBoolean(addPickAxeName, ChestContentOptions, true, "Determines if a Stone Pickaxe is added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addArmor = config.getBoolean(addArmorName, ChestContentOptions, true, "Determines if Leather Armor is added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addFood = config.getBoolean(addFoodName, ChestContentOptions, true, "Determines if Bread is added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addCrops = config.getBoolean(addCropsName, ChestContentOptions, true, "Determines if seeds, potatoes and carros are added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addDirt = config.getBoolean(addDirtName, ChestContentOptions, true, "Determines if a stack of dirt is added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addCobble = config.getBoolean(addCobbleName, ChestContentOptions, true, "Determines if a stack of cobble is added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addSaplings = config.getBoolean(addSaplingsName, ChestContentOptions, true, "Determines if a set of oak saplings are added the the chest when the house is created.");
        CommonProxy.proxyConfiguration.addTorches = config.getBoolean(addTorchesName, ChestContentOptions, true, "Determines if a set of torches are added the the chest when the house is created.");
        config.setCategoryComment(starterHouseOptions, "This category is to determine which starter house options are enabled in the starter house item screen. Certain options also affect the moderate house as well.");
        CommonProxy.proxyConfiguration.addBed = config.getBoolean(addBedName, starterHouseOptions, true, "Determines if the bed is included in the starter house. When playing on a server, the server configuration is used");
        CommonProxy.proxyConfiguration.addCraftingTable = config.getBoolean(addCraftingTableName, starterHouseOptions, true, "Determines if the crafting table is included in the starter house. When playing on a server, the server configuration is used");
        CommonProxy.proxyConfiguration.addFurnace = config.getBoolean(addFurnaceName, starterHouseOptions, true, "Determines if the furnace is included in the starter house. When playing on a server, the server configuration is used");
        CommonProxy.proxyConfiguration.addChests = config.getBoolean(addChestsName, starterHouseOptions, true, "Determines if chests are included in the starter house. When playing on a server, the server configuration is used");
        CommonProxy.proxyConfiguration.addChestContents = config.getBoolean(addChestContentsName, starterHouseOptions, true, "Determines if the chest contents is included in the starter house. When playing on a server, the server configuration is used");
        CommonProxy.proxyConfiguration.addFarm = config.getBoolean(addFarmName, starterHouseOptions, true, "Determines if the farm is included in the basic starter house. When playing on a server, the server configuration is used");
        CommonProxy.proxyConfiguration.addMineshaft = config.getBoolean(addMineshaftName, starterHouseOptions, true, "Determines if the mineshaft is included in the starter house. When playing on a server, the server configuration is used");
        config.setCategoryComment(RecipeOptions, "This category determines if the recipes for the blocks/items in this are enabled");
        config.setCategoryRequiresMcRestart(RecipeOptions, true);
        config.setCategoryRequiresWorldRestart(starterHouseOptions, true);
        for (String key : recipeKeys) {
            boolean value = config.getBoolean(key, RecipeOptions, true, "Determines if the recipe(s) associated with the " + key + " are enabled.");
            CommonProxy.proxyConfiguration.recipeConfiguration.put(key, value);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public NBTTagCompound ToNBTTagCompound() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a(startingItemName, this.startingItem);
        tag.func_74768_a(maximumHouseSizeName, this.maximumStartingHouseSize);
        tag.func_74757_a(enableVersionCheckMessageName, this.enableVersionCheckMessage);
        tag.func_74757_a(enableLoftHouseName, this.enableLoftHouse);
        tag.func_74757_a(includeSpawnersInMasherName, this.includeSpawnersInMasher);
        tag.func_74757_a(enableStructurePreviewName, this.enableStructurePreview);
        tag.func_74757_a(includeMineshaftChestName, this.includeMineshaftChest);
        tag.func_74757_a(addSwordName, this.addSword);
        tag.func_74757_a(addAxeName, this.addAxe);
        tag.func_74757_a(addShovelName, this.addShovel);
        tag.func_74757_a(addHoeName, this.addHoe);
        tag.func_74757_a(addPickAxeName, this.addPickAxe);
        tag.func_74757_a(addArmorName, this.addArmor);
        tag.func_74757_a(addFoodName, this.addFood);
        tag.func_74757_a(addCropsName, this.addCrops);
        tag.func_74757_a(addDirtName, this.addDirt);
        tag.func_74757_a(addCobbleName, this.addCobble);
        tag.func_74757_a(addSaplingsName, this.addSaplings);
        tag.func_74757_a(addTorchesName, this.addTorches);
        tag.func_74757_a(addBedName, this.addBed);
        tag.func_74757_a(addCraftingTableName, this.addCraftingTable);
        tag.func_74757_a(addFurnaceName, this.addFurnace);
        tag.func_74757_a(addChestsName, this.addChests);
        tag.func_74757_a(addChestContentsName, this.addChestContents);
        tag.func_74757_a(addFarmName, this.addFarm);
        tag.func_74757_a(addMineshaftName, this.addMineshaft);
        tag.func_74778_a(versionMessageName, UpdateChecker.messageToShow);
        tag.func_74757_a(showMessageName, UpdateChecker.showMessage);
        for (Map.Entry<String, Boolean> entry : this.recipeConfiguration.entrySet()) {
            tag.func_74757_a(entry.getKey(), entry.getValue().booleanValue());
        }
        return tag;
    }

    public static ModConfiguration getFromNBTTagCompound(NBTTagCompound tag) {
        ModConfiguration config = new ModConfiguration();
        config.startingItem = tag.func_74779_i(startingItemName);
        config.enableVersionCheckMessage = tag.func_74767_n(enableVersionCheckMessageName);
        config.enableLoftHouse = tag.func_74767_n(enableLoftHouseName);
        config.maximumStartingHouseSize = tag.func_74762_e(maximumHouseSizeName);
        config.includeSpawnersInMasher = tag.func_74767_n(includeSpawnersInMasherName);
        config.enableStructurePreview = tag.func_74767_n(enableStructurePreviewName);
        config.includeMineshaftChest = tag.func_74767_n(includeMineshaftChestName);
        if (config.maximumStartingHouseSize < 5 || config.maximumStartingHouseSize > 16) {
            config.maximumStartingHouseSize = 16;
        }
        config.addSword = tag.func_74767_n(addSwordName);
        config.addAxe = tag.func_74767_n(addAxeName);
        config.addShovel = tag.func_74767_n(addShovelName);
        config.addHoe = tag.func_74767_n(addHoeName);
        config.addPickAxe = tag.func_74767_n(addPickAxeName);
        config.addArmor = tag.func_74767_n(addArmorName);
        config.addFood = tag.func_74767_n(addFoodName);
        config.addCrops = tag.func_74767_n(addCropsName);
        config.addDirt = tag.func_74767_n(addDirtName);
        config.addCobble = tag.func_74767_n(addCobbleName);
        config.addSaplings = tag.func_74767_n(addSaplingsName);
        config.addTorches = tag.func_74767_n(addTorchesName);
        config.addBed = tag.func_74767_n(addBedName);
        config.addCraftingTable = tag.func_74767_n(addCraftingTableName);
        config.addFurnace = tag.func_74767_n(addFurnaceName);
        config.addChests = tag.func_74767_n(addChestsName);
        config.addChestContents = tag.func_74767_n(addChestContentsName);
        config.addFarm = tag.func_74767_n(addFarmName);
        config.addMineshaft = tag.func_74767_n(addMineshaftName);
        config.versionMessage = tag.func_74779_i(versionMessageName);
        config.showMessage = tag.func_74767_n(showMessageName);
        for (String key : recipeKeys) {
            config.recipeConfiguration.put(key, tag.func_74767_n(key));
        }
        return config;
    }

    public static enum WallBlockType {
        Oak(0, "prefab.wall.block.type.oak"),
        Spruce(1, "prefab.wall.block.type.spruce"),
        Birch(2, "prefab.wall.block.type.birch"),
        Jungle(3, "prefab.wall.block.type.jungle"),
        Acacia(4, "prefab.wall.block.type.acacia"),
        DarkOak(5, "prefab.wall.block.type.darkoak");

        private final int value;
        private final String langKey;

        private WallBlockType(int newValue, String langKey) {
            this.value = newValue;
            this.langKey = langKey;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return GuiLangKeys.translateString(this.langKey);
        }

        public static WallBlockType ValueOf(int value) {
            switch (value) {
                case 1: {
                    return Spruce;
                }
                case 2: {
                    return Birch;
                }
                case 3: {
                    return Jungle;
                }
                case 4: {
                    return Acacia;
                }
                case 5: {
                    return DarkOak;
                }
            }
            return Oak;
        }
    }

    public static enum CeilingFloorBlockType {
        StoneBrick(0, "prefab.ceiling.block.type.stone"),
        Brick(1, "prefab.ceiling.block.type.brick"),
        SandStone(2, "prefab.ceiling.block.type.sand");

        private final int value;
        private final String langKey;

        private CeilingFloorBlockType(int newValue, String langKey) {
            this.value = newValue;
            this.langKey = langKey;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return GuiLangKeys.translateString(this.langKey);
        }

        public static CeilingFloorBlockType ValueOf(int value) {
            switch (value) {
                case 1: {
                    return Brick;
                }
                case 2: {
                    return SandStone;
                }
            }
            return StoneBrick;
        }
    }
}

