/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Gui.Controls;

import com.wuest.prefab.Gui.Controls.GuiTab;
import com.wuest.prefab.Gui.GuiTabScreen;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;

public class GuiTabTray
extends Gui {
    private static final ResourceLocation backgroundTextures = new ResourceLocation("prefab", "textures/gui/default_background.png");
    private ArrayList<GuiTab> tabs;
    public int trayWidth = 50;
    public int trayX = 0;
    public int trayY = 0;

    public GuiTabTray() {
        this.Initialize();
    }

    protected void Initialize() {
        this.tabs = new ArrayList();
    }

    public GuiTab AddTab(GuiTab tab) {
        if (this.tabs.size() == 0) {
            tab.InternalSetSelected(true);
        }
        this.tabs.add(tab);
        return tab;
    }

    public void RemoveTab(GuiTab tab) {
        this.tabs.remove((Object)tab);
    }

    public int TabCount() {
        return this.tabs.size();
    }

    public GuiTab GetSelectedTab() {
        if (this.tabs.size() > 0) {
            for (GuiTab tab : this.tabs) {
                if (!tab.getIsSelected()) continue;
                return tab;
            }
        }
        return null;
    }

    public void SetSelectedTab(GuiTab tab) {
        GuiTab firstTab = null;
        for (GuiTab guiTab : this.tabs) {
            if (firstTab == null) {
                firstTab = guiTab;
            }
            guiTab.InternalSetSelected(false);
        }
        if (tab != null) {
            tab.InternalSetSelected(true);
        } else {
            firstTab.InternalSetSelected(true);
        }
    }

    public boolean DoesTabNameExist(String name) {
        for (GuiTab tab : this.tabs) {
            if (!tab.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void DrawTabs(Minecraft mc, int mouseX, int mouseY) {
        mc.func_110434_K().func_110577_a(backgroundTextures);
        GuiTabScreen.drawModalRectWithCustomSizedTexture(this.trayX, this.trayY, 0, this.trayWidth, 35, this.trayWidth, 35.0f);
        for (GuiTab tab : this.tabs) {
            tab.drawTab(mc, mouseX, mouseY);
        }
    }

    public ArrayList<GuiTab> GetTabs() {
        return this.tabs;
    }
}

