/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Config;

import com.wuest.prefab.Structures.Base.BuildShape;
import com.wuest.prefab.Structures.Base.PositionOffset;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import com.wuest.prefab.Structures.Items.ItemBasicStructure;
import com.wuest.prefab.Structures.Predefined.StructureBasic;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BasicStructureConfiguration
extends StructureConfiguration {
    private static String structureEnumNameTag = "structureEnumName";
    private static String structureDisplayNameTag = "structureDisplayName";
    public EnumBasicStructureName basicStructureName = EnumBasicStructureName.AdvancedCoop;
    public String structureDisplayName;

    public String getDisplayName() {
        if (this.basicStructureName == EnumBasicStructureName.Custom) {
            return this.structureDisplayName;
        }
        return this.basicStructureName.getUnlocalizedName();
    }

    public boolean IsCustomStructure() {
        return this.basicStructureName == EnumBasicStructureName.Custom;
    }

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseFacing = EnumFacing.NORTH;
        this.basicStructureName = EnumBasicStructureName.Custom;
    }

    @Override
    protected void CustomReadFromNBTTag(NBTTagCompound messageTag, StructureConfiguration config) {
        BasicStructureConfiguration basicConfig = (BasicStructureConfiguration)config;
        if (messageTag.func_74764_b(structureEnumNameTag)) {
            basicConfig.basicStructureName = EnumBasicStructureName.valueOf(messageTag.func_74779_i(structureEnumNameTag));
        }
        if (messageTag.func_74764_b(structureDisplayNameTag)) {
            basicConfig.structureDisplayName = messageTag.func_74779_i(structureDisplayNameTag);
        }
    }

    @Override
    protected NBTTagCompound CustomWriteToNBTTagCompound(NBTTagCompound tag) {
        tag.func_74778_a(structureEnumNameTag, this.basicStructureName.name());
        if (this.structureDisplayName != null) {
            tag.func_74778_a(structureDisplayNameTag, this.structureDisplayName);
        }
        return tag;
    }

    @Override
    public BasicStructureConfiguration ReadFromNBTTagCompound(NBTTagCompound messageTag) {
        BasicStructureConfiguration config = new BasicStructureConfiguration();
        return (BasicStructureConfiguration)super.ReadFromNBTTagCompound(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(EntityPlayer player, World world, BlockPos hitBlockPos) {
        StructureBasic structure;
        String assetLocation = "";
        if (!this.IsCustomStructure()) {
            assetLocation = this.basicStructureName.getAssetLocation();
        }
        if ((structure = (StructureBasic)StructureBasic.CreateInstance(assetLocation, StructureBasic.class)).BuildStructure(this, world, hitBlockPos, EnumFacing.NORTH, player)) {
            ItemStack stack = ItemBasicStructure.getBasicStructureItemInHand(player);
            if (stack.func_190916_E() == 1) {
                player.field_71071_by.func_184437_d(stack);
            } else {
                stack.func_190920_e(stack.func_190916_E() - 1);
            }
            player.field_71069_bz.func_75142_b();
        }
    }

    static {
        EnumBasicStructureName.AdvancedCoop.getClearShape().setDirection(EnumFacing.SOUTH);
        EnumBasicStructureName.AdvancedCoop.getClearShape().setHeight(10);
        EnumBasicStructureName.AdvancedCoop.getClearShape().setWidth(11);
        EnumBasicStructureName.AdvancedCoop.getClearShape().setLength(11);
        EnumBasicStructureName.AdvancedCoop.getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.AdvancedCoop.getClearPositionOffset().setEastOffset(5);
        EnumBasicStructureName.AdvancedHorseStable.getClearShape().setDirection(EnumFacing.SOUTH);
        EnumBasicStructureName.AdvancedHorseStable.getClearShape().setHeight(8);
        EnumBasicStructureName.AdvancedHorseStable.getClearShape().setWidth(17);
        EnumBasicStructureName.AdvancedHorseStable.getClearShape().setLength(34);
        EnumBasicStructureName.AdvancedHorseStable.getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.AdvancedHorseStable.getClearPositionOffset().setEastOffset(8);
        EnumBasicStructureName.Barn.getClearShape().setDirection(EnumFacing.SOUTH);
        EnumBasicStructureName.Barn.getClearShape().setHeight(10);
        EnumBasicStructureName.Barn.getClearShape().setWidth(30);
        EnumBasicStructureName.Barn.getClearShape().setLength(35);
        EnumBasicStructureName.Barn.getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.Barn.getClearPositionOffset().setEastOffset(15);
        EnumBasicStructureName.MachineryTower.getClearShape().setDirection(EnumFacing.SOUTH);
        EnumBasicStructureName.MachineryTower.getClearShape().setHeight(12);
        EnumBasicStructureName.MachineryTower.getClearShape().setWidth(16);
        EnumBasicStructureName.MachineryTower.getClearShape().setLength(16);
        EnumBasicStructureName.MachineryTower.getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.MachineryTower.getClearPositionOffset().setEastOffset(8);
        EnumBasicStructureName.DefenseBunker.getClearShape().setDirection(EnumFacing.SOUTH);
        EnumBasicStructureName.DefenseBunker.getClearShape().setHeight(17);
        EnumBasicStructureName.DefenseBunker.getClearShape().setWidth(32);
        EnumBasicStructureName.DefenseBunker.getClearShape().setLength(32);
        EnumBasicStructureName.DefenseBunker.getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.DefenseBunker.getClearPositionOffset().setEastOffset(15);
        EnumBasicStructureName.MineshaftEntrance.getClearShape().setDirection(EnumFacing.SOUTH);
        EnumBasicStructureName.MineshaftEntrance.getClearShape().setHeight(6);
        EnumBasicStructureName.MineshaftEntrance.getClearShape().setWidth(7);
        EnumBasicStructureName.MineshaftEntrance.getClearShape().setLength(7);
        EnumBasicStructureName.MineshaftEntrance.getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.MineshaftEntrance.getClearPositionOffset().setEastOffset(3);
        EnumBasicStructureName.EnderGateway.getClearShape().setDirection(EnumFacing.SOUTH);
        EnumBasicStructureName.EnderGateway.getClearShape().setHeight(26);
        EnumBasicStructureName.EnderGateway.getClearShape().setWidth(17);
        EnumBasicStructureName.EnderGateway.getClearShape().setLength(17);
        EnumBasicStructureName.EnderGateway.getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.EnderGateway.getClearPositionOffset().setEastOffset(8);
        EnumBasicStructureName.AquaBase.getClearShape().setDirection(EnumFacing.SOUTH);
        EnumBasicStructureName.AquaBase.getClearShape().setHeight(27);
        EnumBasicStructureName.AquaBase.getClearShape().setWidth(25);
        EnumBasicStructureName.AquaBase.getClearShape().setLength(38);
        EnumBasicStructureName.AquaBase.getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.AquaBase.getClearPositionOffset().setEastOffset(12);
        EnumBasicStructureName.GrassyPlain.getClearShape().setDirection(EnumFacing.SOUTH);
        EnumBasicStructureName.GrassyPlain.getClearShape().setHeight(4);
        EnumBasicStructureName.GrassyPlain.getClearShape().setWidth(15);
        EnumBasicStructureName.GrassyPlain.getClearShape().setLength(15);
        EnumBasicStructureName.GrassyPlain.getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.GrassyPlain.getClearPositionOffset().setEastOffset(8);
        EnumBasicStructureName.GrassyPlain.getClearPositionOffset().setHeightOffset(-1);
        EnumBasicStructureName.MagicTemple.getClearShape().setDirection(EnumFacing.SOUTH);
        EnumBasicStructureName.MagicTemple.getClearShape().setHeight(13);
        EnumBasicStructureName.MagicTemple.getClearShape().setWidth(12);
        EnumBasicStructureName.MagicTemple.getClearShape().setLength(13);
        EnumBasicStructureName.MagicTemple.getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.MagicTemple.getClearPositionOffset().setEastOffset(6);
        EnumBasicStructureName.GreenHouse.getClearShape().setDirection(EnumFacing.SOUTH);
        EnumBasicStructureName.GreenHouse.getClearShape().setHeight(10);
        EnumBasicStructureName.GreenHouse.getClearShape().setWidth(15);
        EnumBasicStructureName.GreenHouse.getClearShape().setLength(31);
        EnumBasicStructureName.GreenHouse.getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.GreenHouse.getClearPositionOffset().setEastOffset(8);
        EnumBasicStructureName.WatchTower.getClearShape().setDirection(EnumFacing.SOUTH);
        EnumBasicStructureName.WatchTower.getClearShape().setHeight(16);
        EnumBasicStructureName.WatchTower.getClearShape().setWidth(9);
        EnumBasicStructureName.WatchTower.getClearShape().setLength(9);
        EnumBasicStructureName.WatchTower.getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.WatchTower.getClearPositionOffset().setEastOffset(4);
        EnumBasicStructureName.WelcomeCenter.getClearShape().setDirection(EnumFacing.SOUTH);
        EnumBasicStructureName.WelcomeCenter.getClearShape().setHeight(24);
        EnumBasicStructureName.WelcomeCenter.getClearShape().setWidth(18);
        EnumBasicStructureName.WelcomeCenter.getClearShape().setLength(48);
        EnumBasicStructureName.WelcomeCenter.getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.WelcomeCenter.getClearPositionOffset().setEastOffset(4);
        EnumBasicStructureName.WelcomeCenter.getClearPositionOffset().setHeightOffset(-5);
        EnumBasicStructureName.Jail.getClearShape().setDirection(EnumFacing.SOUTH);
        EnumBasicStructureName.Jail.getClearShape().setHeight(14);
        EnumBasicStructureName.Jail.getClearShape().setWidth(27);
        EnumBasicStructureName.Jail.getClearShape().setLength(32);
        EnumBasicStructureName.Jail.getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.Jail.getClearPositionOffset().setEastOffset(25);
        EnumBasicStructureName.Jail.getClearPositionOffset().setHeightOffset(-3);
        EnumBasicStructureName.Saloon.getClearShape().setDirection(EnumFacing.SOUTH);
        EnumBasicStructureName.Saloon.getClearShape().setHeight(14);
        EnumBasicStructureName.Saloon.getClearShape().setWidth(18);
        EnumBasicStructureName.Saloon.getClearShape().setLength(16);
        EnumBasicStructureName.Saloon.getClearPositionOffset().setSouthOffset(1);
        EnumBasicStructureName.Saloon.getClearPositionOffset().setEastOffset(10);
        EnumBasicStructureName.Saloon.getClearPositionOffset().setHeightOffset(-1);
    }

    public static enum EnumBasicStructureName {
        Custom("custom", null, null, null, null, 0, 0),
        AdvancedCoop("advancedcoop", "item.prefab.advanced.chicken.coop", "assets/prefab/structures/advancedcoop.zip", "textures/gui/advanced_chicken_coop_topdown.png", "item_advanced_chicken_coop", 156, 121),
        AdvancedHorseStable("advanced_horse_stable", "item.prefab.advanced.horse.stable", "assets/prefab/structures/advanced_horse_stable.zip", "textures/gui/advanced_horse_stable_topdown.png", "item_advanced_horse_stable", 128, 158),
        Barn("barn", "item.prefab.barn", "assets/prefab/structures/barn.zip", "textures/gui/barn_topdown.png", "item_barn", 164, 160),
        MachineryTower("machinery_tower", "item.prefab.machinery.tower", "assets/prefab/structures/machinery_tower.zip", "textures/gui/machinery_tower_topdown.png", "item_machinery_tower", 153, 175),
        DefenseBunker("defense_bunker", "item.prefab.defense.bunker", "assets/prefab/structures/defense_bunker.zip", "textures/gui/defense_bunker_topdown.png", "item_defense_bunker", 153, 175),
        MineshaftEntrance("mineshaft_entrance", "item.prefab.mineshaft.entrance", "assets/prefab/structures/mineshaft_entrance.zip", "textures/gui/mineshaft_entrance_topdown.png", "item_mineshaft_entrance", 135, 159),
        EnderGateway("ender_gateway", "item.prefab.ender_gateway", "assets/prefab/structures/ender_gateway.zip", "textures/gui/ender_gateway_topdown.png", "item_ender_gateway", 150, 103),
        AquaBase("aqua_base", "item.prefab.aqua_base", "assets/prefab/structures/aqua_base.zip", "textures/gui/aqua_base_topdown.png", "item_aqua_base", 160, 119),
        GrassyPlain("grassy_plain", "item.prefab.grassy_plain", "assets/prefab/structures/grassy_plain.zip", "textures/gui/grassy_plain_topdown.png", "item_grassy_plain", 160, 160),
        MagicTemple("magic_temple", "item.prefab.magic_temple", "assets/prefab/structures/magic_temple.zip", "textures/gui/magic_temple_topdown.png", "item_magic_temple", 146, 156),
        GreenHouse("green_house", "item.prefab.green_house", "assets/prefab/structures/green_house.zip", "textures/gui/green_house_topdown.png", "item_green_house", 104, 173),
        WatchTower("watch_tower", "item.prefab.watch_tower", "assets/prefab/structures/watch_tower.zip", "textures/gui/watch_tower_topdown.png", "item_watch_tower", 176, 133),
        WelcomeCenter("welcome_center", "item.prefab.welcome_center", "assets/prefab/structures/welcome_center.zip", "textures/gui/welcome_center_topdown.png", "item_welcome_center", 121, 168),
        Jail("jail", "item.prefab.jail", "assets/prefab/structures/jail.zip", "textures/gui/jail_topdown.png", "item_jail", 131, 175),
        Saloon("saloon", "item.prefab.saloon", "assets/prefab/structures/saloon.zip", "textures/gui/saloon_topdown.png", "item_saloon", 130, 170);

        private String name;
        private String assetLocation;
        private String topDownPictureLocation;
        private String unlocalizedName;
        private BuildShape clearShape;
        private ResourceLocation resourceLocation;
        private PositionOffset clearPositionOffset;
        private int imageHeight;
        private int imageWidth;

        private EnumBasicStructureName(String name, String unlocalizedName, String assetLocation, String topDownPictureLocation, String resourceLocation, int imageHeight, int imageWidth) {
            this.name = name;
            this.unlocalizedName = unlocalizedName;
            this.assetLocation = assetLocation;
            this.topDownPictureLocation = topDownPictureLocation;
            this.imageHeight = imageHeight;
            this.imageWidth = imageWidth;
            this.clearShape = new BuildShape();
            this.clearPositionOffset = new PositionOffset();
            if (resourceLocation != null) {
                this.resourceLocation = new ResourceLocation("prefab", resourceLocation);
            }
        }

        public String getName() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public String getAssetLocation() {
            return this.assetLocation;
        }

        public ResourceLocation getTopDownPictureLocation() {
            if (this.topDownPictureLocation != null) {
                return new ResourceLocation("prefab", this.topDownPictureLocation);
            }
            return null;
        }

        public BuildShape getClearShape() {
            return this.clearShape;
        }

        public PositionOffset getClearPositionOffset() {
            return this.clearPositionOffset;
        }

        public ResourceLocation getResourceLocation() {
            return this.resourceLocation;
        }

        public int getImageHeight() {
            return this.imageHeight;
        }

        public int getImageWidth() {
            return this.imageWidth;
        }
    }
}

