/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Config;

import com.wuest.prefab.Config.EntityPlayerConfiguration;
import com.wuest.prefab.Config.ModConfiguration;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Proxy.Messages.PlayerEntityTagMessage;
import com.wuest.prefab.Structures.Base.BuildingMethods;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import com.wuest.prefab.Structures.Predefined.StructureAlternateStart;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class HouseConfiguration
extends StructureConfiguration {
    protected static BlockPos NorthEastCorner;
    protected static BlockPos SouthEastCorner;
    protected static BlockPos SouthWestCorner;
    protected static BlockPos NorthWestCorner;
    private static String addTorchesTag;
    private static String addBedTag;
    private static String addCraftingTableTag;
    private static String addFurnaceTag;
    private static String addChestTag;
    private static String addChestContentsTag;
    private static String addFarmTag;
    private static String floorBlockTag;
    private static String ceilingBlockTag;
    private static String wallWoodTypeTag;
    private static String isCeilingFlatTag;
    private static String addMineShaftTag;
    private static String hitXTag;
    private static String hitYTag;
    private static String hitZTag;
    private static String houseWidthTag;
    private static String houseDepthTag;
    private static String houseFacingTag;
    private static String houseStyleTag;
    private static String glassColorTag;
    public boolean addTorches;
    public boolean addBed;
    public boolean addCraftingTable;
    public boolean addFurnace;
    public boolean addChest;
    public boolean addChestContents;
    public boolean addFarm;
    public ModConfiguration.CeilingFloorBlockType floorBlock;
    public ModConfiguration.CeilingFloorBlockType ceilingBlock;
    public ModConfiguration.WallBlockType wallWoodType;
    public boolean isCeilingFlat;
    public boolean addMineShaft;
    public HouseStyle houseStyle;
    public EnumDyeColor glassColor;
    public int houseWidth;
    public int houseDepth;

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseStyle = HouseStyle.BASIC;
        this.glassColor = EnumDyeColor.CYAN;
        this.floorBlock = ModConfiguration.CeilingFloorBlockType.StoneBrick;
        this.ceilingBlock = ModConfiguration.CeilingFloorBlockType.StoneBrick;
        this.wallWoodType = ModConfiguration.WallBlockType.Oak;
        this.houseDepth = 9;
        this.houseWidth = 9;
        this.addTorches = true;
        this.addBed = true;
        this.addCraftingTable = true;
        this.addFurnace = true;
        this.addChest = true;
        this.addChestContents = true;
        this.addFarm = true;
        this.isCeilingFlat = false;
        this.addMineShaft = true;
    }

    @Override
    public NBTTagCompound WriteToNBTTagCompound() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a(addTorchesTag, this.addTorches);
        tag.func_74757_a(addBedTag, this.addBed);
        tag.func_74757_a(addCraftingTableTag, this.addCraftingTable);
        tag.func_74757_a(addFurnaceTag, this.addFurnace);
        tag.func_74757_a(addChestTag, this.addChest);
        tag.func_74757_a(addChestContentsTag, this.addChestContents);
        tag.func_74757_a(addFarmTag, this.addFarm);
        tag.func_74768_a(floorBlockTag, this.floorBlock.getValue());
        tag.func_74768_a(ceilingBlockTag, this.ceilingBlock.getValue());
        tag.func_74768_a(wallWoodTypeTag, this.wallWoodType.getValue());
        tag.func_74757_a(isCeilingFlatTag, this.isCeilingFlat);
        tag.func_74757_a(addMineShaftTag, this.addMineShaft);
        tag.func_74768_a(hitXTag, this.pos.func_177958_n());
        tag.func_74768_a(hitYTag, this.pos.func_177956_o());
        tag.func_74768_a(hitZTag, this.pos.func_177952_p());
        tag.func_74768_a(houseDepthTag, this.houseDepth);
        tag.func_74768_a(houseWidthTag, this.houseWidth);
        tag.func_74778_a(houseFacingTag, this.houseFacing.func_176610_l());
        tag.func_74768_a(houseStyleTag, this.houseStyle.value);
        tag.func_74778_a(glassColorTag, this.glassColor.func_176610_l().toUpperCase());
        return tag;
    }

    public static String GetIntegerOptionStringValue(String name, int value) {
        if (name.equals("prefab.gui.starter.ceilingtype") || name.equals("prefab.gui.starter.floorstone")) {
            return " - " + ModConfiguration.CeilingFloorBlockType.ValueOf(value).getName();
        }
        if (name.equals("prefab.gui.starter.walltype")) {
            return " - " + ModConfiguration.WallBlockType.ValueOf(value).getName();
        }
        return "";
    }

    @Override
    public HouseConfiguration ReadFromNBTTagCompound(NBTTagCompound tag) {
        HouseConfiguration config = null;
        if (tag != null) {
            config = new HouseConfiguration();
            if (tag.func_74764_b(addTorchesTag)) {
                config.addTorches = tag.func_74767_n(addTorchesTag);
            }
            if (tag.func_74764_b(addBedTag)) {
                config.addBed = tag.func_74767_n(addBedTag);
            }
            if (tag.func_74764_b(addCraftingTableTag)) {
                config.addCraftingTable = tag.func_74767_n(addCraftingTableTag);
            }
            if (tag.func_74764_b(addFurnaceTag)) {
                config.addFurnace = tag.func_74767_n(addFurnaceTag);
            }
            if (tag.func_74764_b(addChestTag)) {
                config.addChest = tag.func_74767_n(addChestTag);
            }
            if (tag.func_74764_b(addChestContentsTag)) {
                config.addChestContents = tag.func_74767_n(addChestContentsTag);
            }
            if (tag.func_74764_b(addFarmTag)) {
                config.addFarm = tag.func_74767_n(addFarmTag);
            }
            if (tag.func_74764_b(floorBlockTag)) {
                config.floorBlock = ModConfiguration.CeilingFloorBlockType.ValueOf(tag.func_74762_e(floorBlockTag));
            }
            if (tag.func_74764_b(ceilingBlockTag)) {
                config.ceilingBlock = ModConfiguration.CeilingFloorBlockType.ValueOf(tag.func_74762_e(ceilingBlockTag));
            }
            if (tag.func_74764_b(wallWoodTypeTag)) {
                config.wallWoodType = ModConfiguration.WallBlockType.ValueOf(tag.func_74762_e(wallWoodTypeTag));
            }
            if (tag.func_74764_b(isCeilingFlatTag)) {
                config.isCeilingFlat = tag.func_74767_n(isCeilingFlatTag);
            }
            if (tag.func_74764_b(addMineShaftTag)) {
                config.addMineShaft = tag.func_74767_n(addMineShaftTag);
            }
            if (tag.func_74764_b(hitXTag)) {
                config.pos = new BlockPos(tag.func_74762_e(hitXTag), tag.func_74762_e(hitYTag), tag.func_74762_e(hitZTag));
            }
            if (tag.func_74764_b(houseDepthTag)) {
                config.houseDepth = tag.func_74762_e(houseDepthTag);
            }
            if (tag.func_74764_b(houseWidthTag)) {
                config.houseWidth = tag.func_74762_e(houseWidthTag);
            }
            if (tag.func_74764_b(houseFacingTag)) {
                config.houseFacing = EnumFacing.func_176739_a((String)tag.func_74779_i(houseFacingTag));
            }
            if (tag.func_74764_b(houseStyleTag)) {
                config.houseStyle = HouseStyle.ValueOf(tag.func_74762_e(houseStyleTag));
            }
            if (tag.func_74764_b(glassColorTag)) {
                config.glassColor = EnumDyeColor.valueOf((String)tag.func_74779_i(glassColorTag));
            }
        }
        return config;
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(EntityPlayer player, World world, BlockPos hitBlockPos) {
        boolean houseBuilt = true;
        if (this.houseStyle == HouseStyle.BASIC) {
            BlockPos endBlockPos;
            BlockPos startingPosition = hitBlockPos.func_177984_a();
            EnumFacing northFace = this.houseFacing;
            EnumFacing southFace = northFace.func_176734_d();
            NorthEastCorner = startingPosition.func_177972_a(southFace).func_177972_a(northFace.func_176746_e());
            SouthEastCorner = NorthEastCorner.func_177967_a(southFace, this.houseDepth + 1);
            SouthWestCorner = SouthEastCorner.func_177967_a(northFace.func_176735_f(), this.houseWidth + 1);
            NorthWestCorner = NorthEastCorner.func_177967_a(northFace.func_176735_f(), this.houseWidth + 1);
            startingPosition = NorthEastCorner.func_177967_a(southFace, (int)Math.floor(this.houseDepth / 2) + 1).func_177967_a(northFace.func_176735_f(), (int)Math.floor(this.houseWidth / 2) + 1);
            if (!BuildingMethods.CheckBuildSpaceForAllowedBlockReplacement(this, world, startingPosition, endBlockPos = startingPosition.func_177967_a(northFace.func_176735_f(), this.houseWidth + 11).func_177967_a(southFace, this.houseDepth + 11).func_177967_a(EnumFacing.UP, 15), player)) {
                player.func_145747_a(new TextComponentTranslation("prefab.gui.structure.nobuild", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
                return;
            }
            BuildingMethods.ClearSpace(world, NorthEastCorner, this.houseWidth, 15, this.houseDepth, northFace);
            HouseConfiguration.BuildStructure(world, startingPosition, this, northFace);
            HouseConfiguration.BuildInterior(world, startingPosition, player, this, northFace);
            HouseConfiguration.BuildExterior(world, startingPosition, player, this, northFace);
            if (this.addMineShaft && startingPosition.func_177956_o() > 15) {
                HouseConfiguration.PlaceMineShaft(world, startingPosition, this.houseDepth, northFace);
            }
            houseBuilt = true;
        } else {
            StructureAlternateStart structure = (StructureAlternateStart)StructureAlternateStart.CreateInstance(this.houseStyle.getStructureLocation(), StructureAlternateStart.class);
            houseBuilt = structure.BuildStructure(this, world, hitBlockPos, EnumFacing.NORTH, player);
        }
        if (houseBuilt) {
            EntityPlayerConfiguration playerConfig = EntityPlayerConfiguration.loadFromEntityData((EntityPlayer)((EntityPlayerMP)player));
            playerConfig.builtStarterHouse = true;
            playerConfig.saveToPlayer(player);
            player.field_71071_by.func_174925_a((Item)ModRegistry.StartHouse(), -1, 1, null);
            player.field_71069_bz.func_75142_b();
            Prefab.network.sendTo((IMessage)new PlayerEntityTagMessage(playerConfig.getModIsPlayerNewTag(player)), (EntityPlayerMP)player);
        }
    }

    private static void BuildStructure(World world, BlockPos startingPosition, HouseConfiguration configuration, EnumFacing facing) {
        BlockPos pos = NorthEastCorner;
        BuildingMethods.SetFloor(world, pos.func_177979_c(2), Blocks.field_150346_d, configuration.houseWidth + 2, configuration.houseDepth + 2, new ArrayList<ItemStack>(), facing.func_176734_d(), null);
        Block floor = null;
        switch (configuration.floorBlock) {
            case Brick: {
                floor = Blocks.field_150336_V;
                break;
            }
            case SandStone: {
                floor = Blocks.field_150322_A;
                break;
            }
            default: {
                floor = Blocks.field_150417_aV;
            }
        }
        BuildingMethods.SetFloor(world, pos.func_177977_b(), floor, configuration.houseWidth + 2, configuration.houseDepth + 2, new ArrayList<ItemStack>(), facing.func_176734_d(), null);
        HouseConfiguration.SetWalls(world, ((BlockPlanks)Blocks.field_150344_f).func_176203_a(configuration.wallWoodType.getValue()), configuration, facing);
        Block ceiling = null;
        Block stairs = null;
        switch (configuration.ceilingBlock) {
            case Brick: {
                ceiling = Blocks.field_150336_V;
                stairs = Blocks.field_150389_bf;
                break;
            }
            case SandStone: {
                ceiling = Blocks.field_150322_A;
                stairs = Blocks.field_150372_bz;
                break;
            }
            default: {
                ceiling = Blocks.field_150417_aV;
                stairs = Blocks.field_150390_bg;
            }
        }
        pos = pos.func_177981_b(4);
        BuildingMethods.SetCeiling(world, pos, ceiling, configuration.houseWidth + 2, configuration.houseDepth + 2, stairs, configuration, facing, null);
    }

    private static void BuildInterior(World world, BlockPos startingPosition, EntityPlayer player, HouseConfiguration configuration, EnumFacing facing) {
        BlockPos northEastCornerPosition = NorthEastCorner.func_177984_a();
        BlockPos southEastCornerPosition = SouthEastCorner.func_177984_a();
        BlockPos northWestCornerPosition = NorthWestCorner.func_177984_a();
        BlockPos southWestCornerPosition = SouthWestCorner.func_177984_a();
        BlockPos itemPosition = northEastCornerPosition;
        HouseConfiguration.PlaceInsideTorches(world, configuration, facing);
        HouseConfiguration.DecorateDoor(world, northEastCornerPosition, player, configuration, facing);
        if (configuration.addBed) {
            HouseConfiguration.PlaceBed(world, northWestCornerPosition, facing);
        }
        HouseConfiguration.PlaceAndFillCraftingMachines(player, world, southWestCornerPosition, facing, configuration.addCraftingTable, configuration.addFurnace);
        if (configuration.addChest) {
            HouseConfiguration.PlaceAndFillChest(player, world, southEastCornerPosition, configuration, facing);
        }
    }

    private static void BuildExterior(World world, BlockPos startingPosition, EntityPlayer player, HouseConfiguration configuration, EnumFacing facing) {
        BlockPos northEastCornerPosition = NorthEastCorner.func_177984_a();
        BlockPos southEastCornerPosition = SouthEastCorner.func_177984_a();
        BlockPos northWestCornerPosition = NorthWestCorner.func_177984_a();
        BlockPos southWestCornerPosition = SouthWestCorner.func_177984_a();
        HouseConfiguration.PlaceOutsideTorches(world, northEastCornerPosition, configuration, facing);
        if (configuration.addFarm) {
            HouseConfiguration.PlaceSmallFarm(world, northEastCornerPosition.func_177977_b(), facing);
        }
    }

    private static void SetWalls(World world, IBlockState block, HouseConfiguration configuration, EnumFacing facing) {
        BlockPos pos = NorthEastCorner;
        facing = facing.func_176734_d();
        BuildingMethods.CreateWall(world, 4, configuration.houseDepth + 1, facing, pos, block);
        facing = facing.func_176746_e();
        pos = SouthEastCorner;
        BuildingMethods.CreateWall(world, 4, configuration.houseWidth + 2, facing, pos, block);
        facing = facing.func_176746_e();
        pos = SouthWestCorner;
        BuildingMethods.CreateWall(world, 4, configuration.houseDepth + 2, facing, pos, block);
        facing = facing.func_176746_e();
        pos = NorthWestCorner;
        BuildingMethods.CreateWall(world, 4, configuration.houseWidth + 2, facing, pos, block);
    }

    private static void PlaceInsideTorches(World world, HouseConfiguration configuration, EnumFacing facing) {
        int blocksMoved;
        BlockPos itemPosition = null;
        int torchWidthOffset = configuration.houseWidth < 9 ? 2 : 4;
        int torchDepthOffset = configuration.houseDepth < 9 ? 2 : 4;
        itemPosition = NorthEastCorner.func_177967_a(facing.func_176735_f(), torchWidthOffset).func_177972_a(facing.func_176734_d()).func_177984_a();
        IBlockState blockState = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing.func_176734_d());
        BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        for (blocksMoved = torchWidthOffset; blocksMoved < configuration.houseWidth; blocksMoved += torchWidthOffset) {
            if (!world.func_175623_d(itemPosition = itemPosition.func_177967_a(facing.func_176735_f(), torchWidthOffset)) || world.func_175623_d(itemPosition.func_177972_a(facing))) continue;
            BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        }
        itemPosition = NorthEastCorner.func_177967_a(facing.func_176734_d(), torchDepthOffset).func_177972_a(facing.func_176735_f()).func_177984_a();
        blockState = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing.func_176735_f());
        BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        for (blocksMoved = torchDepthOffset; blocksMoved < configuration.houseDepth; blocksMoved += torchDepthOffset) {
            if (!world.func_175623_d(itemPosition = itemPosition.func_177967_a(facing.func_176734_d(), torchDepthOffset)) || world.func_175623_d(itemPosition.func_177972_a(facing.func_176746_e()))) continue;
            BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        }
        itemPosition = NorthWestCorner.func_177967_a(facing.func_176734_d(), torchDepthOffset).func_177972_a(facing.func_176746_e()).func_177984_a();
        blockState = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing.func_176746_e());
        BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        for (blocksMoved = torchDepthOffset; blocksMoved < configuration.houseDepth; blocksMoved += torchDepthOffset) {
            if (!world.func_175623_d(itemPosition = itemPosition.func_177967_a(facing.func_176734_d(), torchDepthOffset)) || world.func_175623_d(itemPosition.func_177972_a(facing.func_176735_f()))) continue;
            BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        }
        itemPosition = SouthEastCorner.func_177967_a(facing.func_176735_f(), torchWidthOffset).func_177972_a(facing).func_177984_a();
        blockState = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing);
        BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        for (blocksMoved = torchDepthOffset; blocksMoved < configuration.houseWidth; blocksMoved += torchDepthOffset) {
            if (!world.func_175623_d(itemPosition = itemPosition.func_177967_a(facing.func_176735_f(), torchDepthOffset)) || world.func_175623_d(itemPosition.func_177972_a(facing.func_176734_d()))) continue;
            BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        }
    }

    private static void DecorateDoor(World world, BlockPos cornerPosition, EntityPlayer player, HouseConfiguration configuration, EnumFacing facing) {
        BlockPos itemPosition = cornerPosition.func_177972_a(facing.func_176735_f());
        world.func_175698_g(itemPosition);
        BlockDoor door = null;
        Block stairs = null;
        switch (configuration.wallWoodType) {
            case Spruce: {
                door = Blocks.field_180414_ap;
                stairs = Blocks.field_150485_bF;
                break;
            }
            case Birch: {
                door = Blocks.field_180412_aq;
                stairs = Blocks.field_150487_bG;
                break;
            }
            case Jungle: {
                door = Blocks.field_180411_ar;
                stairs = Blocks.field_150481_bH;
                break;
            }
            case Acacia: {
                door = Blocks.field_180410_as;
                stairs = Blocks.field_150400_ck;
                break;
            }
            case DarkOak: {
                door = Blocks.field_180409_at;
                stairs = Blocks.field_150401_cl;
                break;
            }
            default: {
                door = Blocks.field_180413_ao;
                stairs = Blocks.field_150476_ad;
            }
        }
        ItemDoor.func_179235_a((World)world, (BlockPos)itemPosition.func_177977_b(), (EnumFacing)facing, (Block)door, (boolean)true);
        BuildingMethods.ReplaceBlock(world, itemPosition.func_177984_a(), Blocks.field_150410_aZ);
        itemPosition = itemPosition.func_177972_a(facing.func_176734_d()).func_177977_b();
        BuildingMethods.ReplaceBlock(world, itemPosition, Blocks.field_150452_aw);
        itemPosition = itemPosition.func_177967_a(facing, 2).func_177972_a(facing.func_176735_f());
        BlockSign sign = (BlockSign)Blocks.field_150472_an;
        int signMeta = 8;
        switch (facing) {
            case EAST: {
                signMeta = 12;
                break;
            }
            case SOUTH: {
                signMeta = 0;
                break;
            }
            case WEST: {
                signMeta = 4;
                break;
            }
        }
        BuildingMethods.ReplaceBlock(world, itemPosition.func_177977_b(), Blocks.field_150346_d);
        BuildingMethods.ReplaceBlock(world, itemPosition, sign.func_176203_a(signMeta));
        TileEntity tileEntity = world.func_175625_s(itemPosition);
        if (tileEntity instanceof TileEntitySign) {
            TileEntitySign signTile = (TileEntitySign)tileEntity;
            signTile.field_145915_a[0] = new TextComponentString("This is");
            signTile.field_145915_a[1] = player.getDisplayNameString().length() >= 15 ? new TextComponentString(player.getDisplayNameString()) : new TextComponentString(player.getDisplayNameString() + "'s");
            signTile.field_145915_a[2] = new TextComponentString("house!");
        }
    }

    private static void PlaceBed(World world, BlockPos cornerPosition, EnumFacing facing) {
        IBlockState bedFootState;
        BlockPos itemPosition = cornerPosition.func_177967_a(facing.func_176746_e(), 1).func_177967_a(facing.func_176734_d(), 2).func_177977_b();
        if (world.func_180501_a(itemPosition, bedFootState = Blocks.field_150324_C.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing).func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT), 3)) {
            IBlockState bedHeadState = bedFootState.func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.HEAD);
            world.func_180501_a(itemPosition.func_177972_a(facing), bedHeadState, 3);
        }
    }

    private static void PlaceAndFillChest(EntityPlayer player, World world, BlockPos cornerPosition, HouseConfiguration configuration, EnumFacing facing) {
        BlockPos itemPosition = cornerPosition.func_177972_a(facing).func_177972_a(facing.func_176735_f()).func_177977_b();
        IBlockState chestState = Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)facing);
        BuildingMethods.ReplaceBlock(world, itemPosition, chestState);
        itemPosition = itemPosition.func_177972_a(facing.func_176735_f());
        BuildingMethods.ReplaceBlock(world, itemPosition, chestState);
        if (configuration.addChestContents) {
            StructureAlternateStart.FillChest(world, itemPosition, configuration, player);
        }
    }

    private static void PlaceAndFillCraftingMachines(EntityPlayer player, World world, BlockPos cornerPosition, EnumFacing facing, boolean addCraftingTable, boolean addFurnace) {
        BlockPos itemPosition = cornerPosition.func_177972_a(facing.func_176746_e()).func_177972_a(facing).func_177977_b();
        if (addCraftingTable) {
            BuildingMethods.ReplaceBlock(world, itemPosition, Blocks.field_150462_ai);
        }
        if (addFurnace) {
            itemPosition = itemPosition.func_177972_a(facing.func_176746_e());
            BuildingMethods.ReplaceBlock(world, itemPosition, Blocks.field_150460_al.func_176223_P().func_177226_a((IProperty)BlockFurnace.field_176447_a, (Comparable)facing));
            TileEntity tileEntity = world.func_175625_s(itemPosition);
            if (tileEntity instanceof TileEntityFurnace) {
                TileEntityFurnace furnaceTile = (TileEntityFurnace)tileEntity;
                furnaceTile.func_70299_a(1, new ItemStack(Items.field_151044_h, 20));
            }
        }
    }

    private static void PlaceOutsideTorches(World world, BlockPos cornerPosition, HouseConfiguration configuration, EnumFacing facing) {
        int blocksMoved;
        BlockPos itemPosition = NorthEastCorner.func_177972_a(facing);
        int houseDepth = configuration.houseDepth + 2;
        int houseWidth = configuration.houseWidth + 2;
        int torchWidthOffset = configuration.houseWidth < 9 ? 3 : 4;
        int torchDepthOffset = configuration.houseDepth < 9 ? 3 : 4;
        IBlockState blockState = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing);
        BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        for (blocksMoved = torchWidthOffset; blocksMoved <= houseWidth; blocksMoved += torchWidthOffset) {
            if (!world.func_175623_d(itemPosition = itemPosition.func_177967_a(facing.func_176735_f(), torchWidthOffset)) || !world.isSideSolid(itemPosition.func_177972_a(facing.func_176734_d()), facing)) continue;
            BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        }
        itemPosition = NorthEastCorner.func_177972_a(facing.func_176746_e());
        blockState = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing.func_176746_e());
        BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        for (blocksMoved = torchDepthOffset; blocksMoved <= houseDepth; blocksMoved += torchDepthOffset) {
            if (!world.func_175623_d(itemPosition = itemPosition.func_177967_a(facing.func_176734_d(), torchDepthOffset)) || !world.isSideSolid(itemPosition.func_177972_a(facing.func_176735_f()), facing.func_176746_e())) continue;
            BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        }
        itemPosition = NorthWestCorner.func_177972_a(facing.func_176735_f());
        blockState = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing.func_176735_f());
        BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        for (blocksMoved = torchDepthOffset; blocksMoved <= houseDepth; blocksMoved += torchDepthOffset) {
            if (!world.func_175623_d(itemPosition = itemPosition.func_177967_a(facing.func_176734_d(), torchDepthOffset)) || !world.isSideSolid(itemPosition.func_177972_a(facing.func_176746_e()), facing.func_176735_f())) continue;
            BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        }
        itemPosition = SouthEastCorner.func_177972_a(facing.func_176734_d());
        blockState = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing.func_176734_d());
        BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        for (blocksMoved = torchDepthOffset; blocksMoved <= houseWidth; blocksMoved += torchDepthOffset) {
            if (!world.func_175623_d(itemPosition = itemPosition.func_177967_a(facing.func_176735_f(), torchDepthOffset)) || !world.isSideSolid(itemPosition.func_177972_a(facing), facing.func_176734_d())) continue;
            BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        }
        if (configuration.isCeilingFlat) {
            cornerPosition = cornerPosition.func_177981_b(4);
            blockState = Blocks.field_150478_aa.func_176203_a(BuildingMethods.GetTorchFacing(EnumFacing.UP));
            for (int i = 0; i <= houseDepth; i += torchDepthOffset) {
                itemPosition = cornerPosition.func_177967_a(facing.func_176734_d(), i);
                for (int j = 0; j <= houseWidth; j += torchWidthOffset) {
                    if (world.func_175623_d(itemPosition) && !world.func_175623_d(itemPosition.func_177977_b())) {
                        BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
                    }
                    itemPosition = itemPosition.func_177967_a(facing.func_176735_f(), torchWidthOffset);
                }
            }
        }
    }

    private static void PlaceSmallFarm(World world, BlockPos cornerPosition, EnumFacing facing) {
        BlockPos farmStart = cornerPosition.func_177967_a(facing, 4).func_177967_a(facing.func_176735_f(), 5);
        IBlockState state = world.func_180495_p(farmStart);
        farmStart = farmStart.func_177977_b();
        boolean setWaterToCobbleStone = world.field_73011_w.func_186058_p() == DimensionType.NETHER || world.field_73011_w.func_186058_p() == DimensionType.THE_END;
        Block waterBlock = setWaterToCobbleStone ? Blocks.field_150347_e : Blocks.field_150355_j;
        BuildingMethods.ReplaceBlock(world, farmStart, waterBlock);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177977_b(), Blocks.field_150346_d);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177984_a(), Blocks.field_150359_w);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177981_b(2), Blocks.field_150478_aa);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing), Blocks.field_150458_ak);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing).func_177972_a(facing.func_176735_f()), Blocks.field_150458_ak);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing.func_176735_f()), Blocks.field_150458_ak);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing.func_176734_d()), Blocks.field_150458_ak);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing.func_176734_d()).func_177972_a(facing.func_176735_f()), Blocks.field_150458_ak);
        farmStart = farmStart.func_177972_a(facing.func_176746_e());
        BuildingMethods.ReplaceBlock(world, farmStart, waterBlock);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177977_b(), Blocks.field_150346_d);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177984_a(), Blocks.field_150359_w);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177981_b(2), Blocks.field_150478_aa);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing), Blocks.field_150458_ak);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing.func_176734_d()), Blocks.field_150458_ak);
        farmStart = farmStart.func_177972_a(facing.func_176746_e());
        BuildingMethods.ReplaceBlock(world, farmStart, waterBlock);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177977_b(), Blocks.field_150346_d);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177984_a(), Blocks.field_150359_w);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177981_b(2), Blocks.field_150478_aa);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing), Blocks.field_150458_ak);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing).func_177972_a(facing.func_176746_e()), Blocks.field_150458_ak);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing.func_176746_e()), Blocks.field_150458_ak);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing.func_176734_d()), Blocks.field_150458_ak);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing.func_176734_d()).func_177972_a(facing.func_176746_e()), Blocks.field_150458_ak);
    }

    private static void PlaceMineShaft(World world, BlockPos pos, int houseDepth, EnumFacing facing) {
        houseDepth = (houseDepth & 1) != 0 ? (int)Math.floor(houseDepth / 2) : (int)Math.floor(houseDepth / 2) - 1;
        pos = pos.func_177967_a(facing.func_176734_d(), houseDepth).func_177977_b();
        StructureAlternateStart.PlaceMineShaft(world, pos, facing, false);
    }

    static {
        addTorchesTag = "addTorches";
        addBedTag = "addBed";
        addCraftingTableTag = "addCraftingTable";
        addFurnaceTag = "addFurnace";
        addChestTag = "addChest";
        addChestContentsTag = "addChestContents";
        addFarmTag = "addFarm";
        floorBlockTag = "floorBlock";
        ceilingBlockTag = "ceilingBlock";
        wallWoodTypeTag = "wallWoodType";
        isCeilingFlatTag = "isCeilingFlat";
        addMineShaftTag = "addMineShaft";
        hitXTag = "hitX";
        hitYTag = "hitY";
        hitZTag = "hitZ";
        houseWidthTag = "houseWidth";
        houseDepthTag = "houseDepth";
        houseFacingTag = "houseFacing";
        houseStyleTag = "houseStyle";
        glassColorTag = "glassColor";
    }

    public static enum HouseStyle {
        BASIC(0, "prefab.gui.starter.basic.display", new ResourceLocation("prefab", "textures/gui/basic_house.png"), "prefab.gui.starter.basic.notes", 153, 148, ""),
        RANCH(1, "prefab.gui.starter.ranch.display", new ResourceLocation("prefab", "textures/gui/ranch_house.png"), "prefab.gui.starter.ranch.notes", 152, 89, "assets/prefab/structures/ranch_house.zip"),
        LOFT(2, "prefab.gui.starter.loft.display", new ResourceLocation("prefab", "textures/gui/loft_house.png"), "prefab.gui.starter.loft.notes", 152, 87, "assets/prefab/structures/loft_house.zip"),
        HOBBIT(3, "prefab.gui.starter.hobbit.display", new ResourceLocation("prefab", "textures/gui/hobbit_house.png"), "prefab.gui.starter.hobbit.notes", 151, 133, "assets/prefab/structures/hobbit_house.zip"),
        DESERT(4, "prefab.gui.starter.desert.display", new ResourceLocation("prefab", "textures/gui/desert_house.png"), "prefab.gui.starter.desert.notes", 152, 131, "assets/prefab/structures/desert_house.zip"),
        SNOWY(5, "prefab.gui.starter.snowy.display", new ResourceLocation("prefab", "textures/gui/snowy_house.png"), "prefab.gui.starter.snowy.notes", 150, 125, "assets/prefab/structures/snowy_house.zip");

        private final int value;
        private final String displayName;
        private final ResourceLocation housePicture;
        private final String houseNotes;
        private final int imageWidth;
        private final int imageHeight;
        private final String structureLocation;

        private HouseStyle(int newValue, String displayName, ResourceLocation housePicture, String houseNotes, int imageWidth, int imageHeight, String structureLocation) {
            this.value = newValue;
            this.displayName = displayName;
            this.housePicture = housePicture;
            this.houseNotes = houseNotes;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.structureLocation = structureLocation;
        }

        public int getValue() {
            return this.value;
        }

        public String getDisplayName() {
            return GuiLangKeys.translateString(this.displayName);
        }

        public String getHouseNotes() {
            return GuiLangKeys.translateString(this.houseNotes);
        }

        public ResourceLocation getHousePicture() {
            return this.housePicture;
        }

        public int getImageWidth() {
            return this.imageWidth;
        }

        public int getImageHeight() {
            return this.imageHeight;
        }

        public String getStructureLocation() {
            return this.structureLocation;
        }

        public static HouseStyle ValueOf(int value) {
            switch (value) {
                case 0: {
                    return BASIC;
                }
                case 1: {
                    return RANCH;
                }
                case 2: {
                    return LOFT;
                }
                case 3: {
                    return HOBBIT;
                }
                case 4: {
                    return DESERT;
                }
                case 5: {
                    return SNOWY;
                }
            }
            return BASIC;
        }
    }
}

