/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Config;

import com.wuest.prefab.Structures.Base.EnumStructureMaterial;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import com.wuest.prefab.Structures.Items.ItemInstantBridge;
import com.wuest.prefab.Structures.Predefined.StructureInstantBridge;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class InstantBridgeConfiguration
extends StructureConfiguration {
    public int bridgeLength;
    public EnumStructureMaterial bridgeMaterial;
    public boolean includeRoof;
    public int interiorHeight;

    @Override
    public void Initialize() {
        super.Initialize();
        this.bridgeLength = 25;
        this.bridgeMaterial = EnumStructureMaterial.Cobblestone;
        this.interiorHeight = 3;
        this.includeRoof = true;
    }

    @Override
    public InstantBridgeConfiguration ReadFromNBTTagCompound(NBTTagCompound messageTag) {
        InstantBridgeConfiguration config = new InstantBridgeConfiguration();
        return (InstantBridgeConfiguration)super.ReadFromNBTTagCompound(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(EntityPlayer player, World world, BlockPos hitBlockPos) {
        StructureInstantBridge structure = StructureInstantBridge.CreateInstance();
        if (structure.BuildStructure(this, world, hitBlockPos, EnumFacing.NORTH, player)) {
            ItemStack usedItemStack = player.func_184614_ca();
            if (!(usedItemStack.func_77973_b() instanceof ItemInstantBridge)) {
                usedItemStack = player.func_184592_cb();
            }
            usedItemStack.func_77972_a(1, (EntityLivingBase)player);
            player.field_71069_bz.func_75142_b();
        }
    }

    @Override
    protected NBTTagCompound CustomWriteToNBTTagCompound(NBTTagCompound tag) {
        tag.func_74768_a("bridgeLength", this.bridgeLength);
        tag.func_74768_a("bridgeMaterial", this.bridgeMaterial.getNumber());
        tag.func_74757_a("includeRoof", this.includeRoof);
        tag.func_74768_a("interiorHeight", this.interiorHeight);
        return tag;
    }

    @Override
    protected void CustomReadFromNBTTag(NBTTagCompound messageTag, StructureConfiguration config) {
        if (messageTag.func_74764_b("bridgeLength")) {
            ((InstantBridgeConfiguration)config).bridgeLength = messageTag.func_74762_e("bridgeLength");
        }
        if (messageTag.func_74764_b("bridgeMaterial")) {
            ((InstantBridgeConfiguration)config).bridgeMaterial = EnumStructureMaterial.getMaterialByNumber(messageTag.func_74762_e("bridgeMaterial"));
        }
        if (messageTag.func_74764_b("includeRoof")) {
            ((InstantBridgeConfiguration)config).includeRoof = messageTag.func_74767_n("includeRoof");
        }
        if (messageTag.func_74764_b("interiorHeight")) {
            ((InstantBridgeConfiguration)config).interiorHeight = messageTag.func_74762_e("interiorHeight");
        }
    }
}

