/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Config;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import com.wuest.prefab.Structures.Predefined.StructureWarehouse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WareHouseConfiguration
extends StructureConfiguration {
    private static String dyeColorTag = "dyeColor";
    private static String advancedTag = "advanced";
    public EnumDyeColor dyeColor;
    public boolean advanced;

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseFacing = EnumFacing.SOUTH;
        this.dyeColor = EnumDyeColor.CYAN;
        this.advanced = false;
    }

    @Override
    protected void CustomReadFromNBTTag(NBTTagCompound messageTag, StructureConfiguration config) {
        if (messageTag.func_74764_b(dyeColorTag)) {
            ((WareHouseConfiguration)config).dyeColor = EnumDyeColor.func_176764_b((int)messageTag.func_74762_e(dyeColorTag));
        }
        if (messageTag.func_74764_b(advancedTag)) {
            ((WareHouseConfiguration)config).advanced = messageTag.func_74767_n(advancedTag);
        }
    }

    @Override
    public WareHouseConfiguration ReadFromNBTTagCompound(NBTTagCompound messageTag) {
        WareHouseConfiguration config = new WareHouseConfiguration();
        return (WareHouseConfiguration)super.ReadFromNBTTagCompound(messageTag, config);
    }

    @Override
    protected NBTTagCompound CustomWriteToNBTTagCompound(NBTTagCompound tag) {
        tag.func_74768_a(dyeColorTag, this.dyeColor.func_176765_a());
        tag.func_74757_a(advancedTag, this.advanced);
        return tag;
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(EntityPlayer player, World world, BlockPos hitBlockPos) {
        String assetLocation = this.advanced ? "assets/prefab/structures/advanced_warehouse.zip" : "assets/prefab/structures/warehouse.zip";
        StructureWarehouse structure = (StructureWarehouse)StructureWarehouse.CreateInstance(assetLocation, StructureWarehouse.class);
        if (structure.BuildStructure(this, world, hitBlockPos, EnumFacing.NORTH, player)) {
            if (this.advanced) {
                player.field_71071_by.func_174925_a((Item)ModRegistry.AdvancedWareHouse(), -1, 1, null);
            } else {
                player.field_71071_by.func_174925_a((Item)ModRegistry.WareHouse(), -1, 1, null);
            }
            player.field_71069_bz.func_75142_b();
        }
    }
}

