/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.Controls.GuiCheckBox;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Proxy.CommonProxy;
import com.wuest.prefab.Structures.Base.EnumStructureMaterial;
import com.wuest.prefab.Structures.Config.InstantBridgeConfiguration;
import com.wuest.prefab.Structures.Gui.GuiStructure;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructureInstantBridge;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiSlider;

public class GuiInstantBridge
extends GuiStructure {
    private static final ResourceLocation structureTopDown = new ResourceLocation("prefab", "textures/gui/instant_bridge_top_down.png");
    protected InstantBridgeConfiguration configuration;
    protected GuiButtonExt btnMaterialType;
    protected GuiSlider sldrBridgeLength;
    protected GuiCheckBox chckIncludeRoof;
    protected GuiSlider sldrInteriorHeight;

    public GuiInstantBridge(int x, int y, int z) {
        super(x, y, z, true);
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.InstantBridge;
    }

    @Override
    protected void Initialize() {
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("InstantBridge", InstantBridgeConfiguration.class);
        this.configuration.pos = this.pos;
        int grayBoxX = this.getCenteredXAxis() - 213;
        int grayBoxY = this.getCenteredYAxis() - 83;
        this.btnMaterialType = new GuiButtonExt(3, grayBoxX + 10, grayBoxY + 20, 90, 20, this.configuration.bridgeMaterial.getTranslatedName());
        this.field_146292_n.add(this.btnMaterialType);
        this.sldrBridgeLength = new GuiSlider(5, grayBoxX + 147, grayBoxY + 20, 90, 20, "", "", 25.0, 75.0, (double)this.configuration.bridgeLength, false, true);
        this.field_146292_n.add(this.sldrBridgeLength);
        this.chckIncludeRoof = new GuiCheckBox(6, grayBoxX + 147, grayBoxY + 55, GuiLangKeys.translateString("prefab.gui.bridge_include_roof"), this.configuration.includeRoof);
        this.field_146292_n.add(this.chckIncludeRoof);
        this.sldrInteriorHeight = new GuiSlider(7, grayBoxX + 147, grayBoxY + 90, 90, 20, "", "", 3.0, 8.0, (double)this.configuration.interiorHeight, false, true);
        this.field_146292_n.add(this.sldrInteriorHeight);
        this.sldrInteriorHeight.field_146124_l = this.chckIncludeRoof.isChecked();
        this.btnVisualize = new GuiButtonExt(4, grayBoxX + 10, grayBoxY + 90, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.field_146292_n.add(this.btnVisualize);
        this.btnBuild = new GuiButtonExt(1, grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.field_146292_n.add(this.btnBuild);
        this.btnCancel = new GuiButtonExt(2, grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
        this.field_146292_n.add(this.btnCancel);
    }

    public void func_73863_a(int x, int y, float f) {
        int grayBoxX = this.getCenteredXAxis() - 210;
        int grayBoxY = this.getCenteredYAxis() - 83;
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(structureTopDown);
        this.drawModalRectWithCustomSizedTexture(grayBoxX + 250, grayBoxY, 1, 165, 58, 165.0f, 58.0f);
        this.drawControlBackgroundAndButtonsAndLabels(grayBoxX, grayBoxY, x, y);
        this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.bridge_material"), grayBoxX + 10, grayBoxY + 10, this.textColor);
        this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.bridge_interior_height"), grayBoxX + 147, grayBoxY + 80, this.textColor);
        this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.bridge_length"), grayBoxX + 147, grayBoxY + 10, this.textColor);
        if (!CommonProxy.proxyConfiguration.enableStructurePreview) {
            this.btnVisualize.field_146124_l = false;
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        int sliderValue = this.sldrBridgeLength.getValueInt();
        if (sliderValue > 75) {
            sliderValue = 75;
        } else if (sliderValue < 25) {
            sliderValue = 25;
        }
        this.configuration.bridgeLength = sliderValue;
        sliderValue = this.sldrInteriorHeight.getValueInt();
        if (sliderValue > 8) {
            sliderValue = 8;
        } else if (sliderValue < 3) {
            sliderValue = 3;
        }
        this.configuration.interiorHeight = sliderValue;
        this.configuration.houseFacing = this.player.func_174811_aO().func_176734_d();
        this.configuration.pos = this.pos;
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.chckIncludeRoof) {
            this.sldrInteriorHeight.field_146124_l = this.configuration.includeRoof = this.chckIncludeRoof.isChecked();
        }
        if (button == this.btnMaterialType) {
            this.configuration.bridgeMaterial = EnumStructureMaterial.getMaterialByNumber(this.configuration.bridgeMaterial.getNumber() + 1);
            this.btnMaterialType.field_146126_j = this.configuration.bridgeMaterial.getTranslatedName();
        } else if (button == this.btnVisualize) {
            StructureInstantBridge structure = new StructureInstantBridge();
            structure.getClearSpace().getShape().setDirection(EnumFacing.SOUTH);
            structure.setupStructure(this.configuration, this.pos);
            StructureRenderHandler.setStructure(structure, EnumFacing.SOUTH, this.configuration);
            this.field_146297_k.func_147108_a(null);
        }
    }
}

