/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.wuest.prefab.Config.ModConfiguration;
import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.Controls.GuiCheckBox;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Gui.GuiTabScreen;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Proxy.ClientProxy;
import com.wuest.prefab.Proxy.CommonProxy;
import com.wuest.prefab.Structures.Config.ModerateHouseConfiguration;
import com.wuest.prefab.Structures.Gui.GuiStructure;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructureModerateHouse;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class GuiModerateHouse
extends GuiStructure {
    protected ModerateHouseConfiguration configuration;
    protected GuiButtonExt btnHouseStyle;
    protected GuiCheckBox btnAddChest;
    protected GuiCheckBox btnAddChestContents;
    protected GuiCheckBox btnAddMineShaft;
    protected boolean allowItemsInChestAndFurnace = true;
    protected ModConfiguration serverConfiguration;

    public GuiModerateHouse(int x, int y, int z) {
        super(x, y, z, true);
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.ModerateHouse;
        if (!Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
            this.allowItemsInChestAndFurnace = !ClientEventHandler.playerConfig.builtStarterHouse;
        }
    }

    @Override
    protected void Initialize() {
        this.serverConfiguration = ((ClientProxy)Prefab.proxy).getServerConfiguration();
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("Moderate Houses", ModerateHouseConfiguration.class);
        this.configuration.pos = this.pos;
        int color = Color.DARK_GRAY.getRGB();
        int grayBoxX = this.getCenteredXAxis() - 212;
        int grayBoxY = this.getCenteredYAxis() - 83;
        this.btnHouseStyle = new GuiButtonExt(4, grayBoxX + 10, grayBoxY + 20, 90, 20, this.configuration.houseStyle.getDisplayName());
        this.field_146292_n.add(this.btnHouseStyle);
        this.btnVisualize = new GuiButtonExt(4, grayBoxX + 10, grayBoxY + 60, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.field_146292_n.add(this.btnVisualize);
        this.btnBuild = new GuiButtonExt(1, grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.field_146292_n.add(this.btnBuild);
        this.btnCancel = new GuiButtonExt(2, grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
        this.field_146292_n.add(this.btnCancel);
        int x = grayBoxX + 130;
        int y = grayBoxY + 10;
        this.btnAddChest = new GuiCheckBox(6, x, y, GuiLangKeys.translateString("prefab.gui.starter.addchest"), this.configuration.addChests);
        this.btnAddChest.setStringColor(color);
        this.btnAddChest.setWithShadow(false);
        this.field_146292_n.add(this.btnAddChest);
        this.btnAddMineShaft = new GuiCheckBox(7, x, y += 15, GuiLangKeys.translateString("prefab.gui.starter.buildmineshaft"), this.configuration.addChestContents);
        this.btnAddMineShaft.setStringColor(color);
        this.btnAddMineShaft.setWithShadow(false);
        this.field_146292_n.add(this.btnAddMineShaft);
        this.btnAddChestContents = new GuiCheckBox(8, x, y += 15, GuiLangKeys.translateString("prefab.gui.starter.addchestcontents"), this.configuration.addMineshaft);
        this.btnAddChestContents.setStringColor(color);
        this.btnAddChestContents.setWithShadow(false);
        this.field_146292_n.add(this.btnAddChestContents);
    }

    public void func_73863_a(int x, int y, float f) {
        int grayBoxX = this.getCenteredXAxis() - 212;
        int grayBoxY = this.getCenteredYAxis() - 83;
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(this.configuration.houseStyle.getHousePicture());
        GuiTabScreen.drawModalRectWithCustomSizedTexture(grayBoxX + 249, grayBoxY, 1, this.configuration.houseStyle.getImageWidth(), this.configuration.houseStyle.getImageHeight(), this.configuration.houseStyle.getImageWidth(), this.configuration.houseStyle.getImageHeight());
        this.drawControlBackgroundAndButtonsAndLabels(grayBoxX, grayBoxY, x, y);
        this.btnAddChest.field_146125_m = this.serverConfiguration.addChests;
        this.btnAddChestContents.field_146125_m = this.allowItemsInChestAndFurnace && this.serverConfiguration.addChestContents;
        this.btnAddMineShaft.field_146125_m = this.serverConfiguration.addMineshaft;
        this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.starter.style.label"), grayBoxX + 10, grayBoxY + 10, this.textColor);
        if (!CommonProxy.proxyConfiguration.enableStructurePreview) {
            this.btnVisualize.field_146124_l = false;
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        boolean bl = this.configuration.addChests = this.btnAddChest.field_146125_m && this.btnAddChest.isChecked();
        this.configuration.addChestContents = this.allowItemsInChestAndFurnace ? this.btnAddChestContents.field_146125_m && this.btnAddChestContents.isChecked() : false;
        this.configuration.addMineshaft = this.btnAddMineShaft.field_146125_m && this.btnAddMineShaft.isChecked();
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnHouseStyle) {
            int id = this.configuration.houseStyle.getValue() + 1;
            this.configuration.houseStyle = ModerateHouseConfiguration.HouseStyle.ValueOf(id);
            this.btnHouseStyle.field_146126_j = this.configuration.houseStyle.getDisplayName();
        } else if (button == this.btnVisualize) {
            StructureModerateHouse structure = (StructureModerateHouse)StructureModerateHouse.CreateInstance(this.configuration.houseStyle.getStructureLocation(), StructureModerateHouse.class);
            StructureRenderHandler.setStructure(structure, EnumFacing.NORTH, this.configuration);
            this.field_146297_k.func_147108_a(null);
        }
    }
}

