/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Proxy.CommonProxy;
import com.wuest.prefab.Structures.Base.EnumStairsMaterial;
import com.wuest.prefab.Structures.Base.EnumStructureMaterial;
import com.wuest.prefab.Structures.Config.StructurePartConfiguration;
import com.wuest.prefab.Structures.Gui.GuiStructure;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructurePart;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiSlider;

public class GuiStructurePart
extends GuiStructure {
    protected StructurePartConfiguration configuration;
    protected GuiSlider sldrStairWidth;
    protected GuiSlider sldrStairHeight;
    protected GuiSlider sldrGeneralWidth;
    protected GuiSlider sldrGeneralHeight;
    protected GuiButtonExt btnPartStyle;
    protected GuiButtonExt btnMaterialType;
    protected GuiButtonExt btnStairsMaterialType;
    protected int modifiedInitialXAxis = 213;
    protected int modifiedInitialYAxis = 83;

    public GuiStructurePart(int x, int y, int z) {
        super(x, y, z, true);
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.Parts;
    }

    @Override
    protected void Initialize() {
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("Parts", StructurePartConfiguration.class);
        this.configuration.pos = this.pos;
        int color = Color.DARK_GRAY.getRGB();
        int grayBoxX = this.getCenteredXAxis() - this.modifiedInitialXAxis;
        int grayBoxY = this.getCenteredYAxis() - this.modifiedInitialYAxis;
        this.btnBuild = new GuiButtonExt(1, grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.field_146292_n.add(this.btnBuild);
        this.btnCancel = new GuiButtonExt(2, grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
        this.field_146292_n.add(this.btnCancel);
        this.btnVisualize = new GuiButtonExt(3, grayBoxX + 10, grayBoxY + 90, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.field_146292_n.add(this.btnVisualize);
        this.sldrStairHeight = new GuiSlider(4, grayBoxX + 147, grayBoxY + 100, 90, 20, "", "", 1.0, 9.0, (double)this.configuration.stairHeight, false, true);
        this.field_146292_n.add(this.sldrStairHeight);
        this.sldrStairWidth = new GuiSlider(5, grayBoxX + 147, grayBoxY + 60, 90, 20, "", "", 1.0, 9.0, (double)this.configuration.stairWidth, false, true);
        this.field_146292_n.add(this.sldrStairWidth);
        this.sldrGeneralHeight = new GuiSlider(6, grayBoxX + 147, grayBoxY + 100, 90, 20, "", "", 3.0, 9.0, (double)this.configuration.generalHeight, false, true);
        this.field_146292_n.add(this.sldrGeneralHeight);
        this.sldrGeneralWidth = new GuiSlider(7, grayBoxX + 147, grayBoxY + 60, 90, 20, "", "", 3.0, 9.0, (double)this.configuration.generalWidth, false, true);
        this.field_146292_n.add(this.sldrGeneralWidth);
        this.btnPartStyle = new GuiButtonExt(8, grayBoxX + 10, grayBoxY + 20, 90, 20, GuiLangKeys.translateString(this.configuration.style.translateKey));
        this.field_146292_n.add(this.btnPartStyle);
        this.btnMaterialType = new GuiButtonExt(9, grayBoxX + 147, grayBoxY + 20, 90, 20, this.configuration.partMaterial.getTranslatedName());
        this.field_146292_n.add(this.btnMaterialType);
        this.btnStairsMaterialType = new GuiButtonExt(10, grayBoxX + 147, grayBoxY + 20, 90, 20, this.configuration.stairsMaterial.getTranslatedName());
        this.field_146292_n.add(this.btnStairsMaterialType);
    }

    public void func_73863_a(int x, int y, float f) {
        int grayBoxX = this.getCenteredXAxis() - this.modifiedInitialXAxis;
        int grayBoxY = this.getCenteredYAxis() - this.modifiedInitialYAxis;
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(this.configuration.style.getPictureLocation());
        this.drawModalRectWithCustomSizedTexture(grayBoxX + 250, grayBoxY, 1, this.configuration.style.imageWidth, this.configuration.style.imageHeight, this.configuration.style.imageWidth, this.configuration.style.imageHeight);
        this.drawControlBackgroundAndButtonsAndLabels(grayBoxX, grayBoxY, x, y);
        this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.style"), grayBoxX + 10, grayBoxY + 10, this.textColor);
        this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.material"), grayBoxX + 147, grayBoxY + 10, this.textColor);
        if (this.configuration.style == StructurePartConfiguration.EnumStyle.Stairs || this.configuration.style == StructurePartConfiguration.EnumStyle.Roof) {
            this.sldrStairHeight.field_146125_m = this.configuration.style != StructurePartConfiguration.EnumStyle.Roof;
            this.sldrStairWidth.field_146125_m = true;
            this.sldrGeneralHeight.field_146125_m = false;
            this.sldrGeneralWidth.field_146125_m = false;
            this.btnStairsMaterialType.field_146125_m = true;
            this.btnMaterialType.field_146125_m = false;
        } else {
            this.btnStairsMaterialType.field_146125_m = false;
            this.btnMaterialType.field_146125_m = true;
            this.sldrStairHeight.field_146125_m = false;
            this.sldrStairWidth.field_146125_m = false;
            this.sldrGeneralHeight.field_146125_m = true;
            this.sldrGeneralWidth.field_146125_m = true;
        }
        if (this.configuration.style != StructurePartConfiguration.EnumStyle.Roof) {
            if (this.configuration.style == StructurePartConfiguration.EnumStyle.Floor) {
                this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.length"), grayBoxX + 147, grayBoxY + 90, this.textColor);
            } else {
                this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.height"), grayBoxX + 147, grayBoxY + 90, this.textColor);
            }
        }
        if (this.configuration.style == StructurePartConfiguration.EnumStyle.Roof) {
            this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.height"), grayBoxX + 147, grayBoxY + 50, this.textColor);
        } else {
            this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.width"), grayBoxX + 147, grayBoxY + 50, this.textColor);
        }
        if (!CommonProxy.proxyConfiguration.enableStructurePreview) {
            this.btnVisualize.field_146124_l = false;
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        this.configuration.houseFacing = Minecraft.func_71410_x().field_71439_g.func_174811_aO().func_176734_d();
        this.configuration.stairHeight = this.sldrStairHeight.getValueInt();
        this.configuration.stairWidth = this.sldrStairWidth.getValueInt();
        this.configuration.generalHeight = this.sldrGeneralHeight.getValueInt();
        this.configuration.generalWidth = this.sldrGeneralWidth.getValueInt();
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnMaterialType) {
            this.configuration.partMaterial = EnumStructureMaterial.getMaterialByNumber(this.configuration.partMaterial.getNumber() + 1);
            this.btnMaterialType.field_146126_j = this.configuration.partMaterial.getTranslatedName();
        }
        if (button == this.btnStairsMaterialType) {
            this.configuration.stairsMaterial = EnumStairsMaterial.getByOrdinal(this.configuration.stairsMaterial.ordinal() + 1);
            this.btnStairsMaterialType.field_146126_j = this.configuration.stairsMaterial.getTranslatedName();
        } else if (button == this.btnPartStyle) {
            this.configuration.style = StructurePartConfiguration.EnumStyle.getByOrdinal(this.configuration.style.ordinal() + 1);
            this.btnPartStyle.field_146126_j = GuiLangKeys.translateString(this.configuration.style.translateKey);
        } else if (button == this.btnVisualize) {
            StructurePart structure = new StructurePart();
            structure.getClearSpace().getShape().setDirection(EnumFacing.NORTH);
            structure.setupStructure((World)this.field_146297_k.field_71441_e, this.configuration, this.pos);
            StructureRenderHandler.setStructure(structure, EnumFacing.SOUTH, this.configuration);
            this.field_146297_k.func_147108_a(null);
        }
    }
}

