/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Predefined;

import com.wuest.prefab.Config.EntityPlayerConfiguration;
import com.wuest.prefab.Proxy.CommonProxy;
import com.wuest.prefab.Structures.Base.BuildBlock;
import com.wuest.prefab.Structures.Base.BuildClear;
import com.wuest.prefab.Structures.Base.Structure;
import com.wuest.prefab.Structures.Config.ModerateHouseConfiguration;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import com.wuest.prefab.Structures.Predefined.StructureAlternateStart;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StructureModerateHouse
extends Structure {
    private BlockPos chestPosition = null;
    private ArrayList<BlockPos> furnacePosition = null;
    private BlockPos trapDoorPosition = null;
    private static ArrayList<BlockPos> torchPositions = null;

    public static void ScanStructure(World world, BlockPos originalPos, EnumFacing playerFacing, ModerateHouseConfiguration.HouseStyle houseStyle) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(EnumFacing.SOUTH);
        clearedSpace.getShape().setHeight(houseStyle.getHeight());
        clearedSpace.getShape().setLength(houseStyle.getLength());
        clearedSpace.getShape().setWidth(houseStyle.getWidth());
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(houseStyle.getEastOffSet());
        clearedSpace.getStartingPosition().setHeightOffset(houseStyle.getDownOffSet() * -1);
        BlockPos cornerPos = originalPos.func_177965_g(houseStyle.getEastOffSet()).func_177968_d().func_177979_c(houseStyle.getDownOffSet());
        Structure.ScanStructure(world, originalPos, cornerPos, cornerPos.func_177970_e(houseStyle.getLength()).func_177985_f(houseStyle.getWidth()).func_177981_b(houseStyle.getHeight()), "../src/main/resources/" + houseStyle.getStructureLocation(), clearedSpace, playerFacing, false, false);
    }

    @Override
    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, World world, BlockPos originalPos, EnumFacing assumedNorth, Block foundBlock, IBlockState blockState, EntityPlayer player) {
        if (foundBlock instanceof BlockFurnace) {
            if (this.furnacePosition == null) {
                this.furnacePosition = new ArrayList();
            }
            this.furnacePosition.add(block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing));
        } else {
            if (foundBlock instanceof BlockChest && !((ModerateHouseConfiguration)configuration).addChests) {
                return true;
            }
            if (foundBlock instanceof BlockChest && this.chestPosition == null) {
                this.chestPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            } else if (foundBlock instanceof BlockTrapDoor) {
                this.trapDoorPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            }
        }
        return false;
    }

    @Override
    public void AfterBuilding(StructureConfiguration configuration, World world, BlockPos originalPos, EnumFacing assumedNorth, EntityPlayer player) {
        ModerateHouseConfiguration houseConfig = (ModerateHouseConfiguration)configuration;
        EntityPlayerConfiguration playerConfig = EntityPlayerConfiguration.loadFromEntityData((EntityPlayer)((EntityPlayerMP)player));
        if (this.furnacePosition != null) {
            for (BlockPos furnacePos : this.furnacePosition) {
                TileEntity tileEntity = world.func_175625_s(furnacePos);
                if (!(tileEntity instanceof TileEntityFurnace)) continue;
                TileEntityFurnace furnaceTile = (TileEntityFurnace)tileEntity;
                furnaceTile.func_70299_a(1, new ItemStack(Items.field_151044_h, 20));
            }
        }
        if (this.chestPosition != null && !playerConfig.builtStarterHouse && houseConfig.addChestContents) {
            StructureModerateHouse.FillChest(world, this.chestPosition, houseConfig, player);
        }
        if (this.trapDoorPosition != null && this.trapDoorPosition.func_177956_o() > 15 && houseConfig.addMineshaft) {
            StructureAlternateStart.PlaceMineShaft(world, this.trapDoorPosition.func_177977_b(), houseConfig.houseFacing, false);
        }
        playerConfig.builtStarterHouse = true;
        playerConfig.saveToPlayer(player);
    }

    public static void FillChest(World world, BlockPos itemPosition, ModerateHouseConfiguration configuration, EntityPlayer player) {
        TileEntity tileEntity = world.func_175625_s(itemPosition);
        if (tileEntity instanceof TileEntityChest) {
            TileEntityChest chestTile = (TileEntityChest)tileEntity;
            int itemSlot = 0;
            if (CommonProxy.proxyConfiguration.addAxe) {
                chestTile.func_70299_a(itemSlot++, new ItemStack(Items.field_151049_t));
            }
            if (CommonProxy.proxyConfiguration.addHoe) {
                chestTile.func_70299_a(itemSlot++, new ItemStack(Items.field_151018_J));
            }
            if (CommonProxy.proxyConfiguration.addPickAxe) {
                chestTile.func_70299_a(itemSlot++, new ItemStack(Items.field_151050_s));
            }
            if (CommonProxy.proxyConfiguration.addShovel) {
                chestTile.func_70299_a(itemSlot++, new ItemStack(Items.field_151051_r));
            }
            if (CommonProxy.proxyConfiguration.addSword) {
                ResourceLocation name = new ResourceLocation("repurpose", "itemSwiftBladeStone");
                Item sword = (Item)Item.field_150901_e.func_82594_a((Object)name);
                if (sword == null) {
                    sword = Items.field_151052_q;
                }
                chestTile.func_70299_a(itemSlot++, new ItemStack(sword));
            }
            if (CommonProxy.proxyConfiguration.addArmor) {
                chestTile.func_70299_a(itemSlot++, new ItemStack((Item)Items.field_151021_T));
                chestTile.func_70299_a(itemSlot++, new ItemStack((Item)Items.field_151027_R));
                chestTile.func_70299_a(itemSlot++, new ItemStack((Item)Items.field_151024_Q));
                chestTile.func_70299_a(itemSlot++, new ItemStack((Item)Items.field_151026_S));
            }
            if (CommonProxy.proxyConfiguration.addFood) {
                chestTile.func_70299_a(itemSlot++, new ItemStack(Items.field_151025_P, 20));
            }
            if (CommonProxy.proxyConfiguration.addCrops) {
                chestTile.func_70299_a(itemSlot++, new ItemStack(Items.field_151174_bG, 3));
                chestTile.func_70299_a(itemSlot++, new ItemStack(Items.field_151172_bF, 3));
                chestTile.func_70299_a(itemSlot++, new ItemStack(Items.field_151014_N, 3));
            }
            if (CommonProxy.proxyConfiguration.addCobble) {
                chestTile.func_70299_a(itemSlot++, new ItemStack(Item.func_150898_a((Block)Blocks.field_150347_e), 64));
            }
            if (CommonProxy.proxyConfiguration.addDirt) {
                chestTile.func_70299_a(itemSlot++, new ItemStack(Item.func_150898_a((Block)Blocks.field_150346_d), 64));
            }
            if (CommonProxy.proxyConfiguration.addSaplings) {
                chestTile.func_70299_a(itemSlot++, new ItemStack(Item.func_150898_a((Block)Blocks.field_150345_g), 3));
            }
            if (CommonProxy.proxyConfiguration.addTorches) {
                chestTile.func_70299_a(itemSlot++, new ItemStack(Item.func_150898_a((Block)Blocks.field_150478_aa), 20));
            }
        }
    }
}

