/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.GlassBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SlabBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockGlassSlab
extends GlassBlock
implements IWaterLoggable {
    private static final VoxelShape BOTTOM_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape TOP_SHAPE = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public BlockGlassSlab(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_220074_n(BlockState state) {
        return state.func_177229_b((IProperty)SlabBlock.field_196505_a) != SlabType.DOUBLE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{SlabBlock.field_196505_a, WATERLOGGED});
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        Block adjacentBlock;
        Tag tags = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("forge", "glass"));
        return tags.func_199685_a_((Object)(adjacentBlock = adjacentBlockState.func_177230_c())) || adjacentBlock == this && (adjacentBlockState.func_177229_b((IProperty)SlabBlock.field_196505_a) == state.func_177229_b((IProperty)SlabBlock.field_196505_a) || adjacentBlockState.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.DOUBLE && state.func_177229_b((IProperty)SlabBlock.field_196505_a) != SlabType.DOUBLE);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        SlabType slabtype = (SlabType)state.func_177229_b((IProperty)SlabBlock.field_196505_a);
        switch (slabtype) {
            case DOUBLE: {
                return VoxelShapes.func_197868_b();
            }
            case TOP: {
                return TOP_SHAPE;
            }
        }
        return BOTTOM_SHAPE;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = context.func_195991_k().func_180495_p(blockpos);
        if (blockstate.func_177230_c() == this) {
            boolean wasWaterlogged = (Boolean)blockstate.func_177229_b((IProperty)WATERLOGGED);
            return (BlockState)((BlockState)blockstate.func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(wasWaterlogged));
        }
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(blockpos);
        BlockState blockstate1 = (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
        Direction direction = context.func_196000_l();
        return !(direction == Direction.DOWN || direction != Direction.UP && context.func_221532_j().field_72448_b - (double)blockpos.func_177956_o() > 0.5) ? blockstate1 : (BlockState)blockstate1.func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        ItemStack itemstack = useContext.func_195996_i();
        SlabType slabtype = (SlabType)state.func_177229_b((IProperty)SlabBlock.field_196505_a);
        if (slabtype != SlabType.DOUBLE && itemstack.func_77973_b() == this.func_199767_j()) {
            if (useContext.func_196012_c()) {
                boolean flag = useContext.func_221532_j().field_72448_b - (double)useContext.func_195995_a().func_177956_o() > 0.5;
                Direction direction = useContext.func_196000_l();
                if (slabtype == SlabType.BOTTOM) {
                    return direction == Direction.UP || flag && direction.func_176740_k().func_176722_c();
                }
                return direction == Direction.DOWN || !flag && direction.func_176740_k().func_176722_c();
            }
            return true;
        }
        return false;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, IFluidState fluidStateIn) {
        return state.func_177229_b((IProperty)SlabBlock.field_196505_a) != SlabType.DOUBLE && this.slabReceiveFluid(worldIn, pos, state, fluidStateIn);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return state.func_177229_b((IProperty)SlabBlock.field_196505_a) != SlabType.DOUBLE && this.slabCanContainFluid(worldIn, pos, state, fluidIn);
    }

    private boolean slabCanContainFluid(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y) == false && fluidIn == Fluids.field_204546_a;
    }

    private boolean slabReceiveFluid(IWorld worldIn, BlockPos pos, BlockState state, IFluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            if (!worldIn.func_201670_d()) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.TRUE), 3);
                worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a((IWorldReader)worldIn));
            }
            return true;
        }
        return false;
    }

    public Fluid func_204508_a(IWorld worldIn, BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue() && state.func_177229_b((IProperty)SlabBlock.field_196505_a) != SlabType.DOUBLE) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.FALSE), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        if (type == PathType.WATER) {
            return worldIn.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a);
        }
        return false;
    }
}

