/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Blocks;

import com.wuest.prefab.Events.ModEventHandler;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockPhasing
extends Block {
    private static final EnumProperty<EnumPhasingProgress> Phasing_Progress = EnumProperty.func_177709_a((String)"phasing_progress", EnumPhasingProgress.class);
    private static final BooleanProperty Phasing_Out = BooleanProperty.func_177716_a((String)"phasing_out");
    private int tickRate = 2;

    public BlockPhasing(String name) {
        super(Block.Properties.func_200945_a((Material)Prefab.SeeThroughImmovable).func_200947_a(SoundType.field_185851_d).func_200943_b(0.6f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)Phasing_Out, (Comparable)Boolean.valueOf(false))).func_206870_a(Phasing_Progress, (Comparable)((Object)EnumPhasingProgress.base)));
        ModRegistry.setBlockName(this, name);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{Phasing_Out, Phasing_Progress});
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTrace) {
        EnumPhasingProgress progress;
        if (!world.field_72995_K && (progress = (EnumPhasingProgress)((Object)state.func_177229_b(Phasing_Progress))) == EnumPhasingProgress.base) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, this.tickRate);
        }
        return true;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean poweredSide = context.func_195991_k().func_175640_z(context.func_195995_a());
        if (poweredSide) {
            this.updateNeighborPhasicBlocks(true, context.func_195991_k(), context.func_195995_a(), this.func_176223_P(), false, false);
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)Phasing_Out, (Comparable)Boolean.valueOf(poweredSide))).func_206870_a(Phasing_Progress, (Comparable)((Object)EnumPhasingProgress.base));
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        EnumPhasingProgress currentState = (EnumPhasingProgress)((Object)state.func_177229_b(Phasing_Progress));
        boolean returnValue = super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        ModEventHandler.RedstoneAffectedBlockPositions.remove(pos);
        boolean poweredSide = world.func_175640_z(pos);
        if (poweredSide && currentState == EnumPhasingProgress.transparent) {
            this.updateNeighborPhasicBlocks(false, world, pos, state, false, false);
        }
        return returnValue;
    }

    public int func_149738_a(IWorldReader worldIn) {
        return this.tickRate;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos p_189540_5_, boolean p_220069_6_) {
        if (!worldIn.field_72995_K && blockIn.func_176223_P().func_185897_m()) {
            boolean poweredSide = worldIn.func_175640_z(pos);
            EnumPhasingProgress currentState = (EnumPhasingProgress)((Object)state.func_177229_b(Phasing_Progress));
            boolean setToTransparent = false;
            if (poweredSide && currentState == EnumPhasingProgress.base) {
                setToTransparent = true;
            }
            if (currentState == EnumPhasingProgress.base || currentState == EnumPhasingProgress.transparent) {
                this.updateNeighborPhasicBlocks(setToTransparent, worldIn, pos, state, true, true);
            }
        }
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        int updatedMeta;
        int tickDelay = this.tickRate;
        if (ModEventHandler.RedstoneAffectedBlockPositions.contains(pos)) {
            return;
        }
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.func_177229_b(Phasing_Progress));
        boolean phasingOut = (Boolean)state.func_177229_b((IProperty)Phasing_Out);
        if (progress == EnumPhasingProgress.base) {
            for (Direction facing : Direction.values()) {
                Block currentBlock = worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
                if (!(currentBlock instanceof BlockPhasing) || ModEventHandler.RedstoneAffectedBlockPositions.contains(pos.func_177972_a(facing))) continue;
                worldIn.func_205220_G_().func_205360_a(pos.func_177972_a(facing), (Object)currentBlock, tickDelay);
            }
            phasingOut = true;
        }
        if ((updatedMeta = progress.getMeta()) == EnumPhasingProgress.eighty_percent.getMeta() && phasingOut) {
            tickDelay = 100;
        }
        if (updatedMeta == EnumPhasingProgress.transparent.getMeta() && phasingOut) {
            phasingOut = false;
        }
        if (updatedMeta == EnumPhasingProgress.twenty_percent.getMeta() && !phasingOut) {
            tickDelay = -1;
        }
        updatedMeta = phasingOut ? updatedMeta + 2 : updatedMeta - 2;
        progress = EnumPhasingProgress.ValueOf(updatedMeta);
        state = (BlockState)((BlockState)state.func_206870_a((IProperty)Phasing_Out, (Comparable)Boolean.valueOf(phasingOut))).func_206870_a(Phasing_Progress, (Comparable)((Object)progress));
        worldIn.func_175656_a(pos, state);
        if (worldIn.field_72995_K) {
            ClientWorld clientWorld = (ClientWorld)worldIn;
            clientWorld.func_217427_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        if (tickDelay > 0) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, tickDelay);
        }
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean canRenderInLayer(BlockState state, BlockRenderLayer layer) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.func_177229_b(Phasing_Progress));
        return layer == BlockRenderLayer.TRANSLUCENT && progress != EnumPhasingProgress.base || layer == BlockRenderLayer.SOLID && progress == EnumPhasingProgress.base;
    }

    public boolean func_200124_e(BlockState state) {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.func_177229_b(Phasing_Progress));
        return progress != EnumPhasingProgress.transparent ? BlockRenderType.MODEL : BlockRenderType.INVISIBLE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.func_177229_b(Phasing_Progress));
        return progress != EnumPhasingProgress.transparent ? VoxelShapes.func_197868_b() : VoxelShapes.func_197880_a();
    }

    @Nullable
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.func_177229_b(Phasing_Progress));
        if (progress == EnumPhasingProgress.transparent) {
            return VoxelShapes.func_197880_a();
        }
        return super.func_220071_b(state, worldIn, pos, context);
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.func_177229_b(Phasing_Progress));
        if (progress == EnumPhasingProgress.transparent) {
            return VoxelShapes.func_197880_a();
        }
        VoxelShape aabb = super.func_199600_g(state, worldIn, pos);
        return aabb;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.func_177229_b(Phasing_Progress));
        return progress == EnumPhasingProgress.transparent;
    }

    protected void updateNeighborPhasicBlocks(boolean setToTransparent, World worldIn, BlockPos pos, BlockState phasicBlockState, boolean setCurrentBlock, boolean triggeredByRedstone) {
        ArrayList<BlockPos> blocksToUpdate = new ArrayList<BlockPos>();
        BlockState updatedBlockState = (BlockState)((BlockState)phasicBlockState.func_206870_a((IProperty)Phasing_Out, (Comparable)Boolean.valueOf(setToTransparent))).func_206870_a(Phasing_Progress, (Comparable)((Object)(setToTransparent ? EnumPhasingProgress.transparent : EnumPhasingProgress.base)));
        this.findNeighborPhasicBlocks(worldIn, pos, updatedBlockState, 0, blocksToUpdate, setCurrentBlock);
        for (BlockPos positionToUpdate : blocksToUpdate) {
            worldIn.func_175656_a(positionToUpdate, updatedBlockState);
            if (!triggeredByRedstone) continue;
            if (ModEventHandler.RedstoneAffectedBlockPositions.contains(positionToUpdate) && !setToTransparent) {
                ModEventHandler.RedstoneAffectedBlockPositions.remove(positionToUpdate);
                continue;
            }
            if (ModEventHandler.RedstoneAffectedBlockPositions.contains(positionToUpdate) || !setToTransparent) continue;
            ModEventHandler.RedstoneAffectedBlockPositions.add(positionToUpdate);
        }
    }

    private int findNeighborPhasicBlocks(World worldIn, BlockPos pos, BlockState desiredBlockState, int cascadeCount, ArrayList<BlockPos> cascadedBlockPos, boolean setCurrentBlock) {
        if (++cascadeCount > 100) {
            return cascadeCount;
        }
        if (setCurrentBlock) {
            cascadedBlockPos.add(pos);
        }
        for (Direction facing : Direction.values()) {
            Block neighborBlock = worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
            if (!(neighborBlock instanceof BlockPhasing)) continue;
            BlockState blockState = worldIn.func_180495_p(pos.func_177972_a(facing));
            EnumPhasingProgress progress = (EnumPhasingProgress)((Object)blockState.func_177229_b(Phasing_Progress));
            if (cascadedBlockPos.contains(pos.func_177972_a(facing)) || progress == desiredBlockState.func_177229_b(Phasing_Progress)) continue;
            setCurrentBlock = true;
            cascadeCount = this.findNeighborPhasicBlocks(worldIn, pos.func_177972_a(facing), desiredBlockState, cascadeCount, cascadedBlockPos, setCurrentBlock);
            if (cascadeCount > 100) break;
        }
        return cascadeCount;
    }

    public static enum EnumPhasingProgress implements IStringSerializable
    {
        base(0, "base"),
        twenty_percent(2, "twenty_percent"),
        forty_percent(4, "forty_percent"),
        sixty_percent(6, "sixty_percent"),
        eighty_percent(8, "eighty_percent"),
        transparent(10, "transparent");

        private int meta;
        private String name;

        private EnumPhasingProgress(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public static EnumPhasingProgress ValueOf(int meta) {
            for (EnumPhasingProgress progress : EnumPhasingProgress.values()) {
                if (progress.meta != meta) continue;
                return progress;
            }
            return base;
        }

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

