/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Gui.Controls;

import com.wuest.prefab.Gui.Controls.GuiTabTray;
import com.wuest.prefab.Gui.GuiTabScreen;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;

public class GuiTab
extends Widget {
    protected static final ResourceLocation TAB_TEXTURES = new ResourceLocation("prefab", "textures/gui/gui_tab.png");
    protected static final ResourceLocation TAB_TEXTURES_hovered = new ResourceLocation("prefab", "textures/gui/gui_tab_hovered.png");
    private GuiTabTray parentTray;
    private boolean selected;
    private String name;

    public GuiTab(GuiTabTray parent, String name, int x, int y) {
        super(x, y, name);
        this.Initialize(parent, name);
    }

    protected void Initialize(GuiTabTray parent, String name) {
        this.parentTray = parent;
        this.selected = false;
        this.name = name;
        this.height = 20;
        this.width = 50;
        this.visible = true;
    }

    public GuiTabTray getParent() {
        return this.parentTray;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) throws Exception {
        if (this.parentTray.DoesTabNameExist(value)) {
            throw new Exception("A tab with the name of [" + value + "] already exists.");
        }
        this.name = value;
    }

    public boolean getIsSelected() {
        return this.selected;
    }

    public void setIsSelected(boolean value) {
        this.selected = value;
        this.parentTray.SetSelectedTab(this.selected ? this : null);
    }

    protected void InternalSetSelected(boolean value) {
        this.selected = value;
    }

    public void drawTab(Minecraft mc, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        FontRenderer fontrenderer = mc.field_71466_p;
        boolean bl = this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
        if (this.selected || this.isHovered) {
            mc.func_110434_K().func_110577_a(TAB_TEXTURES_hovered);
        } else {
            mc.func_110434_K().func_110577_a(TAB_TEXTURES);
        }
        GuiTabScreen.drawModalRectWithCustomSizedTexture(this.x, this.y, 0, this.width, this.height, this.width, this.height);
        int j = Color.LIGHT_GRAY.getRGB();
        int stringXPosition = this.x + this.width / 2 - fontrenderer.func_78256_a(this.name) / 2;
        fontrenderer.func_211126_b(this.name, (float)stringXPosition, (float)(this.y + (this.height - 8) / 2), j);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int buttonClicked) {
        boolean value;
        boolean bl = value = mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height) && this.isValidClickButton(buttonClicked);
        if (value && !this.selected) {
            this.setIsSelected(true);
        }
        return value;
    }

    public void playDownSound(SoundHandler soundHandlerIn) {
        soundHandlerIn.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }
}

