/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Gui;

import com.wuest.prefab.Tuple;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public abstract class GuiBase
extends Screen {
    private final ResourceLocation backgroundTextures = new ResourceLocation("prefab", "textures/gui/default_background.png");
    private boolean pauseGame = true;

    public GuiBase(String title) {
        super((ITextComponent)new StringTextComponent(title));
    }

    public void init() {
        this.Initialize();
    }

    protected void Initialize() {
    }

    protected int getCenteredXAxis() {
        return this.width / 2;
    }

    protected int getCenteredYAxis() {
        return this.height / 2;
    }

    public boolean isPauseScreen() {
        return this.pauseGame;
    }

    public void render(int x, int y, float f) {
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        this.preButtonRender(adjustedXYValue.getFirst(), adjustedXYValue.getSecond());
        this.renderButtons(x, y);
        this.postButtonRender(adjustedXYValue.getFirst(), adjustedXYValue.getSecond());
    }

    public GuiButtonExt createAndAddButton(int x, int y, int width, int height, String text) {
        GuiButtonExt returnValue = new GuiButtonExt(x, y, width, height, text, this::buttonClicked);
        this.addButton((Widget)returnValue);
        return returnValue;
    }

    protected void drawControlBackground(int grayBoxX, int grayBoxY) {
        this.getMinecraft().func_110434_K().func_110577_a(this.backgroundTextures);
        this.blit(grayBoxX, grayBoxY, 0, 0, 256, 256);
    }

    protected void renderButtons(int mouseX, int mouseY) {
        for (Widget button : this.buttons) {
            Button currentButton = (Button)button;
            if (currentButton == null || !currentButton.visible) continue;
            currentButton.renderButton(mouseX, mouseY, this.getMinecraft().func_184121_ak());
        }
    }

    public abstract void buttonClicked(Button var1);

    protected abstract Tuple<Integer, Integer> getAdjustedXYValue();

    protected abstract void preButtonRender(int var1, int var2);

    protected abstract void postButtonRender(int var1, int var2);
}

