/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Config;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import com.wuest.prefab.Structures.Items.ItemWareHouse;
import com.wuest.prefab.Structures.Predefined.StructureWarehouse;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class WareHouseConfiguration
extends StructureConfiguration {
    private static String dyeColorTag = "dyeColor";
    private static String advancedTag = "advanced";
    public DyeColor dyeColor;
    public boolean advanced;

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseFacing = Direction.SOUTH;
        this.dyeColor = DyeColor.CYAN;
        this.advanced = false;
    }

    @Override
    protected void CustomReadFromNBTTag(CompoundNBT messageTag, StructureConfiguration config) {
        if (messageTag.func_74764_b(dyeColorTag)) {
            ((WareHouseConfiguration)config).dyeColor = DyeColor.func_196056_a((int)messageTag.func_74762_e(dyeColorTag));
        }
        if (messageTag.func_74764_b(advancedTag)) {
            ((WareHouseConfiguration)config).advanced = messageTag.func_74767_n(advancedTag);
        }
    }

    @Override
    public WareHouseConfiguration ReadFromCompoundNBT(CompoundNBT messageTag) {
        WareHouseConfiguration config = new WareHouseConfiguration();
        return (WareHouseConfiguration)super.ReadFromCompoundNBT(messageTag, config);
    }

    @Override
    protected CompoundNBT CustomWriteToCompoundNBT(CompoundNBT tag) {
        tag.func_74768_a(dyeColorTag, this.dyeColor.func_196059_a());
        tag.func_74757_a(advancedTag, this.advanced);
        return tag;
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(PlayerEntity player, ServerWorld world, BlockPos hitBlockPos) {
        String assetLocation = this.advanced ? "assets/prefab/structures/advanced_warehouse.zip" : "assets/prefab/structures/warehouse.zip";
        StructureWarehouse structure = (StructureWarehouse)StructureWarehouse.CreateInstance(assetLocation, StructureWarehouse.class);
        if (structure.BuildStructure(this, world, hitBlockPos, Direction.NORTH, player)) {
            ItemWareHouse structureItem = this.advanced ? ModRegistry.AdvancedWareHouse() : ModRegistry.WareHouse();
            this.RemoveStructureItemFromPlayer(player, structureItem);
        }
    }
}

