/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.Controls.GuiCheckBox;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Structures.Base.EnumStructureMaterial;
import com.wuest.prefab.Structures.Config.InstantBridgeConfiguration;
import com.wuest.prefab.Structures.Gui.GuiStructure;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructureInstantBridge;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import com.wuest.prefab.Tuple;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiSlider;

public class GuiInstantBridge
extends GuiStructure {
    private static final ResourceLocation structureTopDown = new ResourceLocation("prefab", "textures/gui/instant_bridge_top_down.png");
    protected InstantBridgeConfiguration configuration;
    private GuiButtonExt btnMaterialType;
    private GuiSlider sldrBridgeLength;
    private GuiCheckBox chckIncludeRoof;
    private GuiSlider sldrInteriorHeight;

    public GuiInstantBridge() {
        super("Instant Bridge");
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.InstantBridge;
    }

    @Override
    protected void Initialize() {
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("InstantBridge", InstantBridgeConfiguration.class);
        this.configuration.pos = this.pos;
        int grayBoxX = this.getCenteredXAxis() - 213;
        int grayBoxY = this.getCenteredYAxis() - 83;
        this.btnMaterialType = this.createAndAddButton(grayBoxX + 10, grayBoxY + 20, 90, 20, this.configuration.bridgeMaterial.getTranslatedName());
        this.sldrBridgeLength = new GuiSlider(grayBoxX + 147, grayBoxY + 20, 90, 20, "", "", 25.0, 75.0, (double)this.configuration.bridgeLength, false, true, this::buttonClicked);
        this.addButton((Widget)this.sldrBridgeLength);
        this.chckIncludeRoof = new GuiCheckBox(grayBoxX + 147, grayBoxY + 55, GuiLangKeys.translateString("prefab.gui.bridge_include_roof"), this.configuration.includeRoof, this::buttonClicked);
        this.addButton((Widget)this.chckIncludeRoof);
        this.sldrInteriorHeight = new GuiSlider(grayBoxX + 147, grayBoxY + 90, 90, 20, "", "", 3.0, 8.0, (double)this.configuration.interiorHeight, false, true, this::buttonClicked);
        this.addButton((Widget)this.sldrInteriorHeight);
        this.sldrInteriorHeight.visible = this.chckIncludeRoof.isChecked();
        this.btnVisualize = this.createAndAddButton(grayBoxX + 10, grayBoxY + 90, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.btnBuild = this.createAndAddButton(grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.btnCancel = this.createAndAddButton(grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
    }

    @Override
    protected Tuple<Integer, Integer> getAdjustedXYValue() {
        return new Tuple<Integer, Integer>(this.getCenteredXAxis() - 210, this.getCenteredYAxis() - 83);
    }

    @Override
    protected void preButtonRender(int x, int y) {
        super.preButtonRender(x, y);
        this.minecraft.func_110434_K().func_110577_a(structureTopDown);
        GuiStructure.drawModalRectWithCustomSizedTexture(x + 250, y, 1, 165, 58, 165.0f, 58.0f);
    }

    @Override
    protected void postButtonRender(int x, int y) {
        this.minecraft.field_71466_p.func_211126_b(GuiLangKeys.translateString("prefab.gui.bridge_material"), (float)(x + 10), (float)(y + 10), this.textColor);
        if (this.chckIncludeRoof.isChecked()) {
            this.minecraft.field_71466_p.func_211126_b(GuiLangKeys.translateString("prefab.gui.bridge_interior_height"), (float)(x + 147), (float)(y + 80), this.textColor);
        }
        this.minecraft.field_71466_p.func_211126_b(GuiLangKeys.translateString("prefab.gui.bridge_length"), (float)(x + 147), (float)(y + 10), this.textColor);
    }

    @Override
    public void buttonClicked(Button button) {
        int sliderValue = this.sldrBridgeLength.getValueInt();
        if (sliderValue > 75) {
            sliderValue = 75;
        } else if (sliderValue < 25) {
            sliderValue = 25;
        }
        this.configuration.bridgeLength = sliderValue;
        sliderValue = this.sldrInteriorHeight.getValueInt();
        if (sliderValue > 8) {
            sliderValue = 8;
        } else if (sliderValue < 3) {
            sliderValue = 3;
        }
        this.configuration.interiorHeight = sliderValue;
        this.configuration.includeRoof = this.chckIncludeRoof.isChecked();
        this.configuration.houseFacing = this.player.func_174811_aO().func_176734_d();
        this.configuration.pos = this.pos;
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.chckIncludeRoof) {
            this.sldrInteriorHeight.visible = this.configuration.includeRoof = this.chckIncludeRoof.isChecked();
        }
        if (button == this.btnMaterialType) {
            this.configuration.bridgeMaterial = EnumStructureMaterial.getMaterialByNumber(this.configuration.bridgeMaterial.getNumber() + 1);
            this.btnMaterialType.setMessage(this.configuration.bridgeMaterial.getTranslatedName());
        } else if (button == this.btnVisualize) {
            StructureInstantBridge structure = new StructureInstantBridge();
            structure.getClearSpace().getShape().setDirection(Direction.SOUTH);
            structure.setupStructure(this.configuration, this.pos);
            StructureRenderHandler.setStructure(structure, Direction.SOUTH, this.configuration);
            assert (this.minecraft != null);
            this.minecraft.func_147108_a(null);
        }
    }
}

