/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.wuest.prefab.Config.ServerModConfiguration;
import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.Controls.GuiCheckBox;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Gui.GuiTabScreen;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Structures.Config.ModerateHouseConfiguration;
import com.wuest.prefab.Structures.Gui.GuiStructure;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructureModerateHouse;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import com.wuest.prefab.Tuple;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.DyeColor;
import net.minecraft.util.Direction;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class GuiModerateHouse
extends GuiStructure {
    protected ModerateHouseConfiguration configuration;
    protected ServerModConfiguration serverConfiguration;
    private GuiButtonExt btnHouseStyle;
    private GuiCheckBox btnAddChest;
    private GuiCheckBox btnAddChestContents;
    private GuiCheckBox btnAddMineShaft;
    private GuiButtonExt btnBedColor;
    private boolean allowItemsInChestAndFurnace = true;

    public GuiModerateHouse() {
        super("Moderate House");
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.ModerateHouse;
    }

    @Override
    protected void Initialize() {
        if (!Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            this.allowItemsInChestAndFurnace = !ClientEventHandler.playerConfig.builtStarterHouse;
        }
        this.serverConfiguration = Prefab.proxy.getServerConfiguration();
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("Moderate Houses", ModerateHouseConfiguration.class);
        this.configuration.pos = this.pos;
        int color = Color.DARK_GRAY.getRGB();
        int grayBoxX = this.getCenteredXAxis() - 212;
        int grayBoxY = this.getCenteredYAxis() - 83;
        this.btnHouseStyle = this.createAndAddButton(grayBoxX + 10, grayBoxY + 20, 90, 20, this.configuration.houseStyle.getDisplayName());
        this.btnVisualize = this.createAndAddButton(grayBoxX + 10, grayBoxY + 50, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.btnBuild = this.createAndAddButton(grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.btnCancel = this.createAndAddButton(grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
        int x = grayBoxX + 130;
        int y = grayBoxY + 20;
        this.btnBedColor = this.createAndAddButton(x, y, 90, 20, GuiLangKeys.translateDye(this.configuration.bedColor));
        this.btnAddChest = new GuiCheckBox(x, y += 30, GuiLangKeys.translateString("prefab.gui.starter.addchest"), this.configuration.addChests, null);
        this.btnAddChest.setStringColor(color);
        this.btnAddChest.setWithShadow(false);
        this.addButton((Widget)this.btnAddChest);
        this.btnAddMineShaft = new GuiCheckBox(x, y += 15, GuiLangKeys.translateString("prefab.gui.starter.buildmineshaft"), this.configuration.addChestContents, null);
        this.btnAddMineShaft.setStringColor(color);
        this.btnAddMineShaft.setWithShadow(false);
        this.addButton((Widget)this.btnAddMineShaft);
        this.btnAddChestContents = new GuiCheckBox(x, y += 15, GuiLangKeys.translateString("prefab.gui.starter.addchestcontents"), this.configuration.addMineshaft, null);
        this.btnAddChestContents.setStringColor(color);
        this.btnAddChestContents.setWithShadow(false);
        this.addButton((Widget)this.btnAddChestContents);
    }

    @Override
    protected Tuple<Integer, Integer> getAdjustedXYValue() {
        return new Tuple<Integer, Integer>(this.getCenteredXAxis() - 212, this.getCenteredYAxis() - 83);
    }

    @Override
    protected void preButtonRender(int x, int y) {
        super.preButtonRender(x, y);
        this.minecraft.func_110434_K().func_110577_a(this.configuration.houseStyle.getHousePicture());
        GuiTabScreen.drawModalRectWithCustomSizedTexture(x + 249, y, 1, this.configuration.houseStyle.getImageWidth(), this.configuration.houseStyle.getImageHeight(), this.configuration.houseStyle.getImageWidth(), this.configuration.houseStyle.getImageHeight());
    }

    @Override
    protected void postButtonRender(int x, int y) {
        this.btnAddChest.visible = this.serverConfiguration.addChests;
        this.btnAddChestContents.visible = this.allowItemsInChestAndFurnace && this.serverConfiguration.addChestContents;
        this.btnAddMineShaft.visible = this.serverConfiguration.addMineshaft;
        this.minecraft.field_71466_p.func_211126_b(GuiLangKeys.translateString("prefab.gui.starter.style.label"), (float)(x + 10), (float)(y + 10), this.textColor);
        this.minecraft.field_71466_p.func_211126_b(GuiLangKeys.translateString("prefab.gui.structure.bed_color"), (float)(x + 130), (float)(y + 10), this.textColor);
    }

    @Override
    public void buttonClicked(Button button) {
        this.configuration.addChests = this.btnAddChest.visible && this.btnAddChest.isChecked();
        this.configuration.addChestContents = this.allowItemsInChestAndFurnace && this.btnAddChestContents.visible && this.btnAddChestContents.isChecked();
        this.configuration.addMineshaft = this.btnAddMineShaft.visible && this.btnAddMineShaft.isChecked();
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnHouseStyle) {
            int id = this.configuration.houseStyle.getValue() + 1;
            this.configuration.houseStyle = ModerateHouseConfiguration.HouseStyle.ValueOf(id);
            this.btnHouseStyle.setMessage(this.configuration.houseStyle.getDisplayName());
        } else if (button == this.btnVisualize) {
            StructureModerateHouse structure = (StructureModerateHouse)StructureModerateHouse.CreateInstance(this.configuration.houseStyle.getStructureLocation(), StructureModerateHouse.class);
            StructureRenderHandler.setStructure(structure, Direction.NORTH, this.configuration);
            assert (this.minecraft != null);
            this.minecraft.func_147108_a(null);
        } else if (button == this.btnBedColor) {
            this.configuration.bedColor = DyeColor.func_196056_a((int)(this.configuration.bedColor.func_196059_a() + 1));
            this.btnBedColor.setMessage(GuiLangKeys.translateDye(this.configuration.bedColor));
        }
    }
}

