/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.wuest.prefab.Gui.GuiBase;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Proxy.CommonProxy;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Tuple;
import java.awt.Color;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public abstract class GuiStructure
extends GuiBase {
    public BlockPos pos;
    protected PlayerEntity player;
    protected GuiButtonExt btnCancel;
    protected GuiButtonExt btnBuild;
    protected GuiButtonExt btnVisualize;
    protected int textColor = Color.DARK_GRAY.getRGB();
    protected StructureTagMessage.EnumStructureConfiguration structureConfiguration;
    private Direction structureFacing;

    public GuiStructure(String title) {
        super(title);
    }

    public static void drawModalRectWithCustomSizedTexture(int x, int y, int z, int width, int height, float textureWidth, float textureHeight) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        float u = 0.0f;
        float v = 0.0f;
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a((double)(u * f), (double)((v + (float)height) * f1)).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a((double)((u + (float)width) * f), (double)((v + (float)height) * f1)).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)y, (double)z).func_187315_a((double)((u + (float)width) * f), (double)(v * f1)).func_181675_d();
        vertexBuffer.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    public void init() {
        this.player = this.getMinecraft().field_71439_g;
        this.structureFacing = this.player.func_174811_aO().func_176734_d();
        this.Initialize();
    }

    @Override
    protected void Initialize() {
    }

    public void checkVisualizationSetting() {
        if (!CommonProxy.proxyConfiguration.serverConfiguration.enableStructurePreview) {
            this.btnVisualize.visible = false;
        }
    }

    @Override
    public void render(int x, int y, float f) {
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        this.preButtonRender(adjustedXYValue.getFirst(), adjustedXYValue.getSecond());
        this.renderButtons(x, y);
        this.postButtonRender(adjustedXYValue.getFirst(), adjustedXYValue.getSecond());
        if (this.btnVisualize != null) {
            this.checkVisualizationSetting();
        }
    }

    @Override
    protected void preButtonRender(int x, int y) {
        this.renderBackground();
        this.drawControlBackground(x, y);
    }

    protected void performCancelOrBuildOrHouseFacing(StructureConfiguration configuration, Button button) {
        configuration.houseFacing = this.structureFacing;
        if (button == this.btnCancel) {
            this.getMinecraft().func_147108_a(null);
        } else if (button == this.btnBuild) {
            Prefab.network.sendToServer((Object)new StructureTagMessage(configuration.WriteToCompoundNBT(), this.structureConfiguration));
            this.getMinecraft().func_147108_a(null);
        }
    }
}

