/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Structures.Config.TreeFarmConfiguration;
import com.wuest.prefab.Structures.Gui.GuiStructure;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructureTreeFarm;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import com.wuest.prefab.Tuple;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class GuiTreeFarm
extends GuiStructure {
    private static final ResourceLocation structureTopDown = new ResourceLocation("prefab", "textures/gui/tree_farm_top_down.png");
    protected TreeFarmConfiguration configuration;

    public GuiTreeFarm() {
        super("Tree Farm");
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.TreeFarm;
    }

    @Override
    protected Tuple<Integer, Integer> getAdjustedXYValue() {
        return new Tuple<Integer, Integer>(this.getCenteredXAxis() - 213, this.getCenteredYAxis() - 83);
    }

    @Override
    protected void preButtonRender(int x, int y) {
        super.preButtonRender(x, y);
        this.minecraft.func_110434_K().func_110577_a(structureTopDown);
        GuiStructure.drawModalRectWithCustomSizedTexture(x + 250, y, 1, 177, 175, 177.0f, 175.0f);
    }

    @Override
    protected void postButtonRender(int x, int y) {
        this.minecraft.field_71466_p.func_78279_b(GuiLangKeys.translateString("prefab.gui.structure.block.clicked"), x + 147, y + 10, 100, this.textColor);
        this.minecraft.field_71466_p.func_78279_b(GuiLangKeys.translateString("prefab.gui.treefarm.structure.size"), x + 147, y + 50, 100, this.textColor);
    }

    @Override
    public void buttonClicked(Button button) {
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnVisualize) {
            StructureTreeFarm structure = (StructureTreeFarm)StructureTreeFarm.CreateInstance("assets/prefab/structures/treefarm.zip", StructureTreeFarm.class);
            StructureRenderHandler.setStructure(structure, Direction.NORTH, this.configuration);
            assert (this.minecraft != null);
            this.minecraft.func_147108_a(null);
        }
    }

    @Override
    protected void Initialize() {
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("Tree Farm", TreeFarmConfiguration.class);
        this.configuration.pos = this.pos;
        this.configuration.houseFacing = Direction.NORTH;
        int grayBoxX = this.getCenteredXAxis() - 213;
        int grayBoxY = this.getCenteredYAxis() - 83;
        this.btnVisualize = this.createAndAddButton(grayBoxX + 10, grayBoxY + 90, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.btnBuild = this.createAndAddButton(grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.btnCancel = this.createAndAddButton(grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
    }
}

