/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Gui.GuiTabScreen;
import com.wuest.prefab.Structures.Config.VillagerHouseConfiguration;
import com.wuest.prefab.Structures.Gui.GuiStructure;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructureVillagerHouses;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import com.wuest.prefab.Tuple;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.DyeColor;
import net.minecraft.util.Direction;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class GuiVillagerHouses
extends GuiStructure {
    protected VillagerHouseConfiguration configuration;
    private GuiButtonExt btnHouseStyle;
    private GuiButtonExt btnBedColor;
    private VillagerHouseConfiguration.HouseStyle houseStyle;

    public GuiVillagerHouses() {
        super("Villager Houses");
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.VillagerHouses;
    }

    @Override
    public void Initialize() {
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("Villager Houses", VillagerHouseConfiguration.class);
        this.configuration.pos = this.pos;
        this.configuration.houseFacing = Direction.NORTH;
        this.houseStyle = this.configuration.houseStyle;
        int grayBoxX = this.getCenteredXAxis() - 205;
        int grayBoxY = this.getCenteredYAxis() - 83;
        this.btnHouseStyle = this.createAndAddButton(grayBoxX + 10, grayBoxY + 20, 90, 20, this.houseStyle.getDisplayName());
        this.btnVisualize = this.createAndAddButton(grayBoxX + 10, grayBoxY + 60, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        int x = grayBoxX + 130;
        int y = grayBoxY + 20;
        this.btnBedColor = this.createAndAddButton(x, y, 90, 20, GuiLangKeys.translateDye(this.configuration.bedColor));
        this.btnBedColor.visible = this.houseStyle == VillagerHouseConfiguration.HouseStyle.LONG_HOUSE;
        this.btnBuild = this.createAndAddButton(grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.btnCancel = this.createAndAddButton(grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
    }

    @Override
    protected Tuple<Integer, Integer> getAdjustedXYValue() {
        return new Tuple<Integer, Integer>(this.getCenteredXAxis() - 205, this.getCenteredYAxis() - 83);
    }

    @Override
    protected void preButtonRender(int x, int y) {
        super.preButtonRender(x, y);
        this.minecraft.func_110434_K().func_110577_a(this.houseStyle.getHousePicture());
        GuiTabScreen.drawModalRectWithCustomSizedTexture(x + 250, y, 1, this.houseStyle.getImageWidth(), this.houseStyle.getImageHeight(), this.houseStyle.getImageWidth(), this.houseStyle.getImageHeight());
    }

    @Override
    protected void postButtonRender(int x, int y) {
        this.minecraft.field_71466_p.func_211126_b(GuiLangKeys.translateString("prefab.gui.starter.style.label"), (float)(x + 10), (float)(y + 10), this.textColor);
        if (this.houseStyle == VillagerHouseConfiguration.HouseStyle.LONG_HOUSE) {
            this.minecraft.field_71466_p.func_211126_b(GuiLangKeys.translateString("prefab.gui.structure.bed_color"), (float)(x + 130), (float)(y + 10), this.textColor);
        }
    }

    @Override
    public void buttonClicked(Button button) {
        this.configuration.houseStyle = this.houseStyle;
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnHouseStyle) {
            int id = this.houseStyle.getValue() + 1;
            this.houseStyle = VillagerHouseConfiguration.HouseStyle.ValueOf(id);
            this.btnHouseStyle.setMessage(this.houseStyle.getDisplayName());
            this.btnBedColor.visible = this.houseStyle == VillagerHouseConfiguration.HouseStyle.LONG_HOUSE;
        } else if (button == this.btnVisualize) {
            StructureVillagerHouses structure = (StructureVillagerHouses)StructureVillagerHouses.CreateInstance(this.houseStyle.getStructureLocation(), StructureVillagerHouses.class);
            StructureRenderHandler.setStructure(structure, Direction.NORTH, this.configuration);
            assert (this.minecraft != null);
            this.minecraft.func_147108_a(null);
        } else if (button == this.btnBedColor) {
            this.configuration.bedColor = DyeColor.func_196056_a((int)(this.configuration.bedColor.func_196059_a() + 1));
            this.btnBedColor.setMessage(GuiLangKeys.translateDye(this.configuration.bedColor));
        }
    }
}

