/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Messages;

import com.wuest.prefab.Proxy.Messages.TagMessage;
import com.wuest.prefab.Structures.Config.BasicStructureConfiguration;
import com.wuest.prefab.Structures.Config.BulldozerConfiguration;
import com.wuest.prefab.Structures.Config.ChickenCoopConfiguration;
import com.wuest.prefab.Structures.Config.FishPondConfiguration;
import com.wuest.prefab.Structures.Config.HorseStableConfiguration;
import com.wuest.prefab.Structures.Config.HouseConfiguration;
import com.wuest.prefab.Structures.Config.InstantBridgeConfiguration;
import com.wuest.prefab.Structures.Config.ModerateHouseConfiguration;
import com.wuest.prefab.Structures.Config.MonsterMasherConfiguration;
import com.wuest.prefab.Structures.Config.NetherGateConfiguration;
import com.wuest.prefab.Structures.Config.ProduceFarmConfiguration;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import com.wuest.prefab.Structures.Config.StructurePartConfiguration;
import com.wuest.prefab.Structures.Config.TreeFarmConfiguration;
import com.wuest.prefab.Structures.Config.VillagerHouseConfiguration;
import com.wuest.prefab.Structures.Config.WareHouseConfiguration;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;

public class StructureTagMessage
extends TagMessage {
    private EnumStructureConfiguration structureConfig;

    public StructureTagMessage() {
    }

    public StructureTagMessage(CompoundNBT tagMessage, EnumStructureConfiguration structureConfig) {
        super(tagMessage);
        this.structureConfig = structureConfig;
    }

    public static StructureTagMessage decode(PacketBuffer buf) {
        CompoundNBT tag = buf.func_150793_b();
        StructureTagMessage returnValue = new StructureTagMessage();
        returnValue.structureConfig = EnumStructureConfiguration.getFromIdentifier(tag.func_74762_e("config"));
        returnValue.tagMessage = tag.func_74775_l("dataTag");
        return returnValue;
    }

    public static void encode(StructureTagMessage message, PacketBuffer buf) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("config", message.structureConfig.identifier);
        tag.func_218657_a("dataTag", (INBT)message.tagMessage);
        buf.func_150786_a(tag);
    }

    EnumStructureConfiguration getStructureConfig() {
        return this.structureConfig;
    }

    public static enum EnumStructureConfiguration {
        Basic(0, new BasicStructureConfiguration()),
        ChickenCoop(1, new ChickenCoopConfiguration()),
        AdvancedWareHouse(2, new WareHouseConfiguration()),
        FishPond(3, new FishPondConfiguration()),
        HorseStable(4, new HorseStableConfiguration()),
        MonsterMasher(6, new MonsterMasherConfiguration()),
        NetherGate(7, new NetherGateConfiguration()),
        ProduceFarm(8, new ProduceFarmConfiguration()),
        StartHouse(9, new HouseConfiguration()),
        TreeFarm(10, new TreeFarmConfiguration()),
        VillagerHouses(11, new VillagerHouseConfiguration()),
        WareHouse(12, new WareHouseConfiguration()),
        ModerateHouse(13, new ModerateHouseConfiguration()),
        Bulldozer(14, new BulldozerConfiguration()),
        InstantBridge(15, new InstantBridgeConfiguration()),
        Parts(16, new StructurePartConfiguration());

        public int identifier;
        public StructureConfiguration structureConfig;

        private <T extends StructureConfiguration> EnumStructureConfiguration(int identifier, T structureConfig) {
            this.identifier = identifier;
            this.structureConfig = structureConfig;
        }

        public static EnumStructureConfiguration getFromIdentifier(int identifier) {
            for (EnumStructureConfiguration config : EnumStructureConfiguration.values()) {
                if (config.identifier != identifier) continue;
                return config;
            }
            return Basic;
        }
    }
}

