/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Predefined;

import com.wuest.prefab.Proxy.CommonProxy;
import com.wuest.prefab.Structures.Base.BuildBlock;
import com.wuest.prefab.Structures.Base.BuildClear;
import com.wuest.prefab.Structures.Base.Structure;
import com.wuest.prefab.Structures.Config.MonsterMasherConfiguration;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.WallSignBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class StructureMonsterMasher
extends Structure {
    public static final String ASSETLOCATION = "assets/prefab/structures/monster_masher.zip";
    private ArrayList<BlockPos> mobSpawnerPos = new ArrayList();
    private BlockPos signPosition = null;

    public static void ScanStructure(World world, BlockPos originalPos, Direction playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(Direction.SOUTH);
        clearedSpace.getShape().setHeight(18);
        clearedSpace.getShape().setLength(15);
        clearedSpace.getShape().setWidth(13);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(6);
        Structure.ScanStructure(world, originalPos, originalPos.func_177965_g(6).func_177968_d(), originalPos.func_177970_e(15).func_177985_f(6).func_177981_b(18), "..\\src\\main\\resources\\assets\\prefab\\structures\\monster_masher.zip", clearedSpace, playerFacing, false, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, World world, BlockPos originalPos, Direction assumedNorth, Block foundBlock, BlockState blockState, PlayerEntity player) {
        if (foundBlock.getRegistryName().func_110624_b().equals(Blocks.field_196807_gj.getRegistryName().func_110624_b()) && foundBlock.getRegistryName().func_110623_a().endsWith("stained_glass")) {
            MonsterMasherConfiguration wareHouseConfiguration = (MonsterMasherConfiguration)configuration;
            blockState = this.getStainedGlassBlock(wareHouseConfiguration.dyeColor);
            block.setBlockState(blockState);
            this.priorityOneBlocks.add(block);
            return true;
        }
        if (foundBlock.getRegistryName().func_110624_b().equals(Blocks.field_150474_ac.getRegistryName().func_110624_b()) && foundBlock.getRegistryName().func_110623_a().equals(Blocks.field_150474_ac.getRegistryName().func_110623_a())) {
            if (!CommonProxy.proxyConfiguration.serverConfiguration.includeSpawnersInMasher) return true;
            this.mobSpawnerPos.add(block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing));
            return false;
        } else {
            if (!(foundBlock instanceof WallSignBlock)) return false;
            this.signPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        }
        return false;
    }

    @Override
    public void AfterBuilding(StructureConfiguration configuration, ServerWorld world, BlockPos originalPos, Direction assumedNorth, PlayerEntity player) {
        TileEntity tileEntity;
        int monstersPlaced = 0;
        for (BlockPos pos : this.mobSpawnerPos) {
            TileEntity tileEntity2 = world.func_175625_s(pos);
            if (!(tileEntity2 instanceof MobSpawnerTileEntity)) continue;
            MobSpawnerTileEntity spawner = (MobSpawnerTileEntity)tileEntity2;
            switch (monstersPlaced) {
                case 0: {
                    spawner.func_145881_a().func_200876_a(EntityType.field_200725_aD);
                    break;
                }
                case 1: {
                    spawner.func_145881_a().func_200876_a(EntityType.field_200741_ag);
                    break;
                }
                case 2: {
                    spawner.func_145881_a().func_200876_a(EntityType.field_200748_an);
                    break;
                }
                default: {
                    spawner.func_145881_a().func_200876_a(EntityType.field_200797_k);
                }
            }
            ++monstersPlaced;
        }
        if (this.signPosition != null && (tileEntity = world.func_175625_s(this.signPosition)) instanceof SignTileEntity) {
            SignTileEntity signTile = (SignTileEntity)tileEntity;
            signTile.field_145915_a[0] = new StringTextComponent("Lamp On=Mobs");
            signTile.field_145915_a[2] = new StringTextComponent("Lamp Off=No Mobs");
        }
    }
}

