/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.wuest.prefab.Proxy.CommonProxy;
import com.wuest.prefab.Structures.Base.BuildBlock;
import com.wuest.prefab.Structures.Base.Structure;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import com.wuest.prefab.Structures.Render.ShaderHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.ChestRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class StructureRenderHandler {
    private static final ChestRenderer chestRenderer = new ChestRenderer();
    public static StructureConfiguration currentConfiguration;
    public static Structure currentStructure;
    public static Direction assumedNorth;
    public static boolean rendering;
    public static boolean showedMessage;
    private static int dimension;

    public static void setStructure(Structure structure, Direction assumedNorth, StructureConfiguration configuration) {
        currentStructure = structure;
        StructureRenderHandler.assumedNorth = assumedNorth;
        currentConfiguration = configuration;
        showedMessage = false;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            dimension = mc.field_71441_e.func_201675_m().func_186058_p().func_186068_a();
        }
    }

    public static void renderPlayerLook(PlayerEntity player, RayTraceResult src) {
        if (currentStructure != null && dimension == player.field_70170_p.func_201675_m().func_186058_p().func_186068_a() && currentConfiguration != null && CommonProxy.proxyConfiguration.serverConfiguration.enableStructurePreview) {
            GlStateManager.pushMatrix();
            GL11.glPushAttrib((int)64);
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)770, (int)771);
            GlStateManager.disableLighting();
            rendering = true;
            boolean didAny = false;
            ShaderHelper.useShader(ShaderHelper.alphaShader);
            for (BuildBlock buildBlock : currentStructure.getBlocks()) {
                BlockState blockState;
                Block foundBlock = (Block)Registry.field_212618_g.func_82594_a(buildBlock.getResourceLocation());
                if (foundBlock == null || !StructureRenderHandler.renderComponentInWorld(player.field_70170_p, buildBlock = BuildBlock.SetBlockState(currentConfiguration, player.field_70170_p, StructureRenderHandler.currentConfiguration.pos, assumedNorth, buildBlock, foundBlock, blockState = foundBlock.func_176223_P(), currentStructure))) continue;
                didAny = true;
            }
            ShaderHelper.releaseShader();
            rendering = false;
            GL11.glPopAttrib();
            GlStateManager.popMatrix();
            if (!didAny) {
                StructureRenderHandler.setStructure(null, Direction.NORTH, null);
                player.func_145747_a(new TranslationTextComponent("prefab.gui.preview.complete", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            } else if (!showedMessage) {
                player.func_145747_a(new TranslationTextComponent("prefab.gui.preview.notice", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
                showedMessage = true;
            }
        }
    }

    private static boolean renderComponentInWorld(World world, BuildBlock buildBlock) {
        double renderPosX = Minecraft.func_71410_x().func_175598_ae().field_78725_b;
        double renderPosY = Minecraft.func_71410_x().func_175598_ae().field_78726_c;
        double renderPosZ = Minecraft.func_71410_x().func_175598_ae().field_78723_d;
        BlockPos pos = buildBlock.getStartingPosition().getRelativePosition(StructureRenderHandler.currentConfiguration.pos, currentStructure.getClearSpace().getShape().getDirection(), StructureRenderHandler.currentConfiguration.houseFacing);
        if (!world.func_175623_d(pos)) {
            return false;
        }
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(-renderPosX), (double)(-renderPosY), (double)(-renderPosZ));
        StructureRenderHandler.doRenderComponent(buildBlock, pos);
        GlStateManager.popMatrix();
        if (buildBlock.getSubBlock() != null) {
            Block foundBlock = (Block)Registry.field_212618_g.func_82594_a(buildBlock.getSubBlock().getResourceLocation());
            BlockState blockState = foundBlock.func_176223_P();
            BuildBlock subBlock = BuildBlock.SetBlockState(currentConfiguration, world, StructureRenderHandler.currentConfiguration.pos, assumedNorth, buildBlock.getSubBlock(), foundBlock, blockState, currentStructure);
            return StructureRenderHandler.renderComponentInWorld(world, subBlock);
        }
        return true;
    }

    private static void doRenderComponent(BuildBlock buildBlock, BlockPos pos) {
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        BlockState state = buildBlock.getBlockState();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        if (state == null) {
            GlStateManager.popMatrix();
            return;
        }
        GlStateManager.translated((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 1));
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        StructureRenderHandler.renderBlockBrightness(state, 1.0f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }

    public static void renderBlockBrightness(BlockState state, float brightness) {
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        BlockRenderType blockrendertype = state.func_185901_i();
        if (blockrendertype != BlockRenderType.INVISIBLE) {
            switch (blockrendertype) {
                case MODEL: {
                    IBakedModel ibakedmodel = brd.func_184389_a(state);
                    try {
                        brd.func_175019_b().func_178266_a(ibakedmodel, state, brightness, true);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    chestRenderer.func_178175_a(state.func_177230_c(), brightness);
                }
            }
        }
    }

    static {
        rendering = false;
        showedMessage = false;
    }
}

