/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Blocks;

import com.wuest.prefab.Events.ModEventHandler;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockBoundary
extends Block {
    public static final BooleanProperty Powered = BooleanProperty.func_177716_a((String)"powered");
    public final ItemGroup itemGroup = ItemGroup.field_78030_b;

    public BlockBoundary(String name) {
        super(Block.Properties.func_200945_a((Material)Prefab.SeeThroughImmovable).func_200947_a(SoundType.field_185851_d).func_200943_b(0.6f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)Powered, (Comparable)Boolean.valueOf(false)));
        ModRegistry.setBlockName(this, name);
    }

    public static boolean canRenderInLayer(Object layer) {
        boolean powered = false;
        RenderState renderState = (RenderState)layer;
        return layer == RenderType.func_228645_f_() && !powered || layer == RenderType.func_228639_c_() && powered;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{Powered});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        boolean powered = (Boolean)state.func_177229_b((IProperty)Powered);
        return powered ? BlockRenderType.MODEL : BlockRenderType.INVISIBLE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        boolean powered = (Boolean)state.func_177229_b((IProperty)Powered);
        return powered ? VoxelShapes.func_197868_b() : VoxelShapes.func_197880_a();
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        boolean returnValue = super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        ModEventHandler.RedstoneAffectedBlockPositions.remove(pos);
        boolean poweredSide = world.func_175640_z(pos);
        if (poweredSide) {
            this.setNeighborGlassBlocksPoweredStatus(world, pos, false, 0, new ArrayList<BlockPos>(), false);
        }
        return returnValue;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean poweredSide = context.func_195991_k().func_175640_z(context.func_195995_a());
        if (poweredSide) {
            this.setNeighborGlassBlocksPoweredStatus(context.func_195991_k(), context.func_195995_a(), true, 0, new ArrayList<BlockPos>(), false);
        }
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)Powered, (Comparable)Boolean.valueOf(poweredSide));
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos p_189540_5_, boolean p_220069_6_) {
        if (!worldIn.field_72995_K && blockIn.func_176223_P().func_185897_m()) {
            boolean poweredSide = worldIn.func_175640_z(pos);
            this.setNeighborGlassBlocksPoweredStatus(worldIn, pos, poweredSide, 0, new ArrayList<BlockPos>(), true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, worldIn, tooltip, advanced);
        boolean advancedKeyDown = Screen.hasShiftDown();
        if (!advancedKeyDown) {
            tooltip.add((ITextComponent)new StringTextComponent(GuiLangKeys.translateString("prefab.gui.tooltip.shift")));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(GuiLangKeys.translateString("prefab.gui.tooltip.boundary_block")));
        }
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        boolean powered = (Boolean)state.func_177229_b((IProperty)Powered);
        if (powered && state.func_200015_d(worldIn, pos)) {
            return worldIn.func_201572_C();
        }
        return state.func_200131_a(worldIn, pos) ? 0 : 1;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        boolean powered = (Boolean)state.func_177229_b((IProperty)Powered);
        return !powered || !BlockBoundary.func_208062_a((VoxelShape)state.func_196954_c(reader, pos)) && state.func_204520_s().func_206888_e();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197868_b();
    }

    @Deprecated
    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        if (!((Boolean)state.func_177229_b((IProperty)Powered)).booleanValue()) {
            return VoxelShapes.func_197880_a();
        }
        return VoxelShapes.func_197868_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return (Boolean)state.func_177229_b((IProperty)Powered) == false;
    }

    protected void setNeighborGlassBlocksPoweredStatus(World world, BlockPos pos, boolean isPowered, int cascadeCount, ArrayList<BlockPos> cascadedBlockPos, boolean setCurrentBlock) {
        if (++cascadeCount > 100) {
            return;
        }
        if (setCurrentBlock) {
            BlockState state = world.func_180495_p(pos);
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)Powered, (Comparable)Boolean.valueOf(isPowered)));
        }
        cascadedBlockPos.add(pos);
        for (Direction facing : Direction.values()) {
            Block neighborBlock = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
            if (!(neighborBlock instanceof BlockBoundary) || cascadedBlockPos.contains(pos.func_177972_a(facing))) continue;
            ((BlockBoundary)neighborBlock).setNeighborGlassBlocksPoweredStatus(world, pos.func_177972_a(facing), isPowered, cascadeCount, cascadedBlockPos, true);
        }
    }
}

