/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Gui.Controls;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class GuiCheckBox
extends CheckboxButton {
    protected int boxWidth = 11;
    protected int stringColor;
    protected boolean withShadow;
    protected Minecraft mineCraft = Minecraft.func_71410_x();
    protected String displayString;
    protected IPressable handler;

    public GuiCheckBox(int xPos, int yPos, String displayString, boolean isChecked, IPressable handler) {
        super(xPos, yPos, 11, 12, displayString, isChecked);
        this.displayString = displayString;
        this.stringColor = Color.DARK_GRAY.getRGB();
        this.handler = handler;
    }

    public int getStringColor() {
        return this.stringColor;
    }

    public GuiCheckBox setStringColor(int color) {
        this.stringColor = color;
        return this;
    }

    public void onPress() {
        super.onPress();
        if (this.handler != null) {
            this.handler.onPress(this);
        }
    }

    public boolean getWithShadow() {
        return this.withShadow;
    }

    public GuiCheckBox setWithShadow(boolean value) {
        this.withShadow = value;
        return this;
    }

    public void renderButton(int mouseX, int mouseY, float partial) {
        if (this.visible) {
            this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.boxWidth && mouseY < this.y + this.height;
            GuiUtils.drawContinuousTexturedBox((ResourceLocation)WIDGETS_LOCATION, (int)this.x, (int)this.y, (int)0, (int)46, (int)this.boxWidth, (int)this.height, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.getBlitOffset());
            int color = this.stringColor;
            if (this.packedFGColor != 0) {
                color = this.packedFGColor;
            } else if (!this.active) {
                color = 0xA0A0A0;
            }
            if (this.func_212942_a()) {
                this.drawCenteredString(this.mineCraft.field_71466_p, "x", this.x + this.boxWidth / 2 + 1, this.y + 1, 0xE0E0E0);
            }
            if (this.withShadow) {
                this.drawString(this.mineCraft.field_71466_p, this.displayString, this.x + this.boxWidth + 2, this.y + 2, color);
            } else {
                this.mineCraft.field_71466_p.func_211126_b(this.displayString, (float)(this.x + this.boxWidth + 2), (float)(this.y + 2), color);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IPressable {
        public void onPress(GuiCheckBox var1);
    }
}

