/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Config;

import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import com.wuest.prefab.Structures.Predefined.StructureModerateHouse;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class ModerateHouseConfiguration
extends StructureConfiguration {
    public static String tagKey = "houseConfig";
    private static String houseStyleTag = "houseStyle";
    private static String addChestTag = "addChests";
    private static String addChestContentsTag = "addChestContents";
    private static String addMineshaftTag = "addMineshaft";
    private static String bedColorTag = "bedColor";
    public HouseStyle houseStyle = HouseStyle.SPRUCE_HOME;
    public boolean addChests = true;
    public boolean addChestContents = true;
    public boolean addMineshaft = true;
    public DyeColor bedColor = DyeColor.RED;

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseStyle = HouseStyle.SPRUCE_HOME;
        this.bedColor = DyeColor.RED;
    }

    @Override
    protected CompoundNBT CustomWriteToCompoundNBT(CompoundNBT tag) {
        tag.func_74768_a(houseStyleTag, this.houseStyle.value);
        tag.func_74757_a(addChestTag, this.addChests);
        tag.func_74757_a(addChestContentsTag, this.addChestContents);
        tag.func_74757_a(addMineshaftTag, this.addMineshaft);
        tag.func_74778_a(bedColorTag, this.bedColor.func_176610_l().toUpperCase());
        return tag;
    }

    @Override
    protected void CustomReadFromNBTTag(CompoundNBT messageTag, StructureConfiguration config) {
        ModerateHouseConfiguration houseConfiguration = (ModerateHouseConfiguration)config;
        if (messageTag.func_74764_b(houseStyleTag)) {
            houseConfiguration.houseStyle = HouseStyle.ValueOf(messageTag.func_74762_e(houseStyleTag));
        }
        if (messageTag.func_74764_b(addChestTag)) {
            houseConfiguration.addChests = messageTag.func_74767_n(addChestTag);
        }
        if (messageTag.func_74764_b(addChestContentsTag)) {
            houseConfiguration.addChestContents = messageTag.func_74767_n(addChestContentsTag);
        }
        if (messageTag.func_74764_b(addMineshaftTag)) {
            houseConfiguration.addMineshaft = messageTag.func_74767_n(addMineshaftTag);
        }
        if (messageTag.func_74764_b(bedColorTag)) {
            houseConfiguration.bedColor = DyeColor.valueOf((String)messageTag.func_74779_i(bedColorTag));
        }
    }

    @Override
    public ModerateHouseConfiguration ReadFromCompoundNBT(CompoundNBT messageTag) {
        ModerateHouseConfiguration config = new ModerateHouseConfiguration();
        return (ModerateHouseConfiguration)super.ReadFromCompoundNBT(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(PlayerEntity player, ServerWorld world, BlockPos hitBlockPos) {
        StructureModerateHouse structure = (StructureModerateHouse)StructureModerateHouse.CreateInstance(this.houseStyle.getStructureLocation(), StructureModerateHouse.class);
        if (structure.BuildStructure(this, world, hitBlockPos, Direction.NORTH, player)) {
            this.RemoveStructureItemFromPlayer(player, ModRegistry.ModerateHouse());
        }
    }

    public static enum HouseStyle {
        SPRUCE_HOME(0, "prefab.gui.moderate_house.spruce", new ResourceLocation("prefab", "textures/gui/moderate_house_spruce_topdown.png"), 176, 154, "assets/prefab/structures/moderate_house_spruce.zip", 31, 31, 23, 8, 1),
        ACACIA_HOME(1, "prefab.gui.moderate_house.acacia", new ResourceLocation("prefab", "textures/gui/moderate_house_acacia_topdown.png"), 176, 154, "assets/prefab/structures/moderate_house_acacia.zip", 31, 31, 21, 12, 6),
        EARTHEN_HOME(2, "prefab.gui.moderate_house.earth", new ResourceLocation("prefab", "textures/gui/moderate_house_earthen_topdown.png"), 174, 146, "assets/prefab/structures/moderate_house_earthen.zip", 16, 16, 16, 8, 6),
        JUNGLE_TREE_HOME(3, "prefab.gui.moderate_house.jungle", new ResourceLocation("prefab", "textures/gui/moderate_house_jungle_topdown.png"), 88, 164, "assets/prefab/structures/moderate_house_jungle.zip", 16, 16, 41, 8, 1),
        WORKSHOP_HOME(4, "prefab.gui.moderate_house.workshop", new ResourceLocation("prefab", "textures/gui/moderate_house_workshop_topdown.png"), 174, 131, "assets/prefab/structures/moderate_house_workshop.zip", 29, 21, 19, 14, 0);

        private final int value;
        private final String displayName;
        private final ResourceLocation housePicture;
        private final int imageWidth;
        private final int imageHeight;
        private final String structureLocation;
        private final int width;
        private final int length;
        private final int height;
        private final int eastOffSet;
        private final int downOffSet;

        private HouseStyle(int newValue, String displayName, ResourceLocation housePicture, int imageWidth, int imageHeight, String structureLocation, int width, int length, int height, int eastOffSet, int downOffSet) {
            this.value = newValue;
            this.displayName = displayName;
            this.housePicture = housePicture;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.structureLocation = structureLocation;
            this.width = width;
            this.length = length;
            this.height = height;
            this.eastOffSet = eastOffSet;
            this.downOffSet = downOffSet;
        }

        public static HouseStyle ValueOf(int value) {
            switch (value) {
                case 1: {
                    return ACACIA_HOME;
                }
                case 2: {
                    return EARTHEN_HOME;
                }
                case 3: {
                    return JUNGLE_TREE_HOME;
                }
                case 4: {
                    return WORKSHOP_HOME;
                }
            }
            return SPRUCE_HOME;
        }

        public int getValue() {
            return this.value;
        }

        public String getDisplayName() {
            return GuiLangKeys.translateString(this.displayName);
        }

        public ResourceLocation getHousePicture() {
            return this.housePicture;
        }

        public int getImageWidth() {
            return this.imageWidth;
        }

        public int getImageHeight() {
            return this.imageHeight;
        }

        public int getWidth() {
            return this.width;
        }

        public int getLength() {
            return this.length;
        }

        public int getHeight() {
            return this.height;
        }

        public int getEastOffSet() {
            return this.eastOffSet;
        }

        public int getDownOffSet() {
            return this.downOffSet;
        }

        public String getStructureLocation() {
            return this.structureLocation;
        }
    }
}

